/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import abstraction.Service;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jgraph.JGraph;
import presentation.ChoiceLayoutDialog;
import presentation.OrchestratorFrame;
import presentation.graph.GraphFactory;
import presentation.util.Exporter;

public class CartesianProductPanel
extends JPanel {
    private static final long serialVersionUID = 971167226552503028L;
    private OrchestratorFrame owner = null;
    private JButton changeRepresentationButton = null;
    private JButton saveToImageButton = null;
    private JButton saveToDotButton = null;
    private JButton showProductButton = null;
    private JLabel cartesianProductLabel = null;
    private JLabel statusLabel = null;
    private JScrollPane cartesianProductScrollPane = null;
    private JGraph cartesianProductGraph = null;
    private Service cartesianProduct = null;

    public CartesianProductPanel(OrchestratorFrame frame) {
        this.initialize();
        this.owner = frame;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints12.ipadx = 14;
        gridBagConstraints12.gridy = 4;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints11.ipadx = 52;
        gridBagConstraints11.gridy = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 10.0;
        gridBagConstraints5.weighty = 10.0;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints5.gridheight = 6;
        gridBagConstraints5.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Cartesian Product");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.ipadx = 38;
        gridBagConstraints2.gridy = 3;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.ipadx = 43;
        gridBagConstraints1.gridy = 0;
        this.cartesianProductLabel = new JLabel();
        this.cartesianProductLabel.setText("Cartesian Product");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 49;
        gridBagConstraints.gridy = 2;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSaveToImageButton(), gridBagConstraints);
        this.add((Component)this.cartesianProductLabel, gridBagConstraints1);
        this.add((Component)this.getSaveToDotButton(), gridBagConstraints2);
        this.add((Component)this.statusLabel, gridBagConstraints3);
        this.add((Component)this.getCartesianProductScrollPane(), gridBagConstraints5);
        this.add((Component)this.getShowProductButton(), gridBagConstraints11);
        this.add((Component)this.getChangeRepresentationButton(), gridBagConstraints12);
    }

    private JButton getSaveToImageButton() {
        if (this.saveToImageButton == null) {
            this.saveToImageButton = new JButton();
            this.saveToImageButton.setText("Save To Image");
            this.saveToImageButton.setToolTipText("Save the graph in a jpeg file");
            this.saveToImageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    if (CartesianProductPanel.this.cartesianProductGraph != null && (file = CartesianProductPanel.this.saveImageFile()) != null) {
                        Exporter.exportToImage(file, CartesianProductPanel.this.cartesianProductGraph);
                    }
                }
            });
        }
        return this.saveToImageButton;
    }

    private JButton getSaveToDotButton() {
        if (this.saveToDotButton == null) {
            this.saveToDotButton = new JButton();
            this.saveToDotButton.setText("Save To DOT File");
            this.saveToDotButton.setToolTipText("Save the graph in DOT format");
            this.saveToDotButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    if (CartesianProductPanel.this.cartesianProduct != null && (file = CartesianProductPanel.this.saveDotFile()) != null) {
                        Exporter.exportToDot(file, CartesianProductPanel.this.cartesianProduct);
                    }
                }
            });
        }
        return this.saveToDotButton;
    }

    private JScrollPane getCartesianProductScrollPane() {
        if (this.cartesianProductScrollPane == null) {
            this.cartesianProductScrollPane = new JScrollPane();
            this.cartesianProductScrollPane.setViewportView(null);
        }
        return this.cartesianProductScrollPane;
    }

    private JButton getShowProductButton() {
        if (this.showProductButton == null) {
            this.showProductButton = new JButton();
            this.showProductButton.setText("Show Product");
            this.showProductButton.setToolTipText("Show the cartesian product");
            this.showProductButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!CartesianProductPanel.this.owner.isAvailableLoaded()) {
                        JOptionPane.showMessageDialog(CartesianProductPanel.this.owner, "No available services loades", "Warning", 2);
                    } else {
                        int opt = JOptionPane.showConfirmDialog(CartesianProductPanel.this.owner, "Expensive operation", "Warning", 0, 3);
                        if (opt == 0) {
                            long time = System.currentTimeMillis();
                            CartesianProductPanel.this.cartesianProduct = CartesianProductPanel.this.owner.getProduct();
                            CartesianProductPanel.this.cartesianProductGraph = new GraphFactory(CartesianProductPanel.this.cartesianProduct).getGraph();
                            CartesianProductPanel.this.cartesianProductScrollPane.setViewportView(CartesianProductPanel.this.cartesianProductGraph);
                            time = System.currentTimeMillis() - time;
                            long ms = time % 1000L;
                            long sec = (time /= 1000L) % 60L;
                            long min = (time /= 60L) % 60L;
                            String mess = "Elapsed Time: " + (time /= 60L) + " hours, " + min + " minutes, " + sec + " seconds, " + ms + " milliseconds";
                            JOptionPane.showMessageDialog(CartesianProductPanel.this.owner, mess, "Time", 1);
                        }
                    }
                }
            });
        }
        return this.showProductButton;
    }

    private File saveImageFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JPEG File", "jpeg");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private File saveDotFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("DOT File", "dot");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private JButton getChangeRepresentationButton() {
        if (this.changeRepresentationButton == null) {
            this.changeRepresentationButton = new JButton();
            this.changeRepresentationButton.setText("Change Visualization");
            this.changeRepresentationButton.setToolTipText("Change the layout of the graph");
            this.changeRepresentationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChoiceLayoutDialog dialog;
                    String layout;
                    if (CartesianProductPanel.this.cartesianProductGraph != null && (layout = (dialog = new ChoiceLayoutDialog(CartesianProductPanel.this.owner)).getGraphLayout()) != null) {
                        GraphFactory.changeRepresentation(CartesianProductPanel.this.cartesianProductGraph, layout);
                    }
                }
            });
        }
        return this.changeRepresentationButton;
    }
}

