/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import abstraction.AvailableServices;
import abstraction.ReadFile;
import abstraction.Service;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jgraph.JGraph;
import presentation.OrchestratorFrame;
import presentation.graph.GraphFactory;
import presentation.util.Exporter;

public class AvailablePanel
extends JPanel {
    private static final long serialVersionUID = -9064608565705075447L;
    private OrchestratorFrame owner;
    private JLabel availableLabel = null;
    private JLabel statusLabel = null;
    private JButton addServicesButton = null;
    private JButton removeServiceButton = null;
    private JButton removeAllButton = null;
    private JButton saveToImageButton = null;
    private JButton saveToDotButton = null;
    private JScrollPane graphScrollPane = null;
    private JScrollPane listScrollPane = null;
    private JList servicesList = null;
    private DefaultListModel servicesListModel = null;
    private List<JGraph> availableGraphs;
    private boolean availableLoaded;
    private AvailableServices services;

    public AvailableServices getServices() {
        return this.services;
    }

    public AvailablePanel(OrchestratorFrame frame) {
        this.owner = frame;
        this.services = new AvailableServices();
        this.servicesListModel = new DefaultListModel();
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.gridy = 6;
        gridBagConstraints12.weightx = 0.0;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.ipadx = 10;
        gridBagConstraints12.gridheight = 3;
        gridBagConstraints12.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints12.gridwidth = 1;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.gridx = 0;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridy = 1;
        gridBagConstraints31.fill = 1;
        gridBagConstraints31.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints31.gridheight = 9;
        gridBagConstraints31.weightx = 10.0;
        gridBagConstraints31.weighty = 10.0;
        gridBagConstraints31.gridx = 1;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 0;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.gridx = 2;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.gridwidth = 1;
        gridBagConstraints21.anchor = 13;
        gridBagConstraints21.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.weightx = 10.0;
        gridBagConstraints21.gridy = 0;
        this.statusLabel = new JLabel();
        this.statusLabel.setText("No available service loaded");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints5.ipadx = 38;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridy = 5;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints4.ipadx = 49;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 4;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.ipadx = 16;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridy = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints2.ipadx = 40;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints1.ipadx = 29;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.availableLabel = new JLabel();
        this.availableLabel.setText("Available Services");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(360, 317));
        this.add((Component)this.availableLabel, gridBagConstraints);
        this.add((Component)this.getAddServicesButton(), gridBagConstraints1);
        this.add((Component)this.getRemoveServiceButton(), gridBagConstraints2);
        this.add((Component)this.getRemoveAllButton(), gridBagConstraints3);
        this.add((Component)this.getSaveToImageButton(), gridBagConstraints4);
        this.add((Component)this.getSaveToDotButton(), gridBagConstraints5);
        this.add((Component)this.statusLabel, gridBagConstraints21);
        this.add((Component)this.getGraphScrollPane(), gridBagConstraints31);
        this.add((Component)this.getListScrollPane(), gridBagConstraints12);
    }

    private JButton getAddServicesButton() {
        if (this.addServicesButton == null) {
            this.addServicesButton = new JButton();
            this.addServicesButton.setText("Add New Services");
            this.addServicesButton.setToolTipText("Add one or more available service(s)");
            this.addServicesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File[] files = AvailablePanel.this.openFiles();
                    int numFiles = files.length;
                    if (AvailablePanel.this.availableGraphs == null) {
                        AvailablePanel.this.availableGraphs = new ArrayList(numFiles);
                    }
                    int loadedFiles = 0;
                    int i = 0;
                    while (i < numFiles) {
                        if (files[i].exists()) {
                            ReadFile.setFileName(files[i].getAbsolutePath());
                            Service serv = null;
                            try {
                                String target = ReadFile.readFile();
                                serv = new Service(target);
                                String name = files[i].getName();
                                AvailablePanel.this.servicesListModel.addElement(name);
                                AvailablePanel.this.services.addService(serv);
                                AvailablePanel.this.availableGraphs.add(null);
                                ++loadedFiles;
                            }
                            catch (Exception e1) {
                                String error = e1.getMessage();
                                JOptionPane.showMessageDialog(null, error, "Error", 0);
                            }
                        }
                        ++i;
                    }
                    int size = AvailablePanel.this.services.sizeCommunity();
                    AvailablePanel.this.statusLabel.setText("Service(s): " + size + " - New service(s) Loaded: " + loadedFiles);
                    if (loadedFiles > 0) {
                        AvailablePanel.this.availableLoaded = true;
                    }
                }
            });
        }
        return this.addServicesButton;
    }

    private JButton getRemoveServiceButton() {
        if (this.removeServiceButton == null) {
            this.removeServiceButton = new JButton();
            this.removeServiceButton.setText("Remove Service");
            this.removeServiceButton.setToolTipText("Remove selected service");
            this.removeServiceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = AvailablePanel.this.servicesList.getSelectedIndex();
                    if (AvailablePanel.this.availableLoaded && index >= 0) {
                        String name = (String)AvailablePanel.this.servicesListModel.get(index);
                        AvailablePanel.this.services.deleteService(index);
                        AvailablePanel.this.availableGraphs.remove(index);
                        AvailablePanel.this.servicesListModel.remove(index);
                        AvailablePanel.this.graphScrollPane.setViewportView(null);
                        AvailablePanel.this.statusLabel.setText("Deleted Service " + name);
                        if (AvailablePanel.this.servicesListModel.isEmpty()) {
                            AvailablePanel.this.availableLoaded = false;
                            AvailablePanel.this.statusLabel.setText("No available service loaded");
                        }
                    }
                }
            });
        }
        return this.removeServiceButton;
    }

    private JButton getRemoveAllButton() {
        if (this.removeAllButton == null) {
            this.removeAllButton = new JButton();
            this.removeAllButton.setText("Remove All Services");
            this.removeAllButton.setToolTipText("Remove all services");
            this.removeAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AvailablePanel.this.availableLoaded) {
                        int lenght = AvailablePanel.this.servicesListModel.size();
                        int i = 0;
                        while (i < lenght) {
                            AvailablePanel.this.services.deleteService(0);
                            AvailablePanel.this.availableGraphs.remove(0);
                            AvailablePanel.this.servicesListModel.remove(0);
                            ++i;
                        }
                        AvailablePanel.this.graphScrollPane.setViewportView(null);
                        AvailablePanel.this.availableLoaded = false;
                        AvailablePanel.this.statusLabel.setText("No available service loaded");
                    }
                }
            });
        }
        return this.removeAllButton;
    }

    private JButton getSaveToImageButton() {
        if (this.saveToImageButton == null) {
            this.saveToImageButton = new JButton();
            this.saveToImageButton.setText("Save To Image");
            this.saveToImageButton.setToolTipText("Save the graph in a jpeg file");
            this.saveToImageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    int index = AvailablePanel.this.servicesList.getSelectedIndex();
                    if (index > -1 && (file = AvailablePanel.this.saveImageFile()) != null) {
                        Exporter.exportToImage(file, (JGraph)AvailablePanel.this.availableGraphs.get(index));
                    }
                }
            });
        }
        return this.saveToImageButton;
    }

    private JButton getSaveToDotButton() {
        if (this.saveToDotButton == null) {
            this.saveToDotButton = new JButton();
            this.saveToDotButton.setText("Save To DOT File");
            this.saveToDotButton.setToolTipText("Save the graph in DOT format");
            this.saveToDotButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    int index = AvailablePanel.this.servicesList.getSelectedIndex();
                    if (index > -1 && (file = AvailablePanel.this.saveDotFile()) != null) {
                        Exporter.exportToDot(file, AvailablePanel.this.services.get(index));
                    }
                }
            });
        }
        return this.saveToDotButton;
    }

    private JScrollPane getGraphScrollPane() {
        if (this.graphScrollPane == null) {
            this.graphScrollPane = new JScrollPane();
            this.graphScrollPane.setViewportView(null);
        }
        return this.graphScrollPane;
    }

    private JScrollPane getListScrollPane() {
        if (this.listScrollPane == null) {
            this.listScrollPane = new JScrollPane();
            this.listScrollPane.setViewportView(this.getServicesList());
        }
        return this.listScrollPane;
    }

    private JList getServicesList() {
        if (this.servicesList == null) {
            this.servicesList = new JList(this.servicesListModel);
            this.servicesList.setToolTipText("Choose an Available Service to show");
            this.servicesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = AvailablePanel.this.servicesList.getSelectedIndex();
                    if (index > -1) {
                        JGraph graph = (JGraph)AvailablePanel.this.availableGraphs.get(index);
                        if (graph == null) {
                            graph = new GraphFactory(AvailablePanel.this.services.get(index)).getGraph();
                            AvailablePanel.this.availableGraphs.set(index, graph);
                        }
                        AvailablePanel.this.graphScrollPane.setViewportView(graph);
                        AvailablePanel.this.statusLabel.setText("Available Service: " + AvailablePanel.this.services.get(index).getName());
                    }
                }
            });
        }
        return this.servicesList;
    }

    private File[] openFiles() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Graph File", "txt");
        fc.setFileFilter(filter);
        fc.setMultiSelectionEnabled(true);
        fc.showOpenDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFiles();
    }

    private File saveImageFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JPEG File", "jpeg");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private File saveDotFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("DOT File", "dot");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    public boolean isAvailableLoaded() {
        return this.availableLoaded;
    }

    public void setEnableButtons(boolean flag) {
        this.addServicesButton.setEnabled(flag);
        this.removeServiceButton.setEnabled(flag);
        this.removeAllButton.setEnabled(flag);
    }
}

