/*
 * Decompiled with CFR 0.152.
 */
package control;

import abstraction.Action;
import abstraction.OnlyReadIterator;
import abstraction.Service;
import abstraction.State;
import control.CState;
import control.Community;
import control.SimulatedBy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Simulation {
    private Set<SimulatedBy> pairs;
    private Service target;
    private Community community;

    protected Simulation(Service target, Community community) {
        this.target = target;
        this.community = community;
        this.pairs = new HashSet<SimulatedBy>();
    }

    protected void compositionViaSimulation() {
        this.createSimulationSet();
        boolean modified = true;
        while (!this.pairs.isEmpty() && modified) {
            modified = this.checkSimulationSet();
        }
    }

    private void createSimulationSet() {
        Iterator<State> ts = this.target.getStates();
        while (ts.hasNext()) {
            SimulatedBy newRecord;
            State t = ts.next();
            if (this.target.isFinalState(t)) {
                Iterator<CState> fcs = this.community.getFinalCommunityStates();
                while (fcs.hasNext()) {
                    CState s = fcs.next();
                    newRecord = new SimulatedBy(t, s);
                    this.pairs.add(newRecord);
                }
                continue;
            }
            Iterator<CState> cs = this.community.getCommunityStates();
            while (cs.hasNext()) {
                CState s1 = cs.next();
                newRecord = new SimulatedBy(t, s1);
                this.pairs.add(newRecord);
            }
        }
    }

    private boolean checkSimulationSet() {
        for (SimulatedBy line : this.pairs) {
            State ts = line.getTargetState();
            CState cs = line.getCommunityState();
            Iterator<Action> action = this.target.getActions(ts);
            while (action.hasNext()) {
                Action as = action.next();
                Iterator<State> nextState = this.target.getNextStates(ts, as);
                while (nextState.hasNext()) {
                    State nextTState = nextState.next();
                    if (this.checkSimulationOfNextState(cs, as, nextTState)) continue;
                    this.pairs.remove(line);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkSimulationOfNextState(CState cs, Action as, State nextTState) {
        int i = 0;
        while (i < cs.getSize()) {
            Service serv = this.community.getService(i);
            if (serv.containsPresentAction(cs.get(i), as)) {
                boolean candoit = true;
                Iterator<State> nextState = serv.getNextStates(cs.get(i), as);
                while (nextState.hasNext() && candoit) {
                    State next = nextState.next();
                    CState hs = cs.buildNewState(i, next);
                    SimulatedBy rec = new SimulatedBy(nextTState, hs);
                    if (this.contains(rec)) continue;
                    candoit = false;
                }
                if (candoit) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean contains(SimulatedBy sb) {
        return this.pairs.contains(sb);
    }

    protected Iterator<SimulatedBy> getSimulationSet() {
        return new OnlyReadIterator<SimulatedBy>(this.pairs.iterator());
    }

    protected boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator<SimulatedBy> it = this.pairs.iterator();
        while (it.hasNext()) {
            s = s.append("(" + it.next().toString() + ")");
        }
        return s.toString();
    }
}

