/*
 * Decompiled with CFR 0.152.
 */
package control;

import abstraction.Action;
import abstraction.OnlyReadIterator;
import abstraction.Service;
import abstraction.State;
import control.CState;
import control.Community;
import control.OrchestratorKey;
import control.SimulatedBy;
import control.Simulation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Orchestrator {
    private Simulation s;
    private Community community;
    private Service target;
    private Map<OrchestratorKey, Set<Service>> orchestrator;

    public Orchestrator(Community community, Service target) {
        this.community = community;
        this.target = target;
        this.s = new Simulation(target, community);
        this.s.compositionViaSimulation();
    }

    public boolean generateOrchestrator() {
        if (this.s.isEmpty()) {
            return false;
        }
        this.orchestrator = new HashMap<OrchestratorKey, Set<Service>>();
        Iterator<SimulatedBy> pairs = this.s.getSimulationSet();
        while (pairs.hasNext()) {
            SimulatedBy record = pairs.next();
            State ts = record.getTargetState();
            CState cs = record.getCommunityState();
            Iterator<Action> action = this.target.getActions(ts);
            while (action.hasNext()) {
                Action as = action.next();
                HashSet<Service> services = new HashSet<Service>();
                Iterator<State> nextTS = this.target.getNextStates(ts, as);
                State nextTState = nextTS.next();
                int i = 0;
                while (i < cs.getSize()) {
                    Service serv = this.community.getService(i);
                    if (serv.containsPresentAction(cs.get(i), as)) {
                        boolean candoit = true;
                        Iterator<State> nextState = serv.getNextStates(cs.get(i), as);
                        while (nextState.hasNext() && candoit) {
                            State next = nextState.next();
                            CState hs = cs.buildNewState(i, next);
                            SimulatedBy rec = new SimulatedBy(nextTState, hs);
                            if (this.s.contains(rec)) continue;
                            candoit = false;
                        }
                        if (candoit && !this.contains(services, serv)) {
                            services.add(serv);
                        }
                    }
                    ++i;
                }
                OrchestratorKey key = new OrchestratorKey(record, as);
                this.orchestrator.put(key, services);
            }
        }
        return true;
    }

    public boolean checkComposition() {
        SimulatedBy initPair = new SimulatedBy(this.target.getInitialState(), this.community.getInitialStates());
        return this.s.contains(initPair);
    }

    private boolean contains(Set<Service> sts, Service s) {
        for (Service serv : sts) {
            if (!serv.getName().equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    public Iterator<Map.Entry<OrchestratorKey, Set<Service>>> getOrchestrator() {
        return new OnlyReadIterator<Map.Entry<OrchestratorKey, Set<Service>>>(this.orchestrator.entrySet().iterator());
    }

    public Iterator<Service> getServicesForStateAction(OrchestratorKey orch) {
        return new OnlyReadIterator<Service>(this.orchestrator.get(orch).iterator());
    }

    public Iterator<SimulatedBy> getSimulationSet() {
        return this.s.getSimulationSet();
    }

    public Service createOrchestratorGenerator() {
        if (!this.checkComposition()) {
            return null;
        }
        StringBuilder s = new StringBuilder("OrchestratorGenerator?transition:");
        HashSet<SimulatedBy> toAdd = new HashSet<SimulatedBy>();
        HashSet<SimulatedBy> alreadyAdded = new HashSet<SimulatedBy>();
        HashSet<SimulatedBy> finalStates = new HashSet<SimulatedBy>();
        State initialTS = this.target.getInitialState();
        CState initialCS = this.community.getInitialStates();
        SimulatedBy initialStates = new SimulatedBy(initialTS, initialCS);
        toAdd.add(initialStates);
        while (!toAdd.isEmpty()) {
            HashSet<SimulatedBy> simulatedPairs = new HashSet<SimulatedBy>();
            simulatedPairs.addAll(toAdd);
            for (SimulatedBy simulated : toAdd) {
                State initTS = simulated.getTargetState();
                CState initCS = simulated.getCommunityState();
                alreadyAdded.add(simulated);
                if (this.target.isFinalState(initTS) && this.community.isFinalCommunityState(initCS)) {
                    finalStates.add(simulated);
                }
                Iterator<Action> iter = this.target.getActions(initTS);
                while (iter.hasNext()) {
                    Action action = iter.next();
                    State nextTS = this.target.getNextStates(initTS, action).next();
                    OrchestratorKey orchKey = new OrchestratorKey(simulated, action);
                    Iterator<Service> srv = this.getServicesForStateAction(orchKey);
                    while (srv.hasNext()) {
                        Service serv = srv.next();
                        int position = this.community.getServicePosition(serv);
                        Iterator<State> next = serv.getNextStates(initCS.get(position), action);
                        while (next.hasNext()) {
                            State nextState = next.next();
                            CState cs = initCS.buildNewState(position, nextState);
                            SimulatedBy sim = new SimulatedBy(nextTS, cs);
                            if (!this.s.contains(sim)) continue;
                            if (!alreadyAdded.contains(sim)) {
                                simulatedPairs.add(sim);
                            }
                            s = s.append(simulated + "-" + action + "," + serv + "-" + sim + ";");
                        }
                    }
                }
                simulatedPairs.remove(simulated);
                toAdd = simulatedPairs;
            }
        }
        s = s.append("initial:" + initialStates + ";" + "final:");
        Iterator f = finalStates.iterator();
        int count = finalStates.size();
        while (f.hasNext()) {
            SimulatedBy finalSim = (SimulatedBy)f.next();
            s = s.append(finalSim);
            s = --count == 0 ? s.append(".") : s.append(";");
        }
        return new Service(s.toString());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<OrchestratorKey, Set<Service>> set : this.orchestrator.entrySet()) {
            s = s.append("(" + set.getKey().toString() + " , ");
            Set<Service> servs = set.getValue();
            for (Service serv : servs) {
                s = s.append(serv.getName());
            }
            s = s.append(")");
        }
        return s.toString();
    }
}

