/*
 * Decompiled with CFR 0.152.
 */
package control;

import abstraction.AvailableServices;
import abstraction.OnlyReadIterator;
import abstraction.Service;
import abstraction.State;
import control.CState;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Community {
    private AvailableServices availableService;
    private Set<CState> CStates;
    private Set<CState> CFStates;

    public Community(AvailableServices as) {
        this.availableService = as;
        this.CStates = new HashSet<CState>();
        this.CFStates = new HashSet<CState>();
    }

    private void createCommunityStates(Service s, int loop, CState CSRecord) {
        Iterator<State> state = s.getStates();
        while (state.hasNext()) {
            State st = state.next();
            if (loop < this.availableService.sizeCommunity() - 1) {
                CSRecord = CSRecord.buildNewState(loop, st);
                this.createCommunityStates(this.availableService.get(loop + 1), loop + 1, CSRecord);
                continue;
            }
            CSRecord = CSRecord.buildNewState(loop, st);
            this.CStates.add(CSRecord);
        }
    }

    public Iterator<CState> getCommunityStates() {
        if (this.CStates.isEmpty()) {
            CState CSRecord = new CState(new State[this.availableService.sizeCommunity()]);
            this.createCommunityStates(this.availableService.get(0), 0, CSRecord);
        }
        return new OnlyReadIterator<CState>(this.CStates.iterator());
    }

    private void createFinalCommunityState(Service s, int loop, CState CSRecord) {
        Iterator<State> state = s.getFinalStates();
        while (state.hasNext()) {
            State st = state.next();
            if (loop < this.availableService.sizeCommunity() - 1) {
                CSRecord = CSRecord.buildNewState(loop, st);
                this.createFinalCommunityState(this.availableService.get(loop + 1), loop + 1, CSRecord);
                continue;
            }
            CSRecord = CSRecord.buildNewState(loop, st);
            this.CFStates.add(CSRecord);
        }
    }

    public Iterator<CState> getFinalCommunityStates() {
        if (this.CFStates.isEmpty()) {
            CState CSRecord = new CState(new State[this.availableService.sizeCommunity()]);
            this.createFinalCommunityState(this.availableService.get(0), 0, CSRecord);
        }
        return new OnlyReadIterator<CState>(this.CFStates.iterator());
    }

    public Service getService(int index) {
        return this.availableService.get(index);
    }

    public CState getInitialStates() {
        State[] initial = new State[this.availableService.sizeCommunity()];
        int i = 0;
        while (i < this.availableService.sizeCommunity()) {
            State s;
            initial[i] = s = this.availableService.get(i).getInitialState();
            ++i;
        }
        return new CState(initial);
    }

    public int getServicePosition(Service service) {
        return this.availableService.getPosition(service);
    }

    public boolean isFinalCommunityState(CState cs) {
        return this.CFStates.contains(cs);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator<CState> it = this.getCommunityStates();
        while (it.hasNext()) {
            CState c = it.next();
            s = s.append("(" + c + ")");
        }
        return s.toString();
    }

    public int size() {
        return this.availableService.sizeCommunity();
    }
}

