/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import org.jgraph.JGraph;

public class JGraphPrintingScrollPane
extends JScrollPane
implements Printable {
    public static final double DEFAULT_PAGESCALE = 1.5;
    protected PageFormat pageFormat = new PageFormat();
    protected boolean isPageVisible = true;
    protected double pageScale = 1.5;
    protected JGraph graph;
    public static String PROPERTY_METRIC = "metric";
    public static String PROPERTY_PAGEVISIBLE = "pageVisible";
    public static String PROPERTY_BACKGROUNDIMAGE = "backgroundImage";
    public static String PROPERTY_RULERSVISIBLE = "rulersVisible";
    public static String PROPERTY_PAGEFORMAT = "pageFormat";
    public static String PROPERTY_AUTOSCALEPOLICY = "autoScalePolicy";
    public static String PROPERTY_PAGESCALE = "pageScale";

    public JGraph getGraph() {
        return this.graph;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        PageFormat pageFormat2 = this.pageFormat;
        this.pageFormat = pageFormat;
        this.updateMinimumSize();
        this.firePropertyChange(PROPERTY_PAGEFORMAT, pageFormat2, pageFormat);
    }

    public double getPageScale() {
        return this.pageScale;
    }

    public void setPageScale(double d) {
        double d2 = this.pageScale;
        this.pageScale = d;
        this.firePropertyChange(PROPERTY_PAGESCALE, d2, d);
    }

    protected void updateMinimumSize() {
        if (this.isPageVisible() && this.pageFormat != null) {
            Rectangle2D rectangle2D = this.graph.getCellBounds(this.graph.getRoots());
            Dimension dimension = rectangle2D != null ? new Dimension((int)(rectangle2D.getX() + rectangle2D.getWidth()), (int)(rectangle2D.getY() + rectangle2D.getHeight())) : new Dimension(1, 1);
            int n = (int)(this.pageFormat.getWidth() * this.pageScale);
            int n2 = (int)(this.pageFormat.getHeight() * this.pageScale);
            int n3 = (int)Math.ceil((double)(dimension.width - 5) / (double)n);
            int n4 = (int)Math.ceil((double)(dimension.height - 5) / (double)n2);
            dimension = new Dimension(Math.max(n3, 1) * n + 5, Math.max(n4, 1) * n2 + 5);
            this.graph.setMinimumSize(dimension);
        } else {
            this.graph.setMinimumSize(null);
        }
        this.graph.revalidate();
    }

    protected double computeWindowScale(int n) {
        Dimension dimension = this.getViewport().getExtentSize();
        Rectangle2D rectangle2D = this.getGraph().getCellBounds(this.getGraph().getRoots());
        if (rectangle2D != null) {
            return Math.min(dimension.getWidth() / (rectangle2D.getX() + rectangle2D.getWidth() + (double)n), dimension.getHeight() / (rectangle2D.getY() + rectangle2D.getHeight() + (double)n));
        }
        return 0.0;
    }

    protected double computePageScale() {
        Dimension dimension = this.getViewport().getExtentSize();
        Dimension dimension2 = this.getGraph().getMinimumSize();
        if (dimension2 != null && (dimension2.getWidth() != 0.0 || dimension2.getHeight() != 0.0)) {
            return Math.min(dimension.getWidth() / dimension2.getWidth(), dimension.getHeight() / dimension2.getHeight());
        }
        return 0.0;
    }

    protected double computePageWidthScale(int n) {
        Dimension dimension = this.getViewport().getExtentSize();
        Dimension dimension2 = this.getGraph().getMinimumSize();
        if (dimension2 != null && (dimension2.getWidth() != 0.0 || dimension2.getHeight() != 0.0)) {
            dimension.width -= n;
            return dimension.getWidth() / dimension2.getWidth();
        }
        return 0.0;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        Dimension dimension = this.graph.getPreferredSize();
        int n3 = (int)(pageFormat.getWidth() * this.pageScale);
        int n4 = (int)(pageFormat.getHeight() * this.pageScale);
        int n5 = (int)Math.max(Math.ceil((double)(dimension.width - 5) / (double)n3), 1.0);
        if (n < n5 * (n2 = (int)Math.max(Math.ceil((double)(dimension.height - 5) / (double)n4), 1.0))) {
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            repaintManager.setDoubleBufferingEnabled(false);
            double d = this.getGraph().getScale();
            this.getGraph().setScale(1.0 / this.pageScale);
            int n6 = (int)((double)(n % n5) * pageFormat.getWidth());
            int n7 = (int)((double)(n % n2) * pageFormat.getHeight());
            graphics.translate(-n6, -n7);
            graphics.setClip(n6, n7, (int)((double)n6 + pageFormat.getWidth()), (int)((double)n7 + pageFormat.getHeight()));
            this.getGraph().paint(graphics);
            graphics.translate(n6, n7);
            this.graph.setScale(d);
            repaintManager.setDoubleBufferingEnabled(true);
            return 0;
        }
        return 1;
    }

    public boolean isPageVisible() {
        return this.isPageVisible;
    }

    public void setPageVisible(boolean bl) {
        boolean bl2 = this.isPageVisible;
        this.isPageVisible = bl;
        this.updateMinimumSize();
        this.firePropertyChange(PROPERTY_PAGEVISIBLE, bl2, bl);
    }

    public class Viewport
    extends JViewport {
        public void paint(Graphics graphics) {
            if (JGraphPrintingScrollPane.this.isPageVisible()) {
                this.paintBackgroundPages((Graphics2D)graphics);
            } else {
                this.setBackground(JGraphPrintingScrollPane.this.graph.getBackground());
            }
            if (JGraphPrintingScrollPane.this.graph.getBackgroundImage() != null) {
                this.paintBackgroundImage((Graphics2D)graphics);
            }
            this.setOpaque(!JGraphPrintingScrollPane.this.isPageVisible() && JGraphPrintingScrollPane.this.graph.getBackgroundImage() == null);
            super.paint(graphics);
            this.setOpaque(true);
        }

        protected void paintBackgroundImage(Graphics2D graphics2D) {
            if (!JGraphPrintingScrollPane.this.isPageVisible()) {
                graphics2D.setColor(JGraphPrintingScrollPane.this.graph.getBackground());
                graphics2D.fillRect(0, 0, JGraphPrintingScrollPane.this.graph.getWidth(), JGraphPrintingScrollPane.this.graph.getHeight());
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            Point point = this.getViewPosition();
            graphics2D.translate(-point.x, -point.y);
            graphics2D.scale(JGraphPrintingScrollPane.this.graph.getScale(), JGraphPrintingScrollPane.this.graph.getScale());
            Image image = JGraphPrintingScrollPane.this.graph.getBackgroundImage().getImage();
            graphics2D.drawImage(image, 0, 0, (ImageObserver)JGraphPrintingScrollPane.this.graph);
            graphics2D.setTransform(affineTransform);
        }

        protected void paintBackgroundPages(Graphics2D graphics2D) {
            int n;
            Point2D point2D = JGraphPrintingScrollPane.this.graph.toScreen((Point2D)new Point2D.Double(JGraphPrintingScrollPane.this.pageFormat.getWidth(), JGraphPrintingScrollPane.this.pageFormat.getHeight()));
            Dimension dimension = JGraphPrintingScrollPane.this.graph.getPreferredSize();
            int n2 = (int)(point2D.getX() * JGraphPrintingScrollPane.this.pageScale);
            int n3 = (int)(point2D.getY() * JGraphPrintingScrollPane.this.pageScale);
            int n4 = (int)Math.max(Math.ceil((double)(dimension.width - 5) / (double)n2), 1.0);
            int n5 = (int)Math.max(Math.ceil((double)(dimension.height - 5) / (double)n3), 1.0);
            graphics2D.setColor(JGraphPrintingScrollPane.this.graph.getHandleColor());
            Point point = this.getViewPosition();
            graphics2D.translate(-point.x, -point.y);
            graphics2D.fillRect(0, 0, JGraphPrintingScrollPane.this.graph.getWidth(), JGraphPrintingScrollPane.this.graph.getHeight());
            graphics2D.setColor(Color.darkGray);
            graphics2D.fillRect(3, 3, n4 * n2, n5 * n3);
            graphics2D.setColor(JGraphPrintingScrollPane.this.getGraph().getBackground());
            graphics2D.fillRect(1, 1, n4 * n2 - 1, n5 * n3 - 1);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f));
            graphics2D.setColor(Color.darkGray);
            for (n = 1; n < n4; ++n) {
                graphics2D.drawLine(n * n2, 1, n * n2, n5 * n3 - 1);
            }
            for (n = 1; n < n5; ++n) {
                graphics2D.drawLine(1, n * n3, n4 * n2 - 1, n * n3);
            }
            graphics2D.setStroke(stroke);
            graphics2D.translate(point.x, point.y);
            graphics2D.clipRect(0, 0, n4 * n2 - 1 - point.x, n5 * n3 - 1 - point.y);
        }
    }
}

