/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.io.svg;

import com.jgraph.io.svg.SVGEdgeWriter;
import com.jgraph.io.svg.SVGUtils;
import com.jgraph.io.svg.SVGVertexWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGGraphWriter {
    public static Font TITLE_FONT = new Font("Dialog", 0, 16);
    public static int TITLE_VSPACING = 10;
    public static double FONT_PROPORTION_FACTOR = 1.5;
    public static String TITLE_HEXCOLOR = SVGUtils.getHexEncoding(Color.DARK_GRAY);
    protected SVGVertexWriter vertexFactory = new SVGVertexWriter();
    protected SVGEdgeWriter edgeFactory = new SVGEdgeWriter();
    protected Map gradients = new Hashtable();
    protected Rectangle viewBox = new Rectangle(0, 0, 0, 0);

    public void write(OutputStream outputStream, String string, GraphLayoutCache graphLayoutCache, int n) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            document.appendChild(this.createNode(document, string, graphLayoutCache, n));
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Node createNode(Document document, String string, GraphLayoutCache graphLayoutCache, int n) throws ParserConfigurationException {
        Object object;
        Rectangle2D rectangle2D = GraphLayoutCache.getBounds((CellView[])graphLayoutCache.getAllViews());
        double d = rectangle2D.getX() - (double)n;
        double d2 = rectangle2D.getY() - (double)n;
        int n2 = 0;
        int n3 = 0;
        Node node = null;
        if (string != null && string.length() > 0) {
            Font font = TITLE_FONT;
            n2 = font.getSize() + TITLE_VSPACING;
            n3 = (int)((double)(string.length() * font.getSize()) / FONT_PROPORTION_FACTOR);
            node = this.createTextNode(document, string, null, font, TITLE_HEXCOLOR, n, n + n2 - TITLE_VSPACING);
        }
        double d3 = Math.max((double)n3, rectangle2D.getWidth() + (double)(2 * n));
        double d4 = rectangle2D.getHeight() + (double)(2 * n) + (double)n2;
        Node node2 = this.createRoot(document, d3, d4, n);
        Element element = document.createElement("defs");
        Element element2 = document.createElement("g");
        element2.setAttribute("id", "arrowMarker");
        element.appendChild(element2);
        Element element3 = document.createElement("g");
        element3.setAttribute("stroke-width", "0");
        element2.appendChild(element3);
        Element element4 = document.createElement("path");
        element4.setAttribute("d", "M 4 -2 L 0 0 L 4 2 L 3 1 L 3 -1 L 4 -2");
        element3.appendChild(element4);
        Element element5 = document.createElement("marker");
        element5.setAttribute("id", "startMarker");
        element5.setAttribute("markerWidth", "48");
        element5.setAttribute("markerHeight", "24");
        element5.setAttribute("viewBox", "-4 -4 25 5");
        element5.setAttribute("orient", "auto");
        element5.setAttribute("refX", "0");
        element5.setAttribute("refY", "0");
        element5.setAttribute("markerUnits", "strokeWidth");
        element.appendChild(element5);
        element2 = document.createElement("g");
        element5.appendChild(element2);
        Element element6 = document.createElement("use");
        element6.setAttribute("xlink:href", "#arrowMarker");
        element6.setAttribute("transform", "rotate(180)");
        element6.setAttribute("stroke-width", "1");
        element2.appendChild(element6);
        element5 = document.createElement("marker");
        element5.setAttribute("id", "endMarker");
        element5.setAttribute("markerWidth", "48");
        element5.setAttribute("markerHeight", "24");
        element5.setAttribute("viewBox", "-4 -4 25 5");
        element5.setAttribute("orient", "auto");
        element5.setAttribute("refX", "0");
        element5.setAttribute("refY", "0");
        element5.setAttribute("markerUnits", "strokeWidth");
        element.appendChild(element5);
        element2 = document.createElement("g");
        element5.appendChild(element2);
        element6 = document.createElement("use");
        element6.setAttribute("xlink:href", "#arrowMarker");
        element6.setAttribute("stroke-width", "1");
        element2.appendChild(element6);
        node2.appendChild(element);
        if (node != null) {
            node2.appendChild(node);
            d2 -= (double)n2;
        }
        GraphModel graphModel = graphLayoutCache.getModel();
        CellView[] cellViewArray = graphLayoutCache.getAllViews();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Node node3;
            object = cellViewArray[i].getCell();
            if (graphModel.isPort(object)) continue;
            Node node4 = node3 = graphModel.isEdge(object) ? this.edgeFactory.createNode(this, document, cellViewArray[i], d, d2) : this.vertexFactory.createNode(this, document, graphLayoutCache, cellViewArray[i], d, d2);
            if (node3 == null) continue;
            node2.appendChild(node3);
        }
        Iterator iterator = this.gradients.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof Node)) continue;
            element.appendChild((Node)object);
        }
        return node2;
    }

    protected Node createRoot(Document document, double d, double d2, int n) {
        Element element = document.createElement("svg");
        element.setAttribute("width", String.valueOf(d));
        element.setAttribute("height", String.valueOf(d2));
        element.setAttribute("viewBox", "0 0 " + d + " " + d2);
        element.setAttribute("allowZoomAndPan", "true");
        element.setAttribute("version", "1.1");
        element.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.viewBox.setFrame(n, n, d, d2);
        return element;
    }

    public Node getGradient(Document document, String string, String string2) {
        String string3;
        Node node = null;
        if ((string != null || string2 != null) && (node = (Element)this.gradients.get(string3 = "gradient" + (string != null ? string.substring(1) : "none") + "_" + (string2 != null ? string2.substring(1) : "none"))) == null) {
            node = this.createGradient(document, string3, string, string2);
            this.gradients.put(string3, node);
        }
        return node;
    }

    protected Node createGradient(Document document, String string, String string2, String string3) {
        Element element = document.createElement("linearGradient");
        element.setAttribute("id", string);
        Element element2 = document.createElement("stop");
        element2.setAttribute("offset", "5%");
        element2.setAttribute("stop-color", string2);
        element2.setAttribute("stop-opacity", "1");
        element.appendChild(element2);
        Element element3 = document.createElement("stop");
        element3.setAttribute("offset", "95%");
        element3.setAttribute("stop-color", string3);
        element3.setAttribute("stop-opacity", "1");
        element.appendChild(element3);
        return element;
    }

    public Node createShapeNode(Document document, int n, Rectangle2D rectangle2D, double d, double d2, String string, String string2, String string3, float f, double d3, boolean bl) {
        boolean bl2 = n == 1;
        Element element = document.createElement(bl2 ? "ellipse" : "rect");
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        if (bl2) {
            element.setAttribute("cx", String.valueOf(rectangle2D.getX() + d4 / 2.0 - d));
            element.setAttribute("cy", String.valueOf(rectangle2D.getY() + d5 / 2.0 - d2));
            element.setAttribute("rx", String.valueOf(d4 / 2.0));
            element.setAttribute("ry", String.valueOf(d5 / 2.0));
        } else {
            element.setAttribute("x", String.valueOf(rectangle2D.getX() - d));
            element.setAttribute("y", String.valueOf(rectangle2D.getY() - d2));
            if (n == 2) {
                element.setAttribute("rx", "5");
                element.setAttribute("ry", "5");
            }
            element.setAttribute("width", String.valueOf(d4));
            element.setAttribute("height", String.valueOf(d5));
        }
        if (string2 != null) {
            Node node = this.getGradient(document, string, string2);
            String string4 = node.getAttributes().getNamedItem("id").getNodeValue();
            element.setAttribute("fill", "url(#" + string4 + ")");
        } else if (string != null) {
            element.setAttribute("fill", string);
        }
        element.setAttribute("opacity", String.valueOf(d3));
        element.setAttribute("stroke", string3);
        element.setAttribute("stroke-width", String.valueOf(f));
        return element;
    }

    public Node createTextNode(Document document, String string, String string2, Font font, String string3, int n, int n2) {
        Element element = document.createElement("text");
        element.appendChild(document.createTextNode(string));
        int n3 = 11;
        if (font != null) {
            element.setAttribute("font-family", font.getFamily());
            element.setAttribute("font-size", String.valueOf(font.getSize2D()));
            n3 = font.getSize();
        } else {
            element.setAttribute("font-family", "Dialog");
            element.setAttribute("font-size", "11");
        }
        element.setAttribute("fill", string3);
        double d = (double)n3 / FONT_PROPORTION_FACTOR;
        int n4 = (int)((double)string.length() * d / 2.0);
        if (string2 != null) {
            if ((double)(n - n4) < this.viewBox.getX()) {
                element.setAttribute("text-anchor", "start");
                n = (int)this.viewBox.getX();
            } else if ((double)(n + n4) > this.viewBox.getWidth() - 2.0) {
                element.setAttribute("text-anchor", "end");
                n = (int)this.viewBox.getWidth() - 2;
            } else {
                element.setAttribute("text-anchor", string2);
            }
        }
        element.setAttribute("x", String.valueOf(n));
        element.setAttribute("y", String.valueOf(Math.max(this.viewBox.getY() + (double)n3, (double)n2)));
        return element;
    }

    protected Node createDropShadowFilter(Document document, int n, int n2, int n3) {
        Element element = document.createElement("filter");
        element.setAttribute("id", "dropShadow");
        element.setAttribute("x", "0");
        element.setAttribute("y", "0");
        element.setAttribute("width", "1");
        element.setAttribute("height", "1");
        element.setAttribute("filterMarginsUnits", "userSpaceOnUse");
        element.setAttribute("dx", "0");
        element.setAttribute("dy", "0");
        element.setAttribute("dw", "5");
        element.setAttribute("dh", "5");
        Element element2 = document.createElement("feGaussianBlur");
        element2.setAttribute("stdDeviation", String.valueOf(n));
        element2.setAttribute("in", "SourceAlpha");
        element.appendChild(element2);
        Element element3 = document.createElement("feOffset");
        element3.setAttribute("dx", String.valueOf(n2));
        element3.setAttribute("dy", String.valueOf(n3));
        element.appendChild(element3);
        Element element4 = document.createElement("feMerge");
        element4.appendChild(document.createElement("feMergeNode"));
        Element element5 = document.createElement("feMergeNode");
        element5.setAttribute("in", "SourceGraphic");
        element4.appendChild(element5);
        element.appendChild(element4);
        return element;
    }

    public Object[] getLabels(CellView cellView) {
        return new Object[0];
    }
}

