/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.io.svg;

import com.jgraph.io.svg.SVGGraphWriter;
import com.jgraph.io.svg.SVGUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Map;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGEdgeWriter {
    public static String DEFAULT_LINE_COLOR = SVGUtils.HEXCOLOR_BLACK;

    public Node createNode(SVGGraphWriter sVGGraphWriter, Document document, CellView cellView, double d, double d2) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        Element element = document.createElement("a");
        String string = GraphConstants.getLink((Map)attributeMap);
        if (string != null) {
            element.setAttribute("xlink:href", string);
        }
        if (cellView instanceof EdgeView) {
            Point2D point2D;
            Object[] objectArray;
            int n;
            Object object;
            Element element2 = document.createElement("path");
            EdgeView edgeView = (EdgeView)cellView;
            element2.setAttribute("fill", "none");
            Color color = GraphConstants.getLineColor((Map)attributeMap);
            String string2 = null;
            string2 = color != null ? SVGUtils.getHexEncoding(color) : DEFAULT_LINE_COLOR;
            element2.setAttribute("stroke", string2);
            float f = GraphConstants.getLineWidth((Map)attributeMap);
            element2.setAttribute("stroke-width", String.valueOf(f));
            float[] fArray = GraphConstants.getDashPattern((Map)attributeMap);
            if (fArray != null) {
                object = "";
                for (int i = 0; i < fArray.length; ++i) {
                    Float f2 = new Float(fArray[i]);
                    object = (String)object + f2.toString();
                    if (i == fArray.length - 1) continue;
                    object = (String)object + ", ";
                }
                element2.setAttribute("stroke-dasharray", (String)object);
            }
            object = edgeView.getPoint(0);
            String string3 = "M " + (((Point2D)object).getX() - d) + " " + (((Point2D)object).getY() - d2);
            for (n = 1; n < edgeView.getPointCount(); ++n) {
                object = edgeView.getPoint(n);
                string3 = string3 + " L " + (((Point2D)object).getX() - d) + " " + (((Point2D)object).getY() - d2);
            }
            element2.setAttribute("d", string3);
            n = GraphConstants.getLineBegin((Map)attributeMap);
            int n2 = GraphConstants.getLineEnd((Map)attributeMap);
            String string4 = new String("");
            string4 = string4 + "marker-start: url(#endMarker);";
            string4 = string4 + "marker-end: url(#startMarker);";
            string4 = string4 + " stroke: " + string2 + ";";
            element2.setAttribute("style", string4);
            Point point = null;
            int n3 = edgeView.getPointCount() / 2;
            if (edgeView.isLoop()) {
                objectArray = edgeView.getPoint(0);
                point2D = edgeView.getLabelVector();
                point = new Point((int)(objectArray.getX() + point2D.getX() - d), (int)(objectArray.getY() + point2D.getY() - d2));
            } else if (edgeView.getPointCount() % 2 == 1) {
                objectArray = edgeView.getPoint(n3);
                point = new Point((int)(objectArray.getX() - d), (int)(objectArray.getY() - d2));
            } else {
                objectArray = edgeView.getPoint(n3 - 1);
                point2D = edgeView.getPoint(n3);
                point = new Point((int)(objectArray.getX() + (point2D.getX() - objectArray.getX()) / 2.0 - d), (int)(objectArray.getY() + (point2D.getY() - objectArray.getY()) / 2.0 - d2));
            }
            element.appendChild(element2);
            objectArray = sVGGraphWriter.getLabels((CellView)edgeView);
            int n4 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                String string5 = String.valueOf(objectArray[i]);
                Font font = GraphConstants.getFont((Map)attributeMap);
                Color color2 = GraphConstants.getForeground((Map)attributeMap);
                String string6 = null;
                if (color2 != null) {
                    string6 = SVGUtils.getHexEncoding(color2);
                }
                int n5 = point.y + n4;
                element.appendChild(sVGGraphWriter.createTextNode(document, string5, "middle", font, string6, point.x, n5));
                n4 += (font != null ? font.getSize() : 11) + SVGUtils.LINESPACING;
            }
        }
        return element;
    }
}

