/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.navigation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.GraphLayoutCache;

public class GraphNavigator
extends JPanel
implements GraphLayoutCacheListener,
GraphModelListener,
PropertyChangeListener,
AdjustmentListener {
    protected static final Cursor CURSOR_DEFAULT = new Cursor(0);
    protected static final Cursor CURSOR_HAND = new Cursor(12);
    protected ComponentListener componentListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent componentEvent) {
            GraphNavigator.this.updateScale();
        }
    };
    protected transient GraphLayoutCache initialLayoutCache;
    protected JGraph backingGraph;
    protected WeakReference currentGraph;
    protected NavigatorPane navigatorPane;
    protected double maximumScale = 0.5;

    public GraphNavigator(JGraph jGraph) {
        super(new BorderLayout());
        this.setDoubleBuffered(true);
        this.setBackingGraph(jGraph);
        this.initialLayoutCache = jGraph.getGraphLayoutCache();
        jGraph.setOpaque(false);
        jGraph.setScale(this.maximumScale);
        this.navigatorPane = new NavigatorPane(jGraph);
        jGraph.addMouseListener((MouseListener)this.navigatorPane);
        jGraph.addMouseMotionListener((MouseMotionListener)this.navigatorPane);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)this.navigatorPane, "Center");
        this.setFocusable(false);
        this.addComponentListener(this.componentListener);
    }

    public NavigatorPane getScrollPane() {
        return this.navigatorPane;
    }

    public double getMaximumScale() {
        return this.maximumScale;
    }

    public void setMaximumScale(double d) {
        this.maximumScale = d;
    }

    public JGraph getBackingGraph() {
        return this.backingGraph;
    }

    public void setBackingGraph(JGraph jGraph) {
        this.backingGraph = jGraph;
    }

    public JGraph getCurrentGraph() {
        return this.currentGraph != null ? this.currentGraph.get() : null;
    }

    public void setCurrentGraph(JGraph jGraph) {
        if ((jGraph == null || GraphNavigator.getParentGraph((Component)jGraph) == null) && jGraph != null) {
            JScrollPane jScrollPane;
            JGraph jGraph2 = this.getCurrentGraph();
            if (jGraph2 != null && jGraph != jGraph2) {
                jGraph2.getModel().removeGraphModelListener((GraphModelListener)this);
                jGraph2.getGraphLayoutCache().removeGraphLayoutCacheListener((GraphLayoutCacheListener)this);
                jGraph2.removePropertyChangeListener((PropertyChangeListener)this);
                jScrollPane = GraphNavigator.getParentScrollPane((Component)jGraph2);
                if (jScrollPane != null) {
                    jScrollPane.removeComponentListener(this.componentListener);
                    jScrollPane.getVerticalScrollBar().removeAdjustmentListener(this);
                    jScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this);
                    jScrollPane.removePropertyChangeListener(this);
                }
                this.backingGraph.setGraphLayoutCache(this.initialLayoutCache);
            }
            this.currentGraph = new WeakReference<JGraph>(jGraph);
            if (jGraph != null) {
                jGraph.getModel().addGraphModelListener((GraphModelListener)this);
                jGraph.getGraphLayoutCache().addGraphLayoutCacheListener((GraphLayoutCacheListener)this);
                jGraph.addPropertyChangeListener((PropertyChangeListener)this);
                jScrollPane = GraphNavigator.getParentScrollPane((Component)jGraph);
                if (jScrollPane != null) {
                    jScrollPane.addComponentListener(this.componentListener);
                    jScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
                    jScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
                    jScrollPane.addPropertyChangeListener(this);
                }
                this.backingGraph.setGraphLayoutCache(jGraph.getGraphLayoutCache());
            }
            this.updateScale();
        }
    }

    protected void updateScale() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JGraph jGraph = GraphNavigator.this.getCurrentGraph();
                if (jGraph != null) {
                    Dimension dimension = jGraph.getPreferredSize();
                    Dimension dimension2 = jGraph.getBounds().getSize();
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension2.height = Math.max(dimension.height, dimension2.height);
                    double d = jGraph.getScale();
                    dimension.setSize((double)(dimension.width * 1) / d, (double)(dimension.height * 1) / d);
                    Dimension dimension3 = GraphNavigator.this.getScrollPane().getViewport().getSize();
                    double d2 = dimension3.getWidth() / dimension.getWidth();
                    double d3 = dimension3.getHeight() / dimension.getHeight();
                    d = Math.min(Math.min(d2, d3), GraphNavigator.this.getMaximumScale());
                    GraphNavigator.this.getBackingGraph().setScale(d);
                    GraphNavigator.this.repaint();
                }
            }
        });
    }

    public void graphLayoutCacheChanged(GraphLayoutCacheEvent graphLayoutCacheEvent) {
        this.updateScale();
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        this.updateScale();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateScale();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.navigatorPane.repaint();
    }

    public static JScrollPane getParentScrollPane(Component component) {
        while (component != null) {
            if (component instanceof JScrollPane) {
                return (JScrollPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static JGraph getParentGraph(Component component) {
        do {
            if (!((component = component.getParent()) instanceof JGraph)) continue;
            return (JGraph)component;
        } while (component != null);
        return null;
    }

    public static GraphNavigator createInstance(JGraph jGraph) {
        jGraph.setEnabled(false);
        jGraph.setFocusable(false);
        jGraph.setAntiAliased(false);
        return new GraphNavigator(jGraph);
    }

    public class NavigatorPane
    extends JScrollPane
    implements MouseListener,
    MouseMotionListener {
        protected Rectangle currentViewport = new Rectangle();
        protected Point lastPoint = null;

        public NavigatorPane(JGraph jGraph) {
            super((Component)jGraph);
            this.setOpaque(false);
            this.getViewport().setOpaque(false);
        }

        public void paint(Graphics graphics) {
            JGraph jGraph = GraphNavigator.this.getCurrentGraph();
            JScrollPane jScrollPane = GraphNavigator.getParentScrollPane((Component)jGraph);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (jScrollPane != null && jGraph != null) {
                JViewport jViewport = jScrollPane.getViewport();
                Rectangle rectangle = jViewport.getViewRect();
                double d = GraphNavigator.this.backingGraph.getScale() / jGraph.getScale();
                Dimension dimension = jGraph.getSize();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, (int)((double)dimension.width * d), (int)((double)dimension.height * d));
                graphics.setColor(Color.WHITE);
                this.currentViewport.setFrame((int)(rectangle.getX() * d), (int)(rectangle.getY() * d), (int)(rectangle.getWidth() * d), (int)(rectangle.getHeight() * d));
                graphics.fillRect(this.currentViewport.x, this.currentViewport.y, this.currentViewport.width, this.currentViewport.height);
                super.paint(graphics);
                graphics.setColor(Color.RED);
                graphics.drawRect(this.currentViewport.x, this.currentViewport.y, this.currentViewport.width, this.currentViewport.height);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.currentViewport.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.lastPoint = mouseEvent.getPoint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.lastPoint = null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JGraph jGraph;
            JScrollPane jScrollPane;
            if (this.lastPoint != null && (jScrollPane = GraphNavigator.getParentScrollPane((Component)(jGraph = GraphNavigator.this.getCurrentGraph()))) != null && GraphNavigator.this.currentGraph != null) {
                JViewport jViewport = jScrollPane.getViewport();
                Rectangle rectangle = jViewport.getViewRect();
                double d = GraphNavigator.this.backingGraph.getScale() / jGraph.getScale();
                double d2 = ((double)mouseEvent.getX() - this.lastPoint.getX()) / d;
                double d3 = ((double)mouseEvent.getY() - this.lastPoint.getY()) / d;
                this.lastPoint = mouseEvent.getPoint();
                d2 = rectangle.getX() + (d2 > 0.0 ? rectangle.getWidth() : 0.0) + d2;
                d3 = rectangle.getY() + (d3 > 0.0 ? rectangle.getHeight() : 0.0) + d3;
                Point2D.Double double_ = new Point2D.Double(d2, d3);
                jGraph.scrollPointToVisible((Point2D)double_);
                GraphNavigator.this.navigatorPane.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.currentViewport.contains(mouseEvent.getPoint())) {
                this.setCursor(CURSOR_HAND);
            } else {
                this.setCursor(CURSOR_DEFAULT);
            }
        }
    }
}

