/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.components.labels;

import com.jgraph.components.labels.CellConstants;
import com.jgraph.components.labels.RichTextBusinessObject;
import com.jgraph.components.labels.RichTextValue;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class MultiLineVertexRenderer
extends VertexRenderer {
    public static String CLIENTPROPERTY_SHOWFOLDINGICONS = "showFoldingIcons";
    public static Dimension ZERO_DIMENSION = new Dimension(0, 0);
    public static int INSET = 4;
    public static Rectangle handle = new Rectangle(0, 0, 7, 7);
    protected JGraph graph;
    public static final int SHAPE_RECTANGLE = 0;
    public static final int SHAPE_CIRCLE = 1;
    public static final int SHAPE_DIAMOND = 2;
    public static final int SHAPE_ROUNDED = 3;
    public static final int SHAPE_CYLINDER = 4;
    public static final int SHAPE_TRIANGLE = 5;
    public static JTextPane textPane = new JTextPane();
    protected static JComponent wrapperRenderer;
    protected Object userObject = null;
    protected int shape = 0;
    protected boolean isRichText = false;
    protected boolean stretchImage = false;
    protected boolean isEditing = false;
    protected boolean showFoldingIcons = true;
    protected boolean isGroup = false;
    protected Color graphBackground = Color.white;
    protected Color graphForeground = Color.black;
    protected Component valueComponent;
    protected Area cylinderArea = null;
    protected Polygon diamond = null;
    protected int roundRectArc = 0;
    protected transient boolean showHeavyweight = true;

    public MultiLineVertexRenderer() {
        textPane.setOpaque(false);
        textPane.setBorder(BorderFactory.createEmptyBorder(INSET, INSET, INSET, INSET));
        wrapperRenderer = new JComponent(){

            public void paint(Graphics graphics) {
                if (MultiLineVertexRenderer.this.showHeavyweight) {
                    MultiLineVertexRenderer.this.valueComponent.setSize(this.getSize());
                    if (!MultiLineVertexRenderer.this.isEditing) {
                        MultiLineVertexRenderer.this.valueComponent.paint(graphics);
                    }
                } else {
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    graphics.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    graphics.drawLine(this.getWidth() - 1, 0, 0, this.getHeight() - 1);
                }
            }
        };
        wrapperRenderer.setDoubleBuffered(false);
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        this.graph = jGraph;
        Component component = super.getRendererComponent(jGraph, cellView, bl, bl2, bl3);
        this.graphBackground = jGraph.getBackground();
        this.graphForeground = jGraph.getForeground();
        this.isEditing = jGraph.getEditingCell() == cellView.getCell();
        this.isGroup = DefaultGraphModel.isGroup((GraphModel)jGraph.getModel(), (Object)cellView.getCell());
        Boolean bl4 = (Boolean)jGraph.getClientProperty((Object)CLIENTPROPERTY_SHOWFOLDINGICONS);
        this.showFoldingIcons = bl4 != null ? bl4 : true;
        if (this.valueComponent != null) {
            this.valueComponent.setSize(this.getSize());
            this.valueComponent.setBackground(this.getBackground());
            boolean bl5 = this.showHeavyweight = !bl3 || jGraph.getScale() == 1.0;
            if (this.valueComponent instanceof JComponent) {
                JComponent jComponent = (JComponent)this.valueComponent;
                jComponent.setBorder(this.getBorder());
                jComponent.setOpaque(this.isOpaque());
                jComponent.setDoubleBuffered(false);
                if (jComponent.getComponentCount() > 0 && !this.isEditing && this.showHeavyweight) {
                    return jComponent;
                }
            }
            return wrapperRenderer;
        }
        return component;
    }

    public void paint(Graphics graphics) {
        Object object;
        Border border = this.getBorder();
        this.paintBackground(graphics);
        Dimension dimension = this.getSize();
        int n = this.borderWidth;
        Shape shape = graphics.getClip();
        if (this.shape == 2 || this.shape == 5) {
            object = new Area(this.diamond);
            ((Area)object).intersect(new Area(shape));
            graphics.setClip((Shape)object);
        } else if (this.shape == 4) {
            object = new Area(this.cylinderArea);
            this.cylinderArea.intersect(new Area(shape));
            graphics.setClip((Shape)object);
        } else if (this.shape == 1) {
            object = new Area(new Ellipse2D.Float(-n, -n, dimension.width + n, dimension.height + n));
            ((Area)object).intersect(new Area(shape));
            graphics.setClip((Shape)object);
        }
        if (this.stretchImage) {
            object = null;
            Icon icon = this.getIcon();
            if (icon != null) {
                object = ((ImageIcon)icon).getImage();
            }
            if (object != null && !this.preview) {
                graphics.drawImage((Image)object, 0, 0, dimension.width - 1, dimension.height - 1, (ImageObserver)((Object)this));
            }
            this.setIcon(null);
        }
        boolean bl = this.selected;
        boolean bl2 = this.isOpaque();
        if (this.shape != 0) {
            this.setBorder(null);
            this.setOpaque(false);
            this.selected = false;
        }
        if (this.isRichText) {
            this.setText("");
        }
        super.paint(graphics);
        this.setBorder(border);
        this.setOpaque(bl2);
        this.selected = bl;
        if (this.isRichText) {
            this.paintRichText(graphics);
        }
        graphics.setClip(shape);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        if (this.shape != 0 && this.getBorder() != null) {
            graphics.setColor(this.bordercolor);
            graphics2D.setStroke(new BasicStroke(n));
            this.paintShapeBorder(graphics);
        }
        if (this.selected || this.childrenSelected) {
            if (this.childrenSelected) {
                graphics.setColor(this.gridColor);
            } else {
                graphics.setColor(this.highlightColor);
            }
            graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
            this.paintShapeBorder(graphics);
        }
        graphics2D.setStroke(stroke);
        if (this.showFoldingIcons) {
            this.paintFoldingIcon(graphics);
        }
    }

    protected void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.borderWidth;
        if (this.shape != 0) {
            int[] nArray;
            int n2;
            int n3;
            int n4;
            if (this.shape == 2) {
                n4 = dimension.width - n;
                n3 = dimension.height - n;
                n2 = (dimension.width - n) / 2;
                int n5 = (dimension.height - n) / 2;
                nArray = new int[]{n2, n4, n2, 0};
                int[] nArray2 = new int[]{0, n5, n3, n5};
                this.diamond = new Polygon(nArray, nArray2, 4);
            }
            if (this.shape == 5) {
                n4 = dimension.width - n;
                n3 = dimension.height - n;
                n2 = (dimension.height - n) / 2;
                int[] nArray3 = new int[]{0, n4, 0};
                nArray = new int[]{0, n2, n3};
                this.diamond = new Polygon(nArray3, nArray, 3);
            } else if (this.shape == 4) {
                n4 = (int)(dimension.getHeight() / 4.0);
                n3 = dimension.width - n - 1;
                this.cylinderArea = new Area(new Rectangle(n, (n4 - n) / 2 + n, n3, dimension.height - n4 - n));
                this.cylinderArea.add(new Area(new Ellipse2D.Double(n, n, n3, n4 - n)));
                this.cylinderArea.add(new Area(new Ellipse2D.Double(n, dimension.height - n4 - n, n3, n4)));
            } else if (this.shape == 3) {
                this.roundRectArc = MultiLineVertexRenderer.getArcSize(dimension.width - n, dimension.height - n);
            }
            if (this.isOpaque()) {
                graphics.setColor(super.getBackground());
                if (this.gradientColor != null && !this.preview) {
                    ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                }
                if (this.shape == 1) {
                    graphics.fillOval(n - 1, n - 1, dimension.width - n, dimension.height - n);
                } else if (this.shape == 4) {
                    ((Graphics2D)graphics).fill(this.cylinderArea);
                } else if (this.shape == 2 || this.shape == 5) {
                    graphics.fillPolygon(this.diamond);
                } else if (this.shape == 3) {
                    graphics.fillRoundRect(n / 2, n / 2, dimension.width - (int)((double)n * 1.5), dimension.height - (int)((double)n * 1.5), this.roundRectArc, this.roundRectArc);
                }
            }
        }
    }

    protected void paintRichText(Graphics graphics) {
        textPane.setSize(this.getSize());
        int n = 0;
        if (this.getVerticalAlignment() == 0) {
            n = (int)(((double)this.getHeight() - textPane.getPreferredSize().getHeight()) / 2.0) + 2 * INSET;
        } else if (this.getVerticalAlignment() == 3) {
            n = (int)((double)this.getHeight() - textPane.getPreferredSize().getHeight() + (double)(3 * INSET));
        }
        graphics.translate(0, n);
        textPane.paint(graphics);
        graphics.translate(0, -n);
    }

    protected void paintShapeBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.borderWidth;
        if (this.shape == 1) {
            graphics.drawOval(n - 1, n - 1, dimension.width - n, dimension.height - n);
        } else if (this.shape == 4) {
            int n2 = (int)(dimension.getHeight() / 4.0);
            int n3 = dimension.width - n - 1;
            graphics.drawOval(n, n, n3, n2 - n);
            graphics.drawLine(n, (n2 - n) / 2 + 2 + n, n, dimension.height - (n2 - n) / 2 - 2 - n);
            graphics.drawLine(dimension.width - (n + 1) / 2, (n2 - n) / 2 + 2 + n, dimension.width - (n + 1) / 2, dimension.height - (n2 - n) / 2 - 2 - n);
            graphics.drawArc(n, dimension.height - n2 - n, n3, n2, 0, this.isOpaque() ? -180 : 360);
        } else if (this.shape == 2 || this.shape == 5) {
            graphics.drawPolygon(this.diamond);
        } else if (this.shape == 3) {
            graphics.drawRoundRect(n / 2, n / 2, dimension.width - (int)((double)n * 1.5) - 1, dimension.height - (int)((double)n * 1.5), this.roundRectArc, this.roundRectArc);
        }
    }

    protected void paintFoldingIcon(Graphics graphics) {
        if (this.isGroup) {
            graphics.setColor(this.graphBackground);
            graphics.fill3DRect(MultiLineVertexRenderer.handle.x, MultiLineVertexRenderer.handle.y, MultiLineVertexRenderer.handle.width, MultiLineVertexRenderer.handle.height, true);
            graphics.setColor(this.graphForeground);
            graphics.drawRect(MultiLineVertexRenderer.handle.x, MultiLineVertexRenderer.handle.y, MultiLineVertexRenderer.handle.width, MultiLineVertexRenderer.handle.height);
            int n = MultiLineVertexRenderer.handle.y + MultiLineVertexRenderer.handle.height / 2;
            graphics.drawLine(MultiLineVertexRenderer.handle.x + 1, n, MultiLineVertexRenderer.handle.x + MultiLineVertexRenderer.handle.width - 2, n);
            if (this.view.isLeaf()) {
                int n2 = MultiLineVertexRenderer.handle.x + MultiLineVertexRenderer.handle.width / 2;
                graphics.drawLine(n2, MultiLineVertexRenderer.handle.y + 1, n2, MultiLineVertexRenderer.handle.y + MultiLineVertexRenderer.handle.height - 2);
            }
        }
    }

    public static int getArcSize(int n, int n2) {
        int n3;
        if (n <= n2) {
            n3 = n2 / 5;
            if (n3 > n / 2) {
                n3 = n / 2;
            }
        } else {
            n3 = n / 5;
            if (n3 > n2 / 2) {
                n3 = n2 / 2;
            }
        }
        return n3;
    }

    public Point2D getPerimeterPoint(VertexView vertexView, Point2D point2D, Point2D point2D2) {
        int n = CellConstants.getVertexShape((Map)vertexView.getAllAttributes());
        if (n == 2) {
            return this.getDiamondPerimeterPoint(vertexView, point2D, point2D2);
        }
        if (n == 1) {
            return this.getCirclePerimeterPoint(vertexView, point2D, point2D2);
        }
        if (n == 5) {
            return this.getTrianglePerimeterPoint(vertexView, point2D, point2D2);
        }
        return super.getPerimeterPoint(vertexView, point2D, point2D2);
    }

    public Point2D getCirclePerimeterPoint(VertexView vertexView, Point2D point2D, Point2D point2D2) {
        double d;
        double d2;
        double d3;
        Rectangle2D rectangle2D = vertexView.getBounds();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY();
        double d6 = (rectangle2D.getWidth() + 1.0) / 2.0;
        double d7 = (rectangle2D.getHeight() + 1.0) / 2.0;
        double d8 = d4 + d6;
        double d9 = d5 + d7;
        double d10 = point2D2.getX();
        double d11 = point2D2.getY();
        double d12 = d10 - d8;
        double d13 = d11 - d9;
        if (d12 == 0.0) {
            return new Point((int)d8, (int)(d9 + d7 * d13 / Math.abs(d13)));
        }
        double d14 = d13 / d12;
        double d15 = d9 - d14 * d8;
        double d16 = d6 * d6 * d14 * d14 + d7 * d7;
        double d17 = -2.0 * d8 * d16;
        double d18 = d6 * d6 * d14 * d14 * d8 * d8 + d7 * d7 * d8 * d8 - d6 * d6 * d7 * d7;
        double d19 = Math.sqrt(d17 * d17 - 4.0 * d16 * d18);
        double d20 = (-d17 + d19) / (2.0 * d16);
        double d21 = (-d17 - d19) / (2.0 * d16);
        double d22 = d14 * d20 + d15;
        double d23 = d14 * d21 + d15;
        double d24 = Math.sqrt(Math.pow(d20 - d10, 2.0) + Math.pow(d22 - d11, 2.0));
        if (d24 < (d3 = Math.sqrt(Math.pow(d21 - d10, 2.0) + Math.pow(d23 - d11, 2.0)))) {
            d2 = d20;
            d = d22;
        } else {
            d2 = d21;
            d = d23;
        }
        return new Point2D.Double(d2, d);
    }

    public Point2D getDiamondPerimeterPoint(VertexView vertexView, Point2D point2D, Point2D point2D2) {
        Rectangle2D rectangle2D = vertexView.getBounds();
        Point2D point2D3 = AbstractCellView.getCenterPoint((CellView)vertexView);
        double d = rectangle2D.getWidth() / 2.0;
        double d2 = rectangle2D.getHeight() / 2.0;
        Point2D.Double double_ = new Point2D.Double(point2D3.getX(), point2D3.getY() - d2);
        Point2D.Double double_2 = new Point2D.Double(point2D3.getX(), point2D3.getY() + d2);
        Point2D.Double double_3 = new Point2D.Double(point2D3.getX() - d, point2D3.getY());
        Point2D.Double double_4 = new Point2D.Double(point2D3.getX() + d, point2D3.getY());
        if (point2D3.getX() == point2D2.getX()) {
            if (point2D3.getY() > point2D2.getY()) {
                return double_;
            }
            return double_2;
        }
        if (point2D3.getY() == point2D2.getY()) {
            if (point2D3.getX() > point2D2.getX()) {
                return double_3;
            }
            return double_4;
        }
        Point2D point2D4 = point2D2.getX() < point2D3.getX() ? (point2D2.getY() < point2D3.getY() ? this.intersection(point2D2, point2D3, double_, double_3) : this.intersection(point2D2, point2D3, double_2, double_3)) : (point2D2.getY() < point2D3.getY() ? this.intersection(point2D2, point2D3, double_, double_4) : this.intersection(point2D2, point2D3, double_2, double_4));
        return point2D4;
    }

    public Point2D getTrianglePerimeterPoint(VertexView vertexView, Point2D point2D, Point2D point2D2) {
        double d;
        Rectangle2D rectangle2D = vertexView.getBounds();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = d2 + d4 / 2.0;
        double d7 = d3 + d5 / 2.0;
        Point2D point2D3 = AbstractCellView.getCenterPoint((CellView)vertexView);
        Point2D.Double double_ = new Point2D.Double(d2, d3);
        Point2D.Double double_2 = new Point2D.Double(d2, d3 + d5);
        Point2D.Double double_3 = new Point2D.Double(d2 + d4, d7);
        double d8 = point2D2.getX() - d6;
        double d9 = point2D2.getY() - d7;
        double d10 = Math.atan2(d9, d8);
        Point2D point2D4 = d10 < -Math.PI + (d = Math.atan2(d5, d4)) || d10 > Math.PI - d ? new Point2D.Double(d2, d7 - d4 * Math.tan(d10) / 2.0) : (d7 > point2D2.getY() ? this.intersection(point2D2, point2D3, double_, double_3) : this.intersection(point2D2, point2D3, double_2, double_3));
        return point2D4;
    }

    protected Point2D intersection(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d = (point2D2.getY() - point2D.getY()) / (point2D2.getX() - point2D.getX());
        double d2 = point2D.getY() - d * point2D.getX();
        double d3 = (point2D4.getY() - point2D3.getY()) / (point2D4.getX() - point2D3.getX());
        double d4 = point2D3.getY() - d3 * point2D3.getX();
        double d5 = (d2 - d4) / (d3 - d);
        double d6 = d * d5 + d2;
        Point2D.Double double_ = new Point2D.Double(d5, d6);
        return double_;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.shape == 1) {
            dimension.width += dimension.width / 8;
            dimension.height += dimension.height / 2;
        } else if (this.shape == 3) {
            dimension.width += dimension.height / 5;
        } else {
            if (this.isRichText) {
                textPane.setSize(ZERO_DIMENSION);
                return textPane.getPreferredSize();
            }
            if (this.valueComponent != null) {
                return this.valueComponent.getPreferredSize();
            }
        }
        return dimension;
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.shape = CellConstants.getVertexShape((Map)this.view.getAllAttributes());
        this.isRichText = false;
        this.valueComponent = null;
    }

    public void installAttributes(CellView cellView) {
        Object object;
        Border border;
        super.installAttributes(cellView);
        AttributeMap attributeMap = cellView.getAllAttributes();
        this.shape = CellConstants.getVertexShape((Map)cellView.getAllAttributes());
        this.stretchImage = CellConstants.isStretchImage((Map)attributeMap);
        int n = GraphConstants.getInset((Map)attributeMap);
        Border border2 = border = n > 0 ? BorderFactory.createEmptyBorder(n, n, n, n) : null;
        if (border != null) {
            if (this.getBorder() == null) {
                this.setBorder(border);
            } else {
                this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), border));
            }
        }
        this.userObject = this.graph.getModel().getValue(cellView.getCell());
        if (this.userObject instanceof RichTextBusinessObject) {
            object = (RichTextBusinessObject)this.userObject;
            this.isRichText = ((RichTextBusinessObject)object).isRichText();
            this.valueComponent = ((RichTextBusinessObject)object).isComponent() ? (Component)((RichTextBusinessObject)object).getValue() : null;
        } else {
            this.isRichText = false;
            this.valueComponent = null;
        }
        if (this.isRichText) {
            object = (StyledDocument)textPane.getDocument();
            ((RichTextValue)((RichTextBusinessObject)this.userObject).getValue()).insertInto((Document)object);
            if (border != null) {
                textPane.setBorder(border);
            } else {
                textPane.setBorder(BorderFactory.createEmptyBorder(INSET, INSET, INSET, INSET));
            }
            int n2 = this.getHorizontalAlignment();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            n2 = n2 == 0 ? 1 : (n2 == 4 ? 2 : 0);
            StyleConstants.setAlignment(simpleAttributeSet, n2);
            object.setParagraphAttributes(0, object.getLength(), simpleAttributeSet, true);
        }
    }

    public boolean inHitRegion(Point2D point2D) {
        if (this.showFoldingIcons) {
            return handle.contains(Math.max(0.0, point2D.getX() - 1.0), Math.max(0.0, point2D.getY() - 1.0));
        }
        return false;
    }
}

