/*
 * Decompiled with CFR 0.152.
 */
package presentation.util;

import abstraction.Service;
import control.CState;
import control.Orchestrator;
import control.OrchestratorKey;
import control.SimulatedBy;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import presentation.CustomTableModel;

public class XmlTableOrchestratorFactory {
    private static final String HEADER_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    private static final String HREF_XSL = "<?xml-stylesheet href=\"";
    private static final String HREF_TYPE = "\" type=\"text/xsl\"?>\n\n";
    private static final String[] orchestratorColumnName = new String[]{"Target Service State", "Available Services States", "Action", "Available Services"};
    private static final String[] simulationColumnName = new String[]{"Simulated Target State ", "Is Simulated by (Community State)"};
    private String xmlOrchestrator = null;
    private String xmlSimulation = null;
    private CustomTableModel orchestratorModel = null;
    private CustomTableModel simulationModel = null;
    private Orchestrator orchestrator = null;
    private static final String XSL_ORCHESTRATOR = "<?xml version=\"1.0\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n<xsl:output method=\"html\"/>\n\n<xsl:template match=\"/Orchestrator\">\n\t<html>\n\t\t<body>\n\t\t\t<TABLE width=\"90%\" border=\"2\" bordercolor=\"#000000\">\n\t\t\t\t<CAPTION>\n\t\t\t\t\t<DIV align=\"center\"><font size=\"4\"><b>ORCHESTRATOR RESULT</b></font></DIV>\n\t\t\t\t\t<xsl:text>&#160;</xsl:text>\n\t\t\t\t</CAPTION>\n\t\t\t\t<THEAD>\n\t\t\t\t\t<TR>\n\t\t\t\t\t\t<TH><font size=\"4\">Target Service State</font></TH>\n\t\t\t\t\t\t<TH><font size=\"4\">Available Services States</font></TH>\n\t\t\t\t\t\t<TH><font size=\"4\">Action</font></TH>\n\t\t\t\t\t\t<TH><font size=\"4\">Available Services</font></TH>\n\t\t\t\t\t</TR>\n\t\t\t\t</THEAD>\n\t\t\t\t<TBODY>\n\t\t\t\t\t<xsl:apply-templates/>\n\t\t\t\t</TBODY>\n\t\t\t</TABLE>\n\t\t</body>\n\t</html>\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine\">\n\t<TR>\n\t\t<xsl:apply-templates select=\"Input\"/>\n\t\t<TD>\n\t\t\t<xsl:apply-templates select=\"AvailableServices\"/>\n\t\t</TD>\n\t</TR>\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/Input\">\n\t<xsl:apply-templates select=\"TargetState\"/>\n\t<TD>\n\t\t<DIV align=\"center\"><xsl:apply-templates select=\".//AvailableState\"/></DIV>\n\t\t\n\t</TD>\n\t<xsl:apply-templates select=\"Action\"/>\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/Input/TargetState\">\n\t<TD><DIV align=\"center\"><xsl:value-of select=\"@name\"/></DIV></TD>\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/Input/AvailableState\">\n\t<xsl:value-of select=\"@name\"/>,\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/Input/AvailableState[last()]\">\n\t<xsl:value-of select=\"@name\"/>\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/Input/Action\">\n\t<TD><DIV align=\"center\"><xsl:value-of select=\"@name\"/></DIV></TD>\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/AvailableServices\">\n\t<DIV align=\"center\"><xsl:apply-templates /></DIV>\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/AvailableServices/Service\">\n\t<xsl:value-of select=\"@name\"/>,\n</xsl:template>\n\n<xsl:template match=\"/Orchestrator/OrchestratorLine/AvailableServices/Service[last()]\">\n\t<xsl:value-of select=\"@name\"/>\n</xsl:template>\n\n</xsl:stylesheet>";
    private static final String XSL_SIMULATION = "<?xml version=\"1.0\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n<xsl:output method=\"html\"/>\n\n<xsl:template match=\"/SimulationSet\">\n\t<html>\n\t\t<body>\n\t\t\t<TABLE width=\"60%\" border=\"2\" bordercolor=\"#000000\">\n\t\t\t\t<CAPTION>\n\t\t\t\t\t<DIV align=\"CENTER\"><font size=\"4\"><b>COMPOSITION RESULT </b></font></DIV>\n\t\t\t\t\t<xsl:text>&#160;</xsl:text>\n\t\t\t\t</CAPTION>\n\t\t\t\t<THEAD>\n\t\t\t\t\t<TR>\n\t\t\t\t\t\t<TH>\n\t\t\t\t\t\t\t<font size=\"4\">Simulated Target State</font>\n\t\t\t\t\t\t</TH>\n\t\t\t\t\t\t<TH>\n\t\t\t\t\t\t\t<font size=\"4\">Is Simulated by (Community State)</font>\n\t\t\t\t\t\t</TH>\n\t\t\t\t\t</TR>\n\t\t\t\t</THEAD>\n\t\t\t\t<TBODY>\n\t\t\t\t\t<xsl:apply-templates/>\n\t\t\t\t</TBODY>\n\t\t\t</TABLE>\n\t\t</body>\n\t</html>\n</xsl:template>\n\n<xsl:template match=\"/SimulationSet/SimulatedStates\">\n\t<TR>\n\t\t<xsl:apply-templates/>\n\t</TR>\n</xsl:template>\n\n<xsl:template match=\"/SimulationSet/SimulatedStates/TargetState\">\n\t<TD>\n\t\t<DIV align=\"center\"><xsl:value-of select=\"@name\"/></DIV>\n\t</TD>\n</xsl:template>\n\n<xsl:template match=\"/SimulationSet/SimulatedStates/CommunityState\">\n\t<TD><DIV align=\"center\"><xsl:value-of select=\"@name\"/></DIV>\n\t</TD>\n</xsl:template>\n\n</xsl:stylesheet>";

    public XmlTableOrchestratorFactory(Orchestrator orch) {
        this.orchestrator = orch;
    }

    public String getXmlOrchestrator() {
        if (this.xmlOrchestrator == null) {
            this.orchestratorMapToString();
        }
        return this.xmlOrchestrator;
    }

    public String getXmlSimulation() {
        if (this.xmlSimulation == null) {
            this.simulationToString();
        }
        return this.xmlSimulation;
    }

    public DefaultTableModel getOrchestratorModel() {
        if (this.orchestratorModel == null) {
            this.orchestratorMapToString();
        }
        return this.orchestratorModel;
    }

    public DefaultTableModel getSimulationModel() {
        if (this.simulationModel == null) {
            this.simulationToString();
        }
        return this.simulationModel;
    }

    public String getXslOrchestrator() {
        return XSL_ORCHESTRATOR;
    }

    public String getXslSimulation() {
        return XSL_SIMULATION;
    }

    private void orchestratorMapToString() {
        this.orchestratorModel = new CustomTableModel(orchestratorColumnName);
        Iterator<Map.Entry<OrchestratorKey, Set<Service>>> it = this.orchestrator.getOrchestrator();
        StringBuilder xml = new StringBuilder();
        xml.append(HEADER_XML);
        xml.append("<?xml-stylesheet href=\"orch.xsl\" type=\"text/xsl\"?>\n\n");
        xml.append("<Orchestrator> \n");
        while (it.hasNext()) {
            Map.Entry<OrchestratorKey, Set<Service>> set = it.next();
            OrchestratorKey key = set.getKey();
            SimulatedBy sim = key.getSimulatedBy();
            CState cs = sim.getCommunityState();
            Object[] row = new String[4];
            xml.append("\t<OrchestratorLine>\n");
            xml.append("\t\t<Input>\n");
            xml.append("\t\t\t<TargetState name=\"" + sim.getTargetState() + "\"/>\n");
            row[0] = sim.getTargetState().getName();
            StringBuilder asn = new StringBuilder();
            int n = cs.getSize();
            int i = 0;
            while (i < n) {
                xml.append("\t\t\t<AvailableState name=\"" + cs.get(i) + "\"/>\n");
                asn.append(cs.get(i)).append(",");
                ++i;
            }
            asn.deleteCharAt(asn.length() - 1);
            row[1] = asn.toString();
            xml.append("\t\t\t<Action name=\"" + key.getAction() + "\"/>\n");
            row[2] = key.getAction().getName();
            xml.append("\t\t</Input>\n");
            Set<Service> servs = set.getValue();
            xml.append("\t\t<AvailableServices>\n");
            Iterator<Service> iter = servs.iterator();
            StringBuilder svs = new StringBuilder();
            while (iter.hasNext()) {
                Service serv = iter.next();
                xml.append("\t\t\t<Service name =\"" + serv.getName() + "\"/>\n");
                svs.append(serv.getName()).append(",");
            }
            svs.deleteCharAt(svs.length() - 1);
            row[3] = svs.toString();
            this.orchestratorModel.addRow(row);
            xml.append("\t\t</AvailableServices>\n");
            xml.append("\t</OrchestratorLine>\n");
        }
        xml.append("</Orchestrator> \n");
        this.xmlOrchestrator = xml.toString();
    }

    private void simulationToString() {
        this.simulationModel = new CustomTableModel(simulationColumnName);
        Iterator<SimulatedBy> it = this.orchestrator.getSimulationSet();
        StringBuilder xml = new StringBuilder();
        xml.append(HEADER_XML);
        xml.append("<?xml-stylesheet href=\"sim.xsl\" type=\"text/xsl\"?>\n\n");
        xml.append("<SimulationSet> \n");
        while (it.hasNext()) {
            SimulatedBy set = it.next();
            CState cs = set.getCommunityState();
            Object[] row = new String[2];
            xml.append("\t<SimulatedStates>\n");
            xml.append("\t\t<TargetState name=\"" + set.getTargetState() + "\"/>\n");
            row[0] = set.getTargetState().getName();
            int n = cs.getSize();
            xml.append("\t\t<CommunityState name=\"");
            StringBuilder csm = new StringBuilder();
            int i = 0;
            while (i < n) {
                csm.append(cs.get(i));
                ++i;
            }
            xml.append((CharSequence)csm);
            row[1] = csm.toString();
            xml.append("\"/>\n");
            xml.append("\t</SimulatedStates>\n");
            this.simulationModel.addRow(row);
        }
        xml.append("</SimulationSet> \n");
        this.xmlSimulation = xml.toString();
    }
}

