/*
 * Decompiled with CFR 0.152.
 */
package presentation.util;

import abstraction.Service;
import abstraction.State;
import abstraction.TransitionFunction;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.jgraph.JGraph;

public class Exporter {
    private Exporter() {
    }

    public static void exportToImage(File file, JGraph graph) {
        BufferedImage image = graph.getImage(Color.WHITE, 100);
        try {
            ImageIO.write((RenderedImage)image, "jpeg", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportToDot(File file, Service service) {
        StringBuilder str = new StringBuilder("digraph ");
        str.append(service.getName());
        str.append(" {\n");
        Iterator<State> finalNodes = service.getFinalStates();
        while (finalNodes.hasNext()) {
            str.append("\t");
            str.append(finalNodes.next().getName());
            str.append(" [shape = doublecircle];\n");
        }
        Iterator<TransitionFunction> actions = service.getTransitionFunctions();
        while (actions.hasNext()) {
            TransitionFunction action = actions.next();
            str.append("\t");
            str.append(action.getPresentState().getName());
            str.append(" -> ");
            str.append(action.getNextState().getName());
            str.append(" [ label = \"");
            str.append(action.getAction().getName());
            str.append("\" ];\n");
        }
        str.append("}");
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(str.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportToText(File file, String text) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(text);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

