/*
 * Decompiled with CFR 0.152.
 */
package presentation.graph;

import abstraction.Action;
import abstraction.Service;
import abstraction.State;
import abstraction.StateAction;
import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.graph.JGraphSimpleLayout;
import com.jgraph.layout.hierarchical.JGraphHierarchicalLayout;
import com.jgraph.layout.organic.JGraphOrganicLayout;
import com.jgraph.layout.tree.JGraphTreeLayout;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.util.ParallelEdgeRouter;
import presentation.graph.FinalStateVertex;
import presentation.graph.StateCellViewFactory;

public class GraphFactory {
    private JGraph graph;
    private HashMap<State, DefaultGraphCell> vertexMap;
    private HashMap<StateAction, DefaultEdge> edgeMap;
    public static final String[] layouts = new String[]{"Hierarchical", "Circle", "Tree", "Organic"};

    public GraphFactory(Service service) {
        this.createGraph(service);
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public HashMap<State, DefaultGraphCell> getVertexMap() {
        return this.vertexMap;
    }

    public HashMap<StateAction, DefaultEdge> getEdgeMap() {
        return this.edgeMap;
    }

    private void createGraph(Service service) {
        this.vertexMap = new HashMap();
        this.edgeMap = new HashMap();
        Vector<DefaultGraphCell> cells = new Vector<DefaultGraphCell>();
        HashMap<String, DefaultGraphCell> temp = new HashMap<String, DefaultGraphCell>();
        Iterator<State> nodes = service.getStates();
        while (nodes.hasNext()) {
            DefaultGraphCell source;
            State node = nodes.next();
            String nodeName = node.getName();
            if (temp.containsKey(nodeName)) {
                source = (DefaultGraphCell)temp.get(nodeName);
            } else {
                source = GraphFactory.createVertex(nodeName, service.isFinalState(node));
                temp.put(nodeName, source);
                cells.add(source);
                this.vertexMap.put(node, source);
            }
            Iterator<Action> edges = service.getActions(node);
            while (edges.hasNext()) {
                Action act = edges.next();
                String edge = act.getName();
                Iterator<State> targetNodes = service.getNextStates(node, act);
                while (targetNodes.hasNext()) {
                    State targetNode = targetNodes.next();
                    String targetNodeName = targetNode.getName();
                    DefaultGraphCell dest = null;
                    if (temp.containsKey(targetNodeName)) {
                        dest = (DefaultGraphCell)temp.get(targetNodeName);
                    } else {
                        dest = GraphFactory.createVertex(targetNodeName, service.isFinalState(targetNode));
                        temp.put(targetNodeName, dest);
                        cells.add(dest);
                        this.vertexMap.put(targetNode, dest);
                    }
                    DefaultEdge edgeCell = GraphFactory.createEdge(edge, source, dest);
                    cells.add(edgeCell);
                    this.edgeMap.put(new StateAction(node, act), edgeCell);
                }
            }
        }
        DefaultGraphModel model = new DefaultGraphModel();
        GraphLayoutCache view = new GraphLayoutCache(model, new StateCellViewFactory());
        this.graph = new JGraph((GraphModel)model, view);
        this.graph.setEditable(false);
        this.graph.setConnectable(false);
        this.graph.setDisconnectable(false);
        this.graph.setAntiAliased(true);
        this.graph.getGraphLayoutCache().insert(cells.toArray());
        GraphFactory.changeRepresentation(this.graph, layouts[0]);
    }

    public static DefaultGraphCell createVertex(String node, boolean isFinalState) {
        DefaultGraphCell cell = isFinalState ? new FinalStateVertex(node) : new DefaultGraphCell(node);
        GraphConstants.setBounds(cell.getAttributes(), new Rectangle2D.Double(10.0, 10.0, 100.0, 60.0));
        GraphConstants.setGradientColor(cell.getAttributes(), Color.BLACK);
        GraphConstants.setOpaque(cell.getAttributes(), true);
        cell.add(new DefaultPort());
        return cell;
    }

    public static DefaultEdge createEdge(String edge, DefaultGraphCell source, DefaultGraphCell target) {
        DefaultEdge cell = new DefaultEdge(edge);
        cell.setSource(source.getChildAt(0));
        cell.setTarget(target.getChildAt(0));
        GraphConstants.setLineEnd(cell.getAttributes(), 1);
        GraphConstants.setEndFill(cell.getAttributes(), true);
        Point2D.Double position = new Point2D.Double(400.0, -10.0);
        GraphConstants.setLabelPosition(cell.getAttributes(), position);
        return cell;
    }

    public static void selectVertex(JGraph graph, DefaultGraphCell cell, boolean select) {
        Color color = select ? Color.BLUE : Color.BLACK;
        Hashtable attrMap = new Hashtable();
        GraphConstants.setGradientColor(attrMap, color);
        Hashtable nested = new Hashtable();
        nested.put(cell, attrMap);
        graph.getGraphLayoutCache().edit(nested);
    }

    public static void selectEdge(JGraph graph, DefaultEdge edge, boolean select) {
        Color color = select ? Color.RED : Color.BLACK;
        Hashtable attrMap = new Hashtable();
        GraphConstants.setLineColor(attrMap, color);
        Hashtable nested = new Hashtable();
        nested.put(edge, attrMap);
        graph.getGraphLayoutCache().edit(nested);
    }

    public static void changeRepresentation(JGraph graph, String layout) {
        ParallelEdgeRouter.setEdgeSeparation(20.0);
        ParallelEdgeRouter.setEdgeDeparture(50.0);
        JGraphFacade fac = new JGraphFacade(graph);
        fac.resetControlPoints(true, ParallelEdgeRouter.getSharedInstance());
        JGraphLayout lay = layout.equals(layouts[0]) ? new JGraphHierarchicalLayout() : (layout.equals(layouts[1]) ? new JGraphSimpleLayout(0) : (layout.equals(layouts[2]) ? new JGraphTreeLayout() : new JGraphOrganicLayout()));
        lay.run(fac);
        graph.getGraphLayoutCache().edit(fac.createNestedMap(true, true));
    }
}

