/*
 * Decompiled with CFR 0.152.
 */
package presentation.graph;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class FinalStateVertexRenderer
extends VertexRenderer {
    private static final long serialVersionUID = -8251096058938250432L;

    @Override
    public void paint(Graphics g) {
        try {
            if (this.gradientColor != null && !this.preview && this.isOpaque()) {
                this.setOpaque(false);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(this.gradientColor);
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.drawOval(3, 3, this.getWidth() - 6, this.getHeight() - 6);
                g2d.drawOval(7, 7, this.getWidth() - 14, this.getHeight() - 14);
            }
            super.paint(g);
            this.paintSelectionBorder(g);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double a = width / 2.0;
        double b = height / 2.0;
        double xCenter = x + a;
        double yCenter = y + b;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = a * Math.cos(alpha) + xCenter;
        double yout = b * Math.sin(alpha) + yCenter;
        return new Point2D.Double(xout, yout);
    }
}

