/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import abstraction.Service;
import abstraction.State;
import control.CState;
import control.Community;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StartStatesDialog
extends JDialog {
    private static final long serialVersionUID = 646838933711454544L;
    private Service target;
    private Community community;
    private State targetInitialState = null;
    private CState availableInitialStates = null;
    private CState tempAvailableInitialStates = null;
    private JPanel initialStatesContentPane = null;
    private JLabel targetInitialStateLabel = null;
    private JLabel availableInitialStatesLabel = null;
    private JLabel availableServiceLabel = null;
    private JComboBox targetInitialStateComboBox = null;
    private JComboBox serviceComboBox = null;
    private JComboBox initialAvailableStateComboBox = null;
    private DefaultComboBoxModel boxModel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;

    public StartStatesDialog(Frame owner, Service targ, Community comm) {
        super(owner);
        this.target = targ;
        this.community = comm;
        this.tempAvailableInitialStates = this.community.getInitialStates();
        this.initialize();
    }

    private void initialize() {
        this.setSize(296, 353);
        this.setContentPane(this.getInitialStatesContentPane());
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Set Initial States");
        this.setVisible(true);
    }

    private JPanel getInitialStatesContentPane() {
        if (this.initialStatesContentPane == null) {
            this.availableServiceLabel = new JLabel();
            this.availableServiceLabel.setBounds(new Rectangle(30, 105, 226, 16));
            this.availableServiceLabel.setText("Available Service Name:");
            this.availableInitialStatesLabel = new JLabel();
            this.availableInitialStatesLabel.setBounds(new Rectangle(30, 180, 226, 16));
            this.availableInitialStatesLabel.setText("Available Inital States:");
            this.targetInitialStateLabel = new JLabel();
            this.targetInitialStateLabel.setBounds(new Rectangle(30, 15, 226, 16));
            this.targetInitialStateLabel.setText("Target Initial State: " + this.target.getInitialState());
            this.initialStatesContentPane = new JPanel();
            this.initialStatesContentPane.setLayout(null);
            this.initialStatesContentPane.add((Component)this.targetInitialStateLabel, null);
            this.initialStatesContentPane.add((Component)this.getTargetInitialStateComboBox(), null);
            this.initialStatesContentPane.add((Component)this.availableInitialStatesLabel, null);
            this.initialStatesContentPane.add((Component)this.getOkButton(), null);
            this.initialStatesContentPane.add((Component)this.getCancelButton(), null);
            this.initialStatesContentPane.add((Component)this.availableServiceLabel, null);
            this.initialStatesContentPane.add((Component)this.getServiceComboBox(), null);
            this.initialStatesContentPane.add((Component)this.getInitialAvailableStateComboBox(), null);
        }
        return this.initialStatesContentPane;
    }

    private JComboBox getTargetInitialStateComboBox() {
        if (this.targetInitialStateComboBox == null) {
            this.targetInitialStateComboBox = new JComboBox();
            this.targetInitialStateComboBox.setBounds(new Rectangle(60, 45, 151, 31));
            this.targetInitialStateComboBox.setToolTipText("Choose an initial state for the target service");
            Iterator<State> it = this.target.getStates();
            while (it.hasNext()) {
                this.targetInitialStateComboBox.addItem(it.next());
            }
            this.targetInitialStateComboBox.setSelectedIndex(-1);
            this.targetInitialStateComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StartStatesDialog.this.targetInitialStateLabel.setText("Target Initial State: " + (State)StartStatesDialog.this.targetInitialStateComboBox.getSelectedItem());
                }
            });
        }
        return this.targetInitialStateComboBox;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(30, 270, 92, 31));
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StartStatesDialog.this.targetInitialState = (State)StartStatesDialog.this.targetInitialStateComboBox.getSelectedItem();
                    if (StartStatesDialog.this.targetInitialState == null) {
                        StartStatesDialog.this.targetInitialState = StartStatesDialog.this.target.getInitialState();
                    }
                    StartStatesDialog.this.availableInitialStates = StartStatesDialog.this.tempAvailableInitialStates;
                    StartStatesDialog.this.closeDialog();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(new Rectangle(165, 270, 91, 31));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StartStatesDialog.this.targetInitialState = null;
                    StartStatesDialog.this.availableInitialStates = null;
                    StartStatesDialog.this.closeDialog();
                }
            });
        }
        return this.cancelButton;
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public State getTargetStartState() {
        return this.targetInitialState;
    }

    public CState getAvailableStartStates() {
        return this.availableInitialStates;
    }

    private JComboBox getServiceComboBox() {
        if (this.serviceComboBox == null) {
            this.serviceComboBox = new JComboBox();
            this.serviceComboBox.setBounds(new Rectangle(60, 135, 151, 31));
            this.serviceComboBox.setToolTipText("Choose an available service");
            int i = 0;
            while (i < this.community.size()) {
                this.serviceComboBox.addItem(this.community.getService(i));
                ++i;
            }
            this.serviceComboBox.setSelectedIndex(-1);
            this.serviceComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    StartStatesDialog.this.boxModel = new DefaultComboBoxModel();
                    int index = StartStatesDialog.this.serviceComboBox.getSelectedIndex();
                    Service serv = StartStatesDialog.this.community.getService(index);
                    State actualState = StartStatesDialog.this.tempAvailableInitialStates.get(index);
                    StartStatesDialog.this.availableServiceLabel.setText("Available Service Name: " + serv.getName());
                    StartStatesDialog.this.availableInitialStatesLabel.setText("Available Inital States: " + actualState.getName());
                    Iterator<State> it = serv.getStates();
                    while (it.hasNext()) {
                        StartStatesDialog.this.boxModel.addElement(it.next());
                    }
                    StartStatesDialog.this.initialAvailableStateComboBox.setModel(StartStatesDialog.this.boxModel);
                }
            });
        }
        return this.serviceComboBox;
    }

    private JComboBox getInitialAvailableStateComboBox() {
        if (this.initialAvailableStateComboBox == null) {
            this.initialAvailableStateComboBox = new JComboBox();
            this.initialAvailableStateComboBox.setBounds(new Rectangle(60, 210, 151, 31));
            this.initialAvailableStateComboBox.setToolTipText("Choose an initial state for the selected service");
            this.initialAvailableStateComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int indexServ = StartStatesDialog.this.serviceComboBox.getSelectedIndex();
                    State state = (State)StartStatesDialog.this.initialAvailableStateComboBox.getSelectedItem();
                    StartStatesDialog.this.availableInitialStatesLabel.setText("Available Inital States: " + state.getName());
                    StartStatesDialog.this.tempAvailableInitialStates = StartStatesDialog.this.tempAvailableInitialStates.buildNewState(indexServ, state);
                }
            });
        }
        return this.initialAvailableStateComboBox;
    }
}

