/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import abstraction.Action;
import abstraction.Service;
import abstraction.State;
import abstraction.StateAction;
import control.CState;
import control.Community;
import control.Orchestrator;
import control.OrchestratorKey;
import control.SimulatedBy;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import presentation.CustomTableModel;
import presentation.OrchestratorFrame;
import presentation.StartStatesDialog;
import presentation.graph.GraphFactory;

public class ExecuteOrchestratorPanel
extends JPanel {
    private static final long serialVersionUID = -8112895237970803475L;
    private OrchestratorFrame owner = null;
    private JLabel orchestratorLabel = null;
    private JLabel targetPresentStateLabel = null;
    private JButton doActionButton = null;
    private JButton setStartStatesButton = null;
    private JScrollPane graphScrollPane = null;
    private JScrollPane targetActionsScrollPane = null;
    private JScrollPane availablePresentStatesScrollPane = null;
    private JScrollPane availableServicesScrollPane = null;
    private JTable targetActionsTable = null;
    private JTable availablePresentStatesTable = null;
    private JTable availableServicesTable = null;
    private CustomTableModel actionsModel;
    private CustomTableModel availablePresentStateModel;
    private CustomTableModel availableServicesModel;
    private JGraph graph = null;
    private static final String[] actionColumnName = new String[]{"Action", "Next State"};
    private static final String[] availablePresentStateColumnName = new String[]{"Service", "Present State"};
    private static final String[] availableServicesColumnName = new String[]{"Service"};
    private State presentStateTarget = null;
    private CState presentStateAvailableServices = null;
    private Service targetService = null;
    private Community community;
    private Orchestrator orchestrator;
    private SimulatedBy sm = null;
    private HashMap<String, Integer> indexServices;
    private HashMap<State, DefaultGraphCell> stateTable;
    private HashMap<StateAction, DefaultEdge> actionTable;
    private DefaultEdge selectedEdge;

    public ExecuteOrchestratorPanel(OrchestratorFrame frame) {
        this.initialize();
        this.owner = frame;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints13.ipadx = 40;
        gridBagConstraints13.gridy = 0;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 3;
        gridBagConstraints12.gridy = 3;
        gridBagConstraints12.weightx = 0.0;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.ipadx = 144;
        gridBagConstraints12.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints12.gridx = 0;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 3;
        gridBagConstraints11.gridy = 6;
        gridBagConstraints11.weightx = 0.0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints11.ipadx = 144;
        gridBagConstraints11.gridx = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 3;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints4.ipadx = 144;
        gridBagConstraints4.gridx = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridheight = 7;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints2.ipadx = 45;
        gridBagConstraints2.gridy = 1;
        this.targetPresentStateLabel = new JLabel();
        this.targetPresentStateLabel.setText("Target Present State:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints1.ipadx = 40;
        gridBagConstraints1.gridy = 5;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.ipadx = 32;
        gridBagConstraints.gridy = 0;
        this.orchestratorLabel = new JLabel();
        this.orchestratorLabel.setText("Orchestrator Generator");
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.orchestratorLabel, gridBagConstraints);
        this.add((Component)this.getDoActionButton(), gridBagConstraints1);
        this.add((Component)this.targetPresentStateLabel, gridBagConstraints2);
        this.add((Component)this.getGraphScrollPane(), gridBagConstraints3);
        this.add((Component)this.getTargetActionsScrollPane(), gridBagConstraints4);
        this.add((Component)this.getAvailablePresentStatesScrollPane(), gridBagConstraints11);
        this.add((Component)this.getAvailableServicesScrollPane(), gridBagConstraints12);
        this.add((Component)this.getSetStartStatesButton(), gridBagConstraints13);
    }

    private JButton getDoActionButton() {
        if (this.doActionButton == null) {
            this.doActionButton = new JButton();
            this.doActionButton.setText("Execute Action");
            this.doActionButton.setToolTipText("Execute the selected Action");
            this.doActionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int actionIndex = ExecuteOrchestratorPanel.this.targetActionsTable.getSelectedRow();
                    int serviceIndex = ExecuteOrchestratorPanel.this.availableServicesTable.getSelectedRow();
                    if (actionIndex < 0) {
                        JOptionPane.showMessageDialog(null, "Select an action on the table", "Warning", 2);
                    } else if (serviceIndex < 0) {
                        JOptionPane.showMessageDialog(null, "Select a service on the table", "Warning", 2);
                    } else {
                        GraphFactory.selectVertex(ExecuteOrchestratorPanel.this.graph, (DefaultGraphCell)ExecuteOrchestratorPanel.this.stateTable.get(ExecuteOrchestratorPanel.this.presentStateTarget), false);
                        ExecuteOrchestratorPanel.this.presentStateTarget = (State)ExecuteOrchestratorPanel.this.actionsModel.getValueAt(actionIndex, 1);
                        GraphFactory.selectVertex(ExecuteOrchestratorPanel.this.graph, (DefaultGraphCell)ExecuteOrchestratorPanel.this.stateTable.get(ExecuteOrchestratorPanel.this.presentStateTarget), true);
                        GraphFactory.selectEdge(ExecuteOrchestratorPanel.this.graph, ExecuteOrchestratorPanel.this.selectedEdge, false);
                        ExecuteOrchestratorPanel.this.setLabelPresentState(ExecuteOrchestratorPanel.this.presentStateTarget.getName());
                        Action selectedAction = (Action)ExecuteOrchestratorPanel.this.actionsModel.getValueAt(actionIndex, 0);
                        Service selectedService = (Service)ExecuteOrchestratorPanel.this.availableServicesModel.getValueAt(serviceIndex, 0);
                        int index = (Integer)ExecuteOrchestratorPanel.this.indexServices.get(selectedService.getName());
                        State presentAvailableState = ExecuteOrchestratorPanel.this.presentStateAvailableServices.get(index);
                        Iterator<State> it = selectedService.getNextStates(presentAvailableState, selectedAction);
                        State nextState = it.next();
                        ExecuteOrchestratorPanel.this.presentStateAvailableServices = ExecuteOrchestratorPanel.this.presentStateAvailableServices.buildNewState(index, nextState);
                        ExecuteOrchestratorPanel.this.availablePresentStateModel.setValueAt(nextState, index, 1);
                        ExecuteOrchestratorPanel.this.sm = new SimulatedBy(ExecuteOrchestratorPanel.this.presentStateTarget, ExecuteOrchestratorPanel.this.presentStateAvailableServices);
                        ExecuteOrchestratorPanel.this.actionsModel = new CustomTableModel(actionColumnName);
                        ExecuteOrchestratorPanel.this.targetActionsTable.setModel(ExecuteOrchestratorPanel.this.actionsModel);
                        ExecuteOrchestratorPanel.this.availableServicesModel = new CustomTableModel(availableServicesColumnName);
                        ExecuteOrchestratorPanel.this.availableServicesTable.setModel(ExecuteOrchestratorPanel.this.availableServicesModel);
                        Iterator<Action> actions = ExecuteOrchestratorPanel.this.targetService.getActions(ExecuteOrchestratorPanel.this.presentStateTarget);
                        while (actions.hasNext()) {
                            Action action = actions.next();
                            Iterator<State> nextStates = ExecuteOrchestratorPanel.this.targetService.getNextStates(ExecuteOrchestratorPanel.this.presentStateTarget, action);
                            while (nextStates.hasNext()) {
                                State next = nextStates.next();
                                ExecuteOrchestratorPanel.this.actionsModel.addRow(new Object[]{action, next});
                            }
                        }
                    }
                }
            });
        }
        return this.doActionButton;
    }

    private JScrollPane getGraphScrollPane() {
        if (this.graphScrollPane == null) {
            this.graphScrollPane = new JScrollPane();
        }
        return this.graphScrollPane;
    }

    private JScrollPane getTargetActionsScrollPane() {
        if (this.targetActionsScrollPane == null) {
            this.targetActionsScrollPane = new JScrollPane();
            this.targetActionsScrollPane.setViewportView(this.getTargetActionsTable());
        }
        return this.targetActionsScrollPane;
    }

    private JTable getTargetActionsTable() {
        if (this.targetActionsTable == null) {
            this.targetActionsTable = new JTable();
            this.targetActionsTable.setToolTipText("Choose an action");
            this.targetActionsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int ind = ExecuteOrchestratorPanel.this.targetActionsTable.getSelectedRow();
                    Action action = (Action)ExecuteOrchestratorPanel.this.actionsModel.getValueAt(ind, 0);
                    OrchestratorKey ok = new OrchestratorKey(ExecuteOrchestratorPanel.this.sm, action);
                    Iterator<Service> s = ExecuteOrchestratorPanel.this.orchestrator.getServicesForStateAction(ok);
                    Service se = null;
                    ExecuteOrchestratorPanel.this.availableServicesModel = new CustomTableModel(availableServicesColumnName);
                    while (s.hasNext()) {
                        se = s.next();
                        ExecuteOrchestratorPanel.this.availableServicesModel.addRow(new Object[]{se});
                    }
                    ExecuteOrchestratorPanel.this.availableServicesTable.setModel(ExecuteOrchestratorPanel.this.availableServicesModel);
                    if (ExecuteOrchestratorPanel.this.selectedEdge != null) {
                        GraphFactory.selectEdge(ExecuteOrchestratorPanel.this.graph, ExecuteOrchestratorPanel.this.selectedEdge, false);
                    }
                    ExecuteOrchestratorPanel.this.selectedEdge = (DefaultEdge)ExecuteOrchestratorPanel.this.actionTable.get(new StateAction(ExecuteOrchestratorPanel.this.presentStateTarget, action));
                    GraphFactory.selectEdge(ExecuteOrchestratorPanel.this.graph, ExecuteOrchestratorPanel.this.selectedEdge, true);
                }
            });
        }
        return this.targetActionsTable;
    }

    private void setLabelPresentState(String state) {
        this.targetPresentStateLabel.setText("Target Present State: " + state);
    }

    public void initExecuteOrchestratorPanel(Service target, Community com, Orchestrator orch) {
        this.targetService = target;
        this.community = com;
        this.orchestrator = orch;
        this.presentStateTarget = null;
        GraphFactory gf = new GraphFactory(this.targetService);
        this.graph = gf.getGraph();
        this.stateTable = gf.getVertexMap();
        this.actionTable = gf.getEdgeMap();
        this.graphScrollPane.setViewportView(this.graph);
        this.init(this.targetService.getInitialState(), this.community.getInitialStates());
    }

    private void init(State tis, CState ais) {
        this.actionsModel = new CustomTableModel(actionColumnName);
        this.targetActionsTable.setModel(this.actionsModel);
        this.availablePresentStateModel = new CustomTableModel(availablePresentStateColumnName);
        this.availablePresentStatesTable.setModel(this.availablePresentStateModel);
        this.availableServicesModel = new CustomTableModel(availableServicesColumnName);
        this.availableServicesTable.setModel(this.availableServicesModel);
        this.presentStateAvailableServices = ais;
        if (this.presentStateTarget != null) {
            GraphFactory.selectVertex(this.graph, this.stateTable.get(this.presentStateTarget), false);
        }
        this.presentStateTarget = tis;
        GraphFactory.selectVertex(this.graph, this.stateTable.get(this.presentStateTarget), true);
        this.setLabelPresentState(this.presentStateTarget.getName());
        if (this.selectedEdge != null) {
            GraphFactory.selectEdge(this.graph, this.selectedEdge, false);
        }
        this.sm = new SimulatedBy(this.presentStateTarget, this.presentStateAvailableServices);
        Iterator<Action> actions = this.targetService.getActions(this.presentStateTarget);
        while (actions.hasNext()) {
            Action action = actions.next();
            Iterator<State> nextStates = this.targetService.getNextStates(this.presentStateTarget, action);
            while (nextStates.hasNext()) {
                State next = nextStates.next();
                this.actionsModel.addRow(new Object[]{action, next});
            }
        }
        this.indexServices = new HashMap(this.community.size());
        int i = 0;
        while (i < this.community.size()) {
            Service s = this.community.getService(i);
            State is = this.presentStateAvailableServices.get(i);
            this.availablePresentStateModel.addRow(new Object[]{s, is});
            this.indexServices.put(s.getName(), i);
            ++i;
        }
    }

    private JScrollPane getAvailablePresentStatesScrollPane() {
        if (this.availablePresentStatesScrollPane == null) {
            this.availablePresentStatesScrollPane = new JScrollPane();
            this.availablePresentStatesScrollPane.setViewportView(this.getAvailablePresentStatesTable());
        }
        return this.availablePresentStatesScrollPane;
    }

    private JTable getAvailablePresentStatesTable() {
        if (this.availablePresentStatesTable == null) {
            this.availablePresentStatesTable = new JTable();
            this.availablePresentStatesTable.setToolTipText("Current states for all available services");
        }
        return this.availablePresentStatesTable;
    }

    private JScrollPane getAvailableServicesScrollPane() {
        if (this.availableServicesScrollPane == null) {
            this.availableServicesScrollPane = new JScrollPane();
            this.availableServicesScrollPane.setViewportView(this.getAvailableServicesTable());
        }
        return this.availableServicesScrollPane;
    }

    private JTable getAvailableServicesTable() {
        if (this.availableServicesTable == null) {
            this.availableServicesTable = new JTable();
            this.availableServicesTable.setToolTipText("Choose an available service");
        }
        return this.availableServicesTable;
    }

    private JButton getSetStartStatesButton() {
        if (this.setStartStatesButton == null) {
            this.setStartStatesButton = new JButton();
            this.setStartStatesButton.setText("Choose starting states");
            this.setStartStatesButton.setToolTipText("Choose the starting stetes for target and available services");
            this.setStartStatesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StartStatesDialog in = new StartStatesDialog((Frame)ExecuteOrchestratorPanel.this.owner, ExecuteOrchestratorPanel.this.targetService, ExecuteOrchestratorPanel.this.community);
                    State its = in.getTargetStartState();
                    CState ias = in.getAvailableStartStates();
                    if (its != null && ias != null) {
                        ExecuteOrchestratorPanel.this.init(its, ias);
                    }
                }
            });
        }
        return this.setStartStatesButton;
    }
}

