/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EdgeView
extends AbstractCellView {
    public static transient EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected CellView source;
    protected CellView target;
    protected CellView sourceParentView;
    protected CellView targetParentView;
    protected Point2D labelPosition;
    protected Point2D[] extraLabelPositions;
    protected transient Point2D labelVector = null;
    public transient Shape beginShape;
    public transient Shape endShape;
    public transient Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected transient Rectangle2D cachedBounds = null;

    public EdgeView() {
    }

    public EdgeView(Object object) {
        super(object);
    }

    public void refresh(GraphLayoutCache graphLayoutCache, CellMapper cellMapper, boolean bl) {
        this.points = null;
        super.refresh(graphLayoutCache, cellMapper, bl);
        GraphModel graphModel = graphLayoutCache.getModel();
        Object object = graphModel.getSource(this.cell);
        Object object2 = graphModel.getTarget(this.cell);
        this.setSource(cellMapper.getMapping(object, bl));
        this.setTarget(cellMapper.getMapping(object2, bl));
        this.sourceParentView = object != null && this.getSource() == null ? this.getVisibleParent(graphModel, cellMapper, object) : null;
        this.targetParentView = object2 != null && this.getTarget() == null ? this.getVisibleParent(graphModel, cellMapper, object2) : null;
    }

    protected CellView getVisibleParent(GraphModel graphModel, CellMapper cellMapper, Object object) {
        CellView cellView = null;
        do {
            cellView = cellMapper.getMapping(object, false);
            object = graphModel.getParent(object);
        } while (cellView == null && object != null);
        return cellView;
    }

    public void update(GraphLayoutCache graphLayoutCache) {
        super.update(graphLayoutCache);
        ArrayList<Point2D> arrayList = GraphConstants.getPoints(this.allAttributes);
        if (arrayList == null) {
            arrayList = new ArrayList<Point2D>(4);
            arrayList.add(this.allAttributes.createPoint(10.0, 10.0));
            arrayList.add(this.allAttributes.createPoint(20.0, 20.0));
            GraphConstants.setPoints(this.allAttributes, arrayList);
        }
        if (this.points == null) {
            this.points = arrayList;
        }
        Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
        List list = null;
        if (routing != null) {
            list = routing.route(graphLayoutCache, this);
        }
        List<Point2D> list2 = this.points = list != null && !list.isEmpty() ? list : arrayList;
        if (this.points == arrayList) {
            if (this.source != null) {
                this.setSource(this.source);
            }
            if (this.target != null) {
                this.setTarget(this.target);
            }
        }
        this.checkDefaultLabelPosition();
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(this.allAttributes);
        if (point2DArray != null) {
            this.extraLabelPositions = new Point2D[point2DArray.length];
            for (int i = 0; i < point2DArray.length; ++i) {
                this.extraLabelPositions[i] = point2DArray[i];
            }
        } else {
            this.extraLabelPositions = null;
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.invalidate();
    }

    protected void checkDefaultLabelPosition() {
        this.labelPosition = GraphConstants.getLabelPosition(this.allAttributes);
        String string = String.valueOf(this.getCell());
        if (this.labelPosition == null && string != null && string.length() > 0) {
            int n = 500;
            this.labelPosition = new Point(n, 0);
            GraphConstants.setLabelPosition(this.allAttributes, this.labelPosition);
        }
    }

    protected void invalidate() {
        this.labelVector = null;
        this.sharedPath = null;
        this.cachedBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public boolean intersects(JGraph jGraph, Rectangle2D rectangle2D) {
        boolean bl = super.intersects(jGraph, rectangle2D);
        if (!this.isLeaf()) {
            return bl;
        }
        if (bl) {
            Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            return this.getEdgeRenderer().intersects(jGraph, this, rectangle);
        }
        return false;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = super.getBounds();
        if (rectangle2D == null) {
            if (this.cachedBounds == null) {
                this.cachedBounds = this.getEdgeRenderer().getBounds(this);
            }
            rectangle2D = this.cachedBounds;
        }
        return rectangle2D;
    }

    EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return new EdgeHandle(this, graphContext);
    }

    public CellView getSource() {
        return this.source;
    }

    public CellView getSourceParentView() {
        return this.sourceParentView;
    }

    public void setSource(CellView cellView) {
        this.sourceParentView = null;
        this.source = cellView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public CellView getTargetParentView() {
        return this.targetParentView;
    }

    public void setTarget(CellView cellView) {
        this.target = cellView;
        this.targetParentView = null;
        int n = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public Point2D getExtraLabelPosition(int n) {
        return this.extraLabelPositions[n];
    }

    public Point2D getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point2D point2D) {
        this.labelPosition.setLocation(point2D);
        this.invalidate();
    }

    public void setExtraLabelPosition(int n, Point2D point2D) {
        this.extraLabelPositions[n].setLocation(point2D);
        this.invalidate();
    }

    public boolean isLoop() {
        return this.getSource() != null && this.getSource() == this.getTarget() || this.sourceParentView != null && this.sourceParentView == this.targetParentView || this.sourceParentView != null && this.getTarget() != null && this.getTarget().getParentView() == this.sourceParentView || this.targetParentView != null && this.getSource() != null && this.getSource().getParentView() == this.targetParentView;
    }

    public List getPoints() {
        return this.points;
    }

    public int getPointCount() {
        if (this.points != null) {
            return this.points.size();
        }
        return 0;
    }

    public Point2D getPoint(int n) {
        Object e = this.points.get(n);
        if (n == 0 && this.sourceParentView != null) {
            return this.sourceParentView.getPerimeterPoint(this, EdgeView.getCenterPoint(this.sourceParentView), this.getNearestPoint(n == 0));
        }
        if (n == this.getPointCount() - 1 && this.targetParentView != null) {
            return this.targetParentView.getPerimeterPoint(this, EdgeView.getCenterPoint(this.targetParentView), this.getNearestPoint(n == 0));
        }
        if (e instanceof PortView) {
            return ((PortView)e).getLocation(this, this.getNearestPoint(n == 0));
        }
        if (e instanceof CellView) {
            Rectangle2D rectangle2D = ((CellView)e).getBounds();
            return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        }
        if (e instanceof Point2D) {
            return (Point2D)e;
        }
        return null;
    }

    protected Point2D getNearestPoint(boolean bl) {
        if (this.getPointCount() == 2) {
            if (bl && this.target instanceof PortView && GraphConstants.getOffset(this.target.getAllAttributes()) != null) {
                return ((PortView)this.target).getLocation(this);
            }
            if (!bl && this.source instanceof PortView && GraphConstants.getOffset(this.source.getAllAttributes()) != null) {
                return ((PortView)this.source).getLocation(this);
            }
            if (bl && this.targetParentView != null && this.targetParentView.isLeaf()) {
                return EdgeView.getCenterPoint(this.targetParentView);
            }
            if (!bl && this.sourceParentView != null && this.sourceParentView.isLeaf()) {
                return EdgeView.getCenterPoint(this.sourceParentView);
            }
        }
        return this.getPointLocation(bl ? 1 : this.getPointCount() - 2);
    }

    protected Point2D getPointLocation(int n) {
        CellView cellView;
        Object e = this.points.get(n);
        if (e instanceof Point2D) {
            return (Point2D)e;
        }
        if (e instanceof PortView && (cellView = ((CellView)e).getParentView()) != null) {
            return EdgeView.getCenterPoint(cellView);
        }
        return null;
    }

    public void setPoint(int n, Point2D point2D) {
        this.points.set(n, point2D);
        this.invalidate();
    }

    public void addPoint(int n, Point2D point2D) {
        this.points.add(n, point2D);
        this.invalidate();
    }

    public void removePoint(int n) {
        this.points.remove(n);
        this.invalidate();
    }

    public void addExtraLabel(Point2D point2D, Object object) {
        Object[] objectArray = GraphConstants.getExtraLabels(this.getAllAttributes());
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (objectArray == null) {
            objectArray = new Object[1];
            point2DArray = new Point2D[1];
        } else {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray = objectArray2;
            Point2D[] point2DArray2 = new Point2D[point2DArray.length + 1];
            System.arraycopy(point2DArray, 0, point2DArray2, 0, point2DArray.length);
            point2DArray = point2DArray2;
        }
        int n = objectArray.length - 1;
        objectArray[n] = object;
        point2DArray[n] = point2D;
        GraphConstants.setExtraLabels(this.getAllAttributes(), objectArray);
        GraphConstants.setExtraLabelPositions(this.getAllAttributes(), point2DArray);
    }

    public void removeExtraLabel(int n) {
        Object[] objectArray = GraphConstants.getExtraLabels(this.getAllAttributes());
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (objectArray == null || objectArray.length > 1) {
            Object[] objectArray2 = new Object[objectArray.length - 1];
            Point2D[] point2DArray2 = new Point2D[point2DArray.length - 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            if (n < objectArray2.length) {
                System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray2.length - n);
            }
            System.arraycopy(point2DArray, 0, point2DArray2, 0, n);
            if (n < point2DArray2.length) {
                System.arraycopy(point2DArray, n + 1, point2DArray2, n, point2DArray2.length - n);
            }
            GraphConstants.setExtraLabels(this.getAllAttributes(), objectArray2);
            GraphConstants.setExtraLabelPositions(this.getAllAttributes(), point2DArray2);
        } else {
            GraphConstants.setExtraLabels(this.getAllAttributes(), new Object[0]);
            GraphConstants.setExtraLabelPositions(this.getAllAttributes(), new Point2D[0]);
        }
    }

    public int getFirstPointOfSegment() {
        boolean bl = GraphConstants.isExactSegmentLabel(this.allAttributes);
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getPointCount();
        if (bl) {
            Point2D point2D = this.getPoint(0);
            double d3 = 0.0;
            for (int i = 1; i < n; ++i) {
                Point2D point2D2 = this.getPoint(i);
                d = point2D2.getX() - point2D.getX();
                d2 = point2D2.getY() - point2D.getY();
                d3 += Math.sqrt(d * d + d2 * d2);
                point2D = point2D2;
            }
            double d4 = this.getLabelPosition().getX() / 1000.0;
            double d5 = d4 * d3;
            d3 = 0.0;
            point2D = this.getPoint(0);
            if (d4 <= 0.0 || d4 >= 1.0) {
                return -1;
            }
            for (int i = 1; i < n; ++i) {
                Point2D point2D3 = this.getPoint(i);
                d = point2D3.getX() - point2D.getX();
                if (!((d3 += Math.sqrt(d * d + (d2 = point2D3.getY() - point2D.getY()) * d2)) > d5)) continue;
                return i - 1;
            }
        } else {
            return -1;
        }
        return -1;
    }

    public Point2D getLabelVector() {
        if (this.labelVector == null) {
            Point2D point2D = this.getPoint(0);
            double d = 0.0;
            double d2 = 0.0;
            int n = this.getPointCount();
            if (this.isLoop()) {
                for (int i = 1; i < n; ++i) {
                    Point2D point2D2 = this.getPoint(i);
                    d += point2D2.getX() - point2D.getX();
                    d2 += point2D2.getY() - point2D.getY();
                }
                this.labelVector = new Point2D.Double(d /= (double)(n /= 2), d2 /= (double)n);
            } else {
                Point2D point2D3;
                boolean bl = GraphConstants.isExactSegmentLabel(this.allAttributes);
                if (bl) {
                    point2D3 = this.getPoint(0);
                    double d3 = 0.0;
                    for (int i = 1; i < n; ++i) {
                        Point2D point2D4 = this.getPoint(i);
                        d = point2D4.getX() - point2D3.getX();
                        d2 = point2D4.getY() - point2D3.getY();
                        d3 += Math.sqrt(d * d + d2 * d2);
                        point2D3 = point2D4;
                    }
                    double d4 = this.getLabelPosition().getX() / 1000.0;
                    double d5 = d4 * d3;
                    d3 = 0.0;
                    point2D3 = this.getPoint(0);
                    if (d4 <= 0.0 || d4 >= 1.0) {
                        bl = false;
                    } else {
                        for (int i = 1; i < n; ++i) {
                            Point2D point2D5 = this.getPoint(i);
                            d = point2D5.getX() - point2D3.getX();
                            if ((d3 += Math.sqrt(d * d + (d2 = point2D5.getY() - point2D3.getY()) * d2)) > d5) {
                                this.labelVector = new Point2D.Double(d, d2);
                                break;
                            }
                            point2D3 = point2D5;
                        }
                    }
                }
                if (!bl || this.labelVector == null) {
                    point2D3 = this.getPoint(n - 1);
                    d = point2D3.getX() - point2D.getX();
                    d2 = point2D3.getY() - point2D.getY();
                    this.labelVector = new Point2D.Double(d, d2);
                }
            }
        }
        return this.labelVector;
    }

    protected Point2D getAbsoluteLabelPosition() {
        Point2D point2D = this.getAbsoluteLabelPositionFromRelative(GraphConstants.getLabelPosition(this.getAllAttributes()));
        return point2D;
    }

    protected Point2D getAbsoluteExtraLabelPosition(int n) {
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (point2DArray != null && point2DArray.length > n) {
            Point2D point2D = this.getAbsoluteLabelPositionFromRelative(point2DArray[n]);
            return point2D;
        }
        return null;
    }

    protected Point2D getAbsoluteLabelPositionFromRelative(Point2D point2D) {
        Point2D point2D2 = this.convertRelativeLabelPositionToAbsolute(point2D);
        if (point2D2 != null) {
            double d = 0.0;
            double d2 = 0.0;
            Point2D point2D3 = GraphConstants.getOffset(this.getAllAttributes());
            if (point2D3 != null) {
                d = point2D3.getX();
                d2 = point2D3.getY();
            }
            double d3 = point2D2.getX() + d;
            double d4 = point2D2.getY() + d2;
            return new Point2D.Double(d3, d4);
        }
        return null;
    }

    protected Point2D convertRelativeLabelPositionToAbsolute(Point2D point2D) {
        Point2D point2D2 = this.getPoint(0);
        if (point2D2 != null) {
            double d;
            double d2;
            double d3 = 0.0;
            int n = this.getPointCount();
            double[] dArray = new double[n];
            for (int i = 1; i < n; ++i) {
                double d4;
                Point2D point2D3 = this.getPoint(i);
                if (point2D3 == null) continue;
                d2 = point2D2.getX() - point2D3.getX();
                d = point2D2.getY() - point2D3.getY();
                dArray[i - 1] = d4 = Math.sqrt(d2 * d2 + d * d);
                d3 += d4;
                point2D2 = point2D3;
            }
            double d5 = point2D.getX() / 1000.0;
            d2 = point2D.getY();
            d = d5 * d3;
            d3 = 0.0;
            int n2 = 1;
            double d6 = dArray[0];
            while (d > d3 + d6 && n2 < n - 1) {
                d3 += d6;
                d6 = dArray[n2++];
            }
            double d7 = (d - d3) / d6;
            Point2D point2D4 = this.getPoint(n2 - 1);
            Point2D point2D5 = this.getPoint(n2);
            if (point2D4 != null && point2D5 != null) {
                double d8 = point2D5.getX() - point2D4.getX();
                double d9 = point2D5.getY() - point2D4.getY();
                double d10 = d9 / d6;
                double d11 = d8 / d6;
                d5 = point2D4.getX() + d8 * d7 - d10 * d2;
                d2 = point2D4.getY() + d9 * d7 + d11 * d2;
                return new Point2D.Double(d5, d2);
            }
        }
        return null;
    }

    public static double getLength(CellView cellView) {
        double d = 1.0;
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            Point2D point2D = null;
            Point2D point2D2 = null;
            for (int i = 0; i < edgeView.getPointCount(); ++i) {
                point2D2 = edgeView.getPoint(i);
                if (point2D != null) {
                    d += point2D.distance(point2D2);
                }
                point2D = point2D2;
            }
        }
        return d;
    }

    public Point2D getPerimeterPoint(EdgeView edgeView, Point2D point2D, Point2D point2D2) {
        if (this.getPointCount() > 2) {
            return this.getPoint(this.getPointCount() / 2);
        }
        Point2D point2D3 = this.getPoint(0);
        Point2D point2D4 = this.getPoint(this.getPointCount() - 1);
        return new Point2D.Double((point2D4.getX() + point2D3.getX()) / 2.0, (point2D4.getY() + point2D3.getY()) / 2.0);
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected JGraph graph;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean source = false;
        protected boolean target = false;
        protected int currentLabel = -1;
        protected int currentIndex = -1;
        protected Point2D currentPoint;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected transient Rectangle2D[] extraLabelLocations;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;
        protected boolean editing = false;
        protected Point2D initialLabelLocation = null;
        protected boolean edgeModified = false;
        protected JComponent highlight = new JPanel();

        public EdgeHandle(EdgeView edgeView, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.edge = edgeView;
            this.editing = this.graph.getEditingCell() == edgeView.getCell();
            this.loc = new Rectangle();
            Object[] objectArray = GraphConstants.getExtraLabels(edgeView.getAllAttributes());
            if (objectArray != null) {
                this.extraLabelLocations = new Rectangle[objectArray.length];
                for (int i = 0; i < this.extraLabelLocations.length; ++i) {
                    this.extraLabelLocations[i] = new Rectangle();
                }
            }
            this.orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(edgeView.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = GraphConstants.isConnectable(edgeView.getAllAttributes());
            this.highlight = this.createHighlight();
        }

        protected JComponent createHighlight() {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createBevelBorder(0));
            jPanel.setVisible(false);
            jPanel.setOpaque(false);
            return jPanel;
        }

        protected void reloadPoints(EdgeView edgeView) {
            this.relevantEdge = edgeView;
            this.r = new Rectangle[edgeView.getPointCount()];
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = new Rectangle();
            }
            this.invalidate();
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            if (!this.edge.isLeaf()) {
                return;
            }
            for (int i = 0; i < this.r.length; ++i) {
                Point2D point2D;
                if (this.isEdgeConnectable && !this.editing) {
                    graphics.setColor(this.graph.getHandleColor());
                } else {
                    graphics.setColor(this.graph.getLockedHandleColor());
                }
                graphics.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
                CellView cellView = null;
                if (i == 0 && this.edge.getSource() != null) {
                    cellView = this.edge.getSource();
                } else if (i == this.r.length - 1 && this.edge.getTarget() != null) {
                    cellView = this.edge.getTarget();
                }
                if (cellView == null && (i != 0 || this.edge.getSourceParentView() == null) && (i != this.r.length - 1 || this.edge.getTargetParentView() == null)) continue;
                graphics.setColor(this.graph.getLockedHandleColor());
                Point2D point2D2 = point2D = cellView != null ? GraphConstants.getOffset(cellView.getAllAttributes()) : null;
                if (point2D != null) {
                    graphics.drawLine((int)this.r[i].getX() + 1, (int)this.r[i].getY() + 1, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3);
                    graphics.drawLine((int)this.r[i].getX() + 1, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)this.r[i].getY() + 1);
                    continue;
                }
                graphics.drawRect((int)this.r[i].getX() + 2, (int)this.r[i].getY() + 2, (int)this.r[i].getWidth() - 5, (int)this.r[i].getHeight() - 5);
            }
            if (!this.graph.isXorEnabled()) {
                this.firstOverlayCall = false;
                this.overlay(graphics);
            }
        }

        protected void highlight(JGraph jGraph, CellView cellView) {
            if (cellView != null) {
                this.highlight.setBounds(this.getHighlightBounds(jGraph, cellView));
                if (this.highlight.getParent() == null) {
                    jGraph.add(this.highlight);
                    this.highlight.setVisible(true);
                }
            } else if (this.highlight.getParent() != null) {
                this.highlight.setVisible(false);
                this.highlight.getParent().remove(this.highlight);
            }
        }

        protected Rectangle getHighlightBounds(JGraph jGraph, CellView cellView) {
            boolean bl = GraphConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle2D rectangle2D = bl ? cellView.getBounds() : cellView.getParentView().getBounds();
            rectangle2D = jGraph.toScreen((Rectangle2D)rectangle2D.clone());
            int n = 3;
            return new Rectangle((int)(rectangle2D.getX() - (double)n), (int)(rectangle2D.getY() - (double)n), (int)(rectangle2D.getWidth() + (double)(2 * n)), (int)(rectangle2D.getHeight() + (double)(2 * n)));
        }

        public void overlay(Graphics graphics) {
            if (this.edge != null && !this.firstOverlayCall && this.edge.isLeaf()) {
                graphics.setColor(this.graph.getForeground());
                if (this.graph.isXorEnabled()) {
                    graphics.setXORMode(this.graph.getBackground().darker());
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(graphics, this.edge, this.edge.getBounds(), true);
                graphics2D.setTransform(affineTransform);
                if (this.graph.isXorEnabled()) {
                    if (this.isSourceEditing() && this.edge.getSource() != null) {
                        this.paintPort(graphics, this.edge.getSource());
                    } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                        this.paintPort(graphics, this.edge.getTarget());
                    }
                }
            }
            if (!this.graph.isXorEnabled()) {
                if (this.isSourceEditing()) {
                    this.highlight(this.graph, this.edge.getSource());
                } else if (this.isTargetEditing()) {
                    this.highlight(this.graph, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics graphics, CellView cellView) {
            boolean bl = GraphConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle2D rectangle2D = bl ? cellView.getBounds() : cellView.getParentView().getBounds();
            rectangle2D = this.graph.toScreen((Rectangle2D)rectangle2D.clone());
            int n = 3;
            rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
            this.graph.getUI().paintCell(graphics, cellView, rectangle2D, true);
        }

        protected boolean snap(boolean bl, Point2D point2D) {
            boolean bl2 = this.graph.isConnectable() && this.isEdgeConnectable;
            Object object = this.graph.getPortForLocation(point2D.getX(), point2D.getY());
            if (object != null && this.graph.getModel().getParent(object) == this.edge.getCell()) {
                object = null;
            }
            if (object != null && bl2) {
                CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
                Rectangle2D rectangle2D = this.edge.getBounds();
                rectangle2D.add(cellView.getParentView().getBounds());
                if (GraphConstants.isConnectable(cellView.getParentView().getAllAttributes())) {
                    Object object2 = this.edge.getCell();
                    if (bl && this.graph.getModel().acceptsSource(object2, object)) {
                        if (this.edge.getSource() != cellView) {
                            this.edgeModified = true;
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            }
                            this.edge.setSource(cellView);
                            this.edge.update(this.graph.getGraphLayoutCache());
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            } else {
                                rectangle2D.add(this.edge.getBounds());
                                this.graph.repaint((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                            }
                        }
                        return true;
                    }
                    if (!bl && this.graph.getModel().acceptsTarget(object2, object)) {
                        if (this.edge.getTarget() != cellView) {
                            this.edgeModified = true;
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            }
                            this.edge.setTarget(cellView);
                            this.edge.update(this.graph.getGraphLayoutCache());
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            } else {
                                rectangle2D.add(this.edge.getBounds());
                                this.graph.repaint((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                            }
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
            GraphUI graphUI = this.graph.getUI();
            if (graphUI instanceof BasicGraphUI) {
                return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent mouseEvent) {
            return mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent);
        }

        public boolean isRemovePointEvent(MouseEvent mouseEvent) {
            return mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent);
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.currentLabel >= 0 || this.currentPoint != null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n;
            for (n = 0; n < this.r.length; ++n) {
                if (!this.r[n].contains(mouseEvent.getPoint())) continue;
                this.graph.setCursor(new Cursor(1));
                mouseEvent.consume();
                return;
            }
            if (this.loc.contains(mouseEvent.getPoint()) && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                this.graph.setCursor(new Cursor(12));
                mouseEvent.consume();
            }
            if (this.extraLabelLocations != null && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                for (n = 0; n < this.extraLabelLocations.length; ++n) {
                    if (!this.extraLabelLocations[n].contains(mouseEvent.getPoint())) continue;
                    this.graph.setCursor(new Cursor(12));
                    mouseEvent.consume();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle2D rectangle2D;
            int n;
            if (!this.edge.isLeaf()) {
                return;
            }
            boolean bl = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAllAttributes());
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = 0;
            for (n4 = 0; n4 < this.r.length; ++n4) {
                if (!this.r[n4].contains(n2, n3)) continue;
                this.currentPoint = this.edge.getPoint(n4);
                this.currentIndex = n4;
                this.source = n4 == 0;
                this.target = n4 == this.r.length - 1;
                break;
            }
            if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(n2, n3) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent) && this.graph.getEdgeLabelsMovable()) {
                this.initialLabelLocation = (Point2D)this.edge.getLabelPosition().clone();
                this.label = true;
            } else if (this.extraLabelLocations != null && !this.isEditing() && this.graph.isMoveable() && this.graph.getEdgeLabelsMovable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                for (n = 0; n < this.extraLabelLocations.length; ++n) {
                    if (this.extraLabelLocations[n] == null || !this.extraLabelLocations[n].contains(n2, n3)) continue;
                    this.currentLabel = n;
                    this.initialLabelLocation = (Point2D)this.edge.getExtraLabelPosition(this.currentLabel).clone();
                    if (!this.isRemovePointEvent(mouseEvent)) break;
                    this.edge.removeExtraLabel(n);
                    this.edgeModified = true;
                    this.mouseReleased(mouseEvent);
                    break;
                }
            }
            if (!(!this.isRemovePointEvent(mouseEvent) || this.currentPoint == null || this.source || this.target || !bl || this.edge.getSource() != null && this.currentIndex <= 0 || this.edge.getTarget() != null && this.currentIndex >= this.edge.getPointCount() - 1)) {
                this.edge.removePoint(n4);
                this.edgeModified = true;
                this.mouseReleased(mouseEvent);
            } else if (this.isAddPointEvent(mouseEvent) && !this.isEditing() && bl && this.edge.intersects(this.graph, rectangle2D = this.graph.fromScreen(new Rectangle(n2 - (n = this.graph.getHandleSize()), n3 - n, 2 * n, 2 * n)))) {
                Point2D point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                double d = Double.MAX_VALUE;
                double d2 = 0.0;
                for (int i = 0; i < this.edge.getPointCount() - 1; ++i) {
                    Point2D point2D2;
                    Point2D point2D3 = this.edge.getPoint(i);
                    d2 = new Line2D.Double(point2D3, point2D2 = this.edge.getPoint(i + 1)).ptSegDistSq(point2D);
                    if (!(d2 < d)) continue;
                    d = d2;
                    n4 = i + 1;
                }
                this.edge.addPoint(n4, point2D);
                this.edgeModified = true;
                this.currentPoint = point2D;
                this.reloadPoints(this.edge);
                this.paint(this.graph.getGraphics());
            }
            if (this.isEditing()) {
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle2D rectangle2D = this.edge.getBounds();
            Point2D point2D = this.graph.fromScreen(new Point(mouseEvent.getPoint()));
            if (this.label || this.currentLabel >= 0) {
                Rectangle2D rectangle2D2 = this.edge.getBounds();
                if (rectangle2D2 != null) {
                    this.edgeModified = true;
                    if (this.graph.isXorEnabled()) {
                        this.overlay(this.graph.getGraphics());
                    }
                    if (!GraphConstants.isLabelAlongEdge(this.edge.getAllAttributes())) {
                        point2D = this.getRelativeLabelPosition(this.edge, point2D);
                    } else {
                        double d = point2D.getX();
                        double d2 = point2D.getY();
                        Point2D point2D2 = this.edge.getPoint(0);
                        double d3 = point2D2.getX();
                        double d4 = point2D2.getY();
                        Point2D point2D3 = this.edge.getLabelVector();
                        double d5 = point2D3.getX();
                        double d6 = point2D3.getY();
                        double d7 = point2D2.getX() + d5;
                        double d8 = point2D2.getY() + d6;
                        double d9 = Math.sqrt(d5 * d5 + d6 * d6);
                        if (d9 > 0.0) {
                            double d10 = 1000.0;
                            double d11 = d9 * (-d2 * d5 + d4 * d5 + d * d6 - d3 * d6) / (-d8 * d6 + d4 * d6 - d5 * d7 + d5 * d3);
                            double d12 = d10 * (-d2 * d8 + d2 * d4 + d4 * d8 - d4 * d4 - d7 * d + d7 * d3 + d3 * d - d3 * d3) / (-d8 * d6 + d4 * d6 - d5 * d7 + d5 * d3);
                            point2D = new Point2D.Double(d12, d11);
                        } else {
                            point2D = new Point2D.Double(d - point2D2.getX(), d2 - point2D2.getY());
                        }
                    }
                    if (this.label) {
                        this.edge.setLabelPosition(point2D);
                    } else {
                        this.edge.setExtraLabelPosition(this.currentLabel, point2D);
                    }
                    this.edge.update(this.graph.getGraphLayoutCache());
                    if (this.graph.isXorEnabled()) {
                        this.overlay(this.graph.getGraphics());
                    } else {
                        this.graph.repaint((int)rectangle2D.getX() - 1, (int)rectangle2D.getY() - 1, (int)rectangle2D.getWidth() + 2, (int)rectangle2D.getHeight() + 2);
                    }
                }
            } else if (this.isEditing() && this.currentPoint != null) {
                boolean bl;
                boolean bl2 = bl = !this.source && !this.target || this.graph.isDisconnectable() && GraphConstants.isDisconnectable(this.orig.getAllAttributes());
                if (this.source) {
                    boolean bl3 = bl = bl && (this.orig.getSource() == null && this.orig.getSourceParentView() == null || this.orig.getSource() != null && GraphConstants.isDisconnectable(this.orig.getSource().getParentView().getAllAttributes()) || this.orig.getSourceParentView() != null && GraphConstants.isDisconnectable(this.orig.getSourceParentView().getAllAttributes()));
                }
                if (this.target) {
                    boolean bl4 = bl = bl && (this.orig.getTarget() == null && this.orig.getTargetParentView() == null || this.orig.getTarget() != null && GraphConstants.isDisconnectable(this.orig.getTarget().getParentView().getAllAttributes()) || this.orig.getTargetParentView() != null && GraphConstants.isDisconnectable(this.orig.getTargetParentView().getAllAttributes()));
                }
                if (!(this.source && this.snap(true, mouseEvent.getPoint()) || this.target && this.snap(false, mouseEvent.getPoint()) || !bl)) {
                    boolean bl5;
                    boolean bl6 = this.source && (this.graph.getModel().acceptsSource(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                    boolean bl7 = bl5 = this.target && (this.graph.getModel().acceptsTarget(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                    if (bl6 || bl5 || !this.source && !this.target) {
                        this.edgeModified = true;
                        if (this.edge.getSource() != null) {
                            rectangle2D.add(this.edge.getSource().getParentView().getBounds());
                        }
                        if (this.edge.getTarget() != null) {
                            rectangle2D.add(this.edge.getTarget().getParentView().getBounds());
                        }
                        if (this.graph.isXorEnabled()) {
                            this.overlay(this.graph.getGraphics());
                        }
                        point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                        if (this.isConstrainedMoveEvent(mouseEvent) && this.currentIndex >= 0) {
                            EdgeView edgeView = (EdgeView)this.graph.getGraphLayoutCache().getMapping(this.edge.getCell(), false);
                            Point2D point2D4 = edgeView.getPoint(this.currentIndex);
                            double d = point2D.getX() - point2D4.getX();
                            double d13 = point2D.getY() - point2D4.getY();
                            if (Math.abs(d) < Math.abs(d13)) {
                                point2D.setLocation(point2D4.getX(), point2D.getY());
                            } else {
                                point2D.setLocation(point2D.getX(), point2D4.getY());
                            }
                        }
                        point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
                        this.currentPoint.setLocation(point2D);
                        if (this.source) {
                            this.edge.setPoint(0, point2D);
                            this.edge.setSource(null);
                        } else if (this.target) {
                            this.edge.setPoint(this.edge.getPointCount() - 1, point2D);
                            this.edge.setTarget(null);
                        }
                        this.edge.update(this.graph.getGraphLayoutCache());
                        rectangle2D.add(this.edge.getBounds());
                        if (this.graph.isXorEnabled()) {
                            this.overlay(this.graph.getGraphics());
                        } else {
                            if (this.edge.getSource() != null) {
                                rectangle2D.add(this.edge.getSource().getParentView().getBounds());
                            }
                            if (this.edge.getTarget() != null) {
                                rectangle2D.add(this.edge.getTarget().getParentView().getBounds());
                            }
                            rectangle2D = this.graph.toScreen((Rectangle2D)rectangle2D.clone());
                            this.graph.repaint((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                        }
                    }
                } else if (!this.graph.isXorEnabled()) {
                    rectangle2D.add(this.edge.getBounds());
                    rectangle2D = this.graph.toScreen((Rectangle2D)rectangle2D.clone());
                    this.graph.repaint((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                }
            }
        }

        protected Point2D getRelativeLabelPosition(EdgeView edgeView, Point2D point2D) {
            Point2D.Double double_;
            Point2D point2D2;
            double d;
            Cloneable cloneable;
            int n = edgeView.getPointCount();
            double d2 = 0.0;
            double[] dArray = new double[n];
            Point2D point2D3 = edgeView.getPoint(0);
            Cloneable cloneable2 = point2D3;
            for (int i = 1; i < n; ++i) {
                double d3;
                cloneable = edgeView.getPoint(i);
                if (cloneable == null) continue;
                d = ((Point2D)cloneable2).getX() - ((Point2D)cloneable).getX();
                double d4 = ((Point2D)cloneable2).getY() - ((Point2D)cloneable).getY();
                dArray[i - 1] = d3 = Math.sqrt(d * d + d4 * d4);
                d2 += d3;
                cloneable2 = cloneable;
            }
            Point2D point2D4 = edgeView.getPoint(1);
            cloneable = new Line2D.Double(point2D3, point2D4);
            d = ((Line2D)cloneable).ptSegDistSq(point2D);
            int n2 = 0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 2; i < n; ++i) {
                d5 += dArray[i - 2];
                cloneable = new Line2D.Double(edgeView.getPoint(i), point2D4);
                double d7 = ((Line2D)cloneable).ptSegDistSq(point2D);
                if (d7 < d) {
                    d = d7;
                    n2 = i - 1;
                    d6 = d5;
                }
                point2D4 = edgeView.getPoint(i);
            }
            double d8 = dArray[n2];
            cloneable2 = edgeView.getPoint(n2);
            double d9 = ((Point2D)cloneable2).getX();
            double d10 = ((Point2D)cloneable2).getY();
            Point2D point2D5 = edgeView.getPoint(n2 + 1);
            double d11 = point2D5.getX();
            double d12 = point2D5.getY();
            double d13 = point2D.getX();
            double d14 = point2D.getY();
            double d15 = d9 - d11;
            double d16 = d10 - d12;
            d13 -= d11;
            d14 -= d12;
            double d17 = 0.0;
            double d18 = (d13 = d15 - d13) * d15 + (d14 = d16 - d14) * d16;
            d17 = d18 <= 0.0 ? 0.0 : d18 * d18 / (d15 * d15 + d16 * d16);
            double d19 = Math.sqrt(d17);
            if (d19 > d8) {
                d19 = d8;
            }
            double d20 = Line2D.ptLineDist(point2D5.getX(), point2D5.getY(), ((Point2D)cloneable2).getX(), ((Point2D)cloneable2).getY(), point2D.getX(), point2D.getY());
            int n3 = Line2D.relativeCCW(point2D5.getX(), point2D5.getY(), ((Point2D)cloneable2).getX(), ((Point2D)cloneable2).getY(), point2D.getX(), point2D.getY());
            if (n3 == -1) {
                d20 = -d20;
            }
            if (point2D.equals(point2D2 = edgeView.convertRelativeLabelPositionToAbsolute(double_ = new Point2D.Double(((d2 / 2.0 - d6 - d19) / d2 * -2.0 + 1.0) * 1000.0 / 2.0, d20)))) {
                GraphConstants.setRemoveAttributes(edgeView.getAllAttributes(), new Object[]{"offset"});
                edgeView.getAllAttributes().remove("offset");
            } else {
                Point2D.Double double_2 = new Point2D.Double(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
                GraphConstants.setOffset(edgeView.getAllAttributes(), double_2);
            }
            return double_;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            this.highlight(this.graph, null);
            boolean bl = mouseEvent.isControlDown() && this.graph.isCloneable();
            GraphModel graphModel = this.graph.getModel();
            Object object2 = this.edge.getSource() != null ? this.edge.getSource().getCell() : null;
            Object object3 = object = this.edge.getTarget() != null ? this.edge.getTarget().getCell() : null;
            if (this.edgeModified && graphModel.acceptsSource(this.edge.getCell(), object2) && graphModel.acceptsTarget(this.edge.getCell(), object)) {
                List list;
                Object object4;
                Object object5;
                Object object6;
                if (bl && this.initialLabelLocation != null) {
                    object6 = null;
                    object5 = null;
                    object4 = GraphConstants.getExtraLabels(this.edge.getAllAttributes());
                    if (this.label) {
                        object5 = (Point2D)this.edge.getLabelPosition().clone();
                        object6 = this.graph.convertValueToString(this.orig);
                        this.edge.setLabelPosition(this.initialLabelLocation);
                    } else {
                        object5 = (Point2D)this.edge.getExtraLabelPosition(this.currentLabel).clone();
                        object6 = object4[this.currentLabel];
                        this.edge.setExtraLabelPosition(this.currentLabel, this.initialLabelLocation);
                    }
                    this.edge.addExtraLabel((Point2D)object5, object6);
                    this.edge.update(this.graph.getGraphLayoutCache());
                    bl = false;
                }
                object6 = this.createConnectionSet(this.edge, bl);
                object5 = GraphConstants.createAttributes(new CellView[]{this.edge}, null);
                object4 = (Map)object5.get(this.edge.getCell());
                List list2 = GraphConstants.getPoints((Map)object4);
                if (list2 != (list = this.edge.getPoints())) {
                    list2.set(0, this.edge.getPoint(0));
                    list2.set(list2.size() - 1, this.edge.getPoint(this.edge.getPointCount() - 1));
                }
                if (bl) {
                    Map map = this.graph.cloneCells(this.graph.getDescendants(new Object[]{this.edge.getCell()}));
                    this.processNestedMap((Map)object5, true);
                    object5 = GraphConstants.replaceKeys(map, (Map)object5);
                    object6 = ((ConnectionSet)object6).clone(map);
                    Object[] objectArray = map.values().toArray();
                    this.graph.getGraphLayoutCache().insert(objectArray, (Map)object5, (ConnectionSet)object6, null, null);
                } else {
                    this.processNestedMap((Map)object5, false);
                    this.graph.getGraphLayoutCache().edit((Map)object5, (ConnectionSet)object6, null, null);
                }
            } else {
                if (this.graph.isXorEnabled()) {
                    this.overlay(this.graph.getGraphics());
                } else {
                    Rectangle2D rectangle2D = this.edge.getBounds();
                    this.graph.repaint((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                }
                this.edge.refresh(this.graph.getGraphLayoutCache(), this.graph.getGraphLayoutCache(), false);
            }
            this.initialLabelLocation = null;
            this.currentPoint = null;
            this.edgeModified = false;
            this.label = false;
            this.source = false;
            this.target = false;
            this.currentLabel = -1;
            this.currentIndex = -1;
            this.firstOverlayCall = true;
            mouseEvent.consume();
        }

        protected void processNestedMap(Map map, boolean bl) {
        }

        protected ConnectionSet createConnectionSet(EdgeView edgeView, boolean bl) {
            Object object = edgeView.getCell();
            GraphModel graphModel = this.graph.getModel();
            ConnectionSet connectionSet = new ConnectionSet();
            Object object2 = null;
            Object object3 = null;
            if (edgeView.getSource() != null) {
                object2 = edgeView.getSource().getCell();
            } else if (edgeView.getSourceParentView() != null) {
                object2 = graphModel.getSource(object);
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            } else if (edgeView.getTargetParentView() != null) {
                object3 = graphModel.getTarget(object);
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            }
            if (bl || object2 != graphModel.getSource(object) && this.source) {
                connectionSet.connect(object, object2, true);
            }
            if (bl || object3 != graphModel.getTarget(object) && this.target) {
                connectionSet.connect(object, object3, false);
            }
            return connectionSet;
        }

        protected void invalidate() {
            int n;
            EdgeView edgeView = this.relevantEdge;
            int n2 = this.graph.getHandleSize();
            EdgeRenderer edgeRenderer = (EdgeRenderer)this.edge.getRenderer();
            Point2D point2D = edgeRenderer.getLabelPosition(edgeView);
            Point2D point2D2 = null;
            if (point2D != null) {
                point2D2 = (Point2D)point2D.clone();
                this.graph.toScreen(point2D2);
            }
            Dimension dimension = edgeRenderer.getLabelSize(edgeView, this.graph.convertValueToString(edgeView));
            if (point2D2 != null && dimension != null) {
                Point2D point2D3 = this.graph.toScreen(new Point2D.Double(dimension.width, dimension.height));
                this.loc.setFrame(point2D2.getX() - point2D3.getX() / 2.0, point2D2.getY() - point2D3.getY() / 2.0, point2D3.getX(), point2D3.getY());
            }
            for (n = 0; n < this.r.length; ++n) {
                point2D2 = edgeView.getPoint(n);
                point2D2 = this.graph.toScreen(new Point2D.Double(point2D2.getX(), point2D2.getY()));
                this.r[n].setFrame(point2D2.getX() - (double)n2, point2D2.getY() - (double)n2, 2 * n2, 2 * n2);
            }
            if (this.extraLabelLocations != null) {
                for (n = 0; n < this.extraLabelLocations.length; ++n) {
                    point2D2 = edgeRenderer.getExtraLabelPosition(edgeView, n);
                    if (point2D2 == null) continue;
                    point2D2 = this.graph.toScreen((Point2D)point2D2.clone());
                    dimension = edgeRenderer.getExtraLabelSize(this.graph, edgeView, n);
                    if (dimension == null) continue;
                    Point2D point2D4 = this.graph.toScreen(new Point2D.Double(dimension.width, dimension.height));
                    this.extraLabelLocations[n].setFrame(point2D2.getX() - point2D4.getX() / 2.0, point2D2.getY() - point2D4.getY() / 2.0, point2D4.getX(), point2D4.getY());
                }
            }
        }
    }
}

