/*
 * Decompiled with CFR 0.152.
 */
package control;

import abstraction.AvailableServices;
import abstraction.State;
import control.CState;
import java.util.Iterator;

public class IteratorFinalCommunityStates
implements Iterator<CState> {
    private State[] presentConfiguration;
    private Iterator<State>[] next;
    private AvailableServices services;
    private boolean hasNext = true;

    public IteratorFinalCommunityStates(AvailableServices services) {
        this.services = services;
        int dim = services.sizeCommunity();
        this.presentConfiguration = new State[dim];
        this.next = new Iterator[dim];
        int i = 0;
        while (i < dim) {
            State s;
            Iterator<State> it = services.get(i).getFinalStates();
            this.presentConfiguration[i] = s = it.next();
            this.next[i] = it;
            ++i;
        }
    }

    @Override
    public CState next() {
        CState result = new CState(this.presentConfiguration);
        int i = 0;
        while (i < this.services.sizeCommunity()) {
            State s1;
            Iterator<State> it = this.next[i];
            if (it.hasNext()) {
                State s;
                this.presentConfiguration[i] = s = it.next();
                this.next[i] = it;
                return result;
            }
            Iterator<State> it2 = this.services.get(i).getFinalStates();
            this.presentConfiguration[i] = s1 = it2.next();
            this.next[i] = it2;
            ++i;
        }
        this.hasNext = false;
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

