/*
 * Decompiled with CFR 0.152.
 */
package control;

import abstraction.AvailableServices;
import abstraction.Service;
import abstraction.State;
import control.CState;
import control.IteratorCommunityStates;
import control.IteratorFinalCommunityStates;
import java.util.Iterator;

public class Community {
    private AvailableServices availableService;

    public Community(AvailableServices as) {
        this.availableService = as;
    }

    public Service getService(int index) {
        return this.availableService.get(index);
    }

    public Iterator<CState> getCommunityStates() {
        return new IteratorCommunityStates(this.availableService);
    }

    public Iterator<CState> getFinalCommunityStates() {
        return new IteratorFinalCommunityStates(this.availableService);
    }

    public CState getInitialStates() {
        State[] initial = new State[this.availableService.sizeCommunity()];
        int i = 0;
        while (i < this.availableService.sizeCommunity()) {
            State s;
            initial[i] = s = this.availableService.get(i).getInitialState();
            ++i;
        }
        return new CState(initial);
    }

    public int getServicePosition(Service service) {
        return this.availableService.getPosition(service);
    }

    public boolean isFinalCommunityState(CState cs) {
        int i = 0;
        while (i < cs.getSize()) {
            if (!this.availableService.get(i).isFinalState(cs.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int size() {
        return this.availableService.sizeCommunity();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Iterator<CState> it = this.getCommunityStates();
        while (it.hasNext()) {
            CState c = it.next();
            s = s.append("(" + c + ")");
        }
        return s.toString();
    }
}

