/*
 * Decompiled with CFR 0.152.
 */
package abstraction;

import abstraction.Action;
import abstraction.OnlyReadIterator;
import abstraction.State;
import abstraction.StateAction;
import abstraction.TransitionFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Service {
    private HashMap<State, HashSet<Action>> listAction = new HashMap();
    private HashMap<StateAction, HashSet<State>> nextStates = new HashMap();
    private Set<State> finalStates;
    private Set<TransitionFunction> transitions;
    private String filename;
    private State initialState;
    private boolean isDeterministic;

    public Service(String readingFile) {
        HashMap<String, State> stateAux = new HashMap<String, State>();
        HashMap<String, StateAction> stateActionAux = new HashMap<String, StateAction>();
        HashMap<String, Action> actionAux = new HashMap<String, Action>();
        this.finalStates = new HashSet<State>();
        this.transitions = new HashSet<TransitionFunction>();
        this.isDeterministic = true;
        this.filename = readingFile.substring(0, readingFile.indexOf("?"));
        readingFile = readingFile.substring(readingFile.indexOf("?") + 1);
        if (!readingFile.equals("")) {
            String states = readingFile.substring(readingFile.indexOf(":") + 1, readingFile.indexOf("initial:"));
            String initialState = readingFile.substring(readingFile.indexOf("initial:") + 8, readingFile.indexOf("final:"));
            String finalState = readingFile.substring(readingFile.indexOf("final:") + 6);
            while (states.length() != 0) {
                State stateNext;
                StateAction stateAction;
                String presentStateName = states.substring(0, states.indexOf("-"));
                states = states.substring(states.indexOf("-") + 1);
                String actionName = states.substring(0, states.indexOf("-"));
                String nextStateName = states.substring(states.indexOf("-") + 1, states.indexOf(";"));
                TransitionFunction tf = new TransitionFunction(new State(presentStateName), new Action(actionName), new State(nextStateName));
                states = states.substring(states.indexOf(";") + 1);
                this.transitions.add(tf);
                if (!stateAux.containsKey(presentStateName)) {
                    Action action;
                    State stateNext2;
                    State statePresent = new State(presentStateName);
                    if (!stateAux.containsKey(nextStateName)) {
                        stateNext2 = new State(nextStateName);
                        stateAux.put(nextStateName, stateNext2);
                        this.listAction.put(stateNext2, new HashSet());
                    } else {
                        stateNext2 = (State)stateAux.get(nextStateName);
                    }
                    if (!actionAux.containsKey(actionName)) {
                        action = new Action(actionName);
                        actionAux.put(actionName, action);
                    } else {
                        action = (Action)actionAux.get(actionName);
                    }
                    stateAction = new StateAction(statePresent, action);
                    HashSet<Action> actions = new HashSet<Action>();
                    HashSet<State> nextStates = new HashSet<State>();
                    stateAux.put(presentStateName, statePresent);
                    actions.add(action);
                    nextStates.add(stateNext2);
                    stateActionAux.put(String.valueOf(presentStateName) + actionName, stateAction);
                    this.listAction.put(statePresent, actions);
                    this.nextStates.put(stateAction, nextStates);
                    if (finalState.contains(String.valueOf(presentStateName) + ";") || finalState.contains(String.valueOf(presentStateName) + ".")) {
                        this.finalStates.add(statePresent);
                    }
                    if (finalState.contains(String.valueOf(nextStateName) + ";") || finalState.contains(String.valueOf(nextStateName) + ".")) {
                        this.finalStates.add(stateNext2);
                    }
                    if (initialState.contains(presentStateName) && !initialState.equals(null)) {
                        this.initialState = statePresent;
                    }
                    if (!initialState.contains(nextStateName) || initialState.equals(null)) continue;
                    this.initialState = stateNext2;
                    continue;
                }
                if (!stateAux.containsKey(nextStateName)) {
                    stateNext = new State(nextStateName);
                    stateAux.put(nextStateName, stateNext);
                    this.listAction.put(stateNext, new HashSet());
                    if (finalState.contains(String.valueOf(nextStateName) + ";") || finalState.contains(String.valueOf(nextStateName) + ".")) {
                        this.finalStates.add(stateNext);
                    }
                } else {
                    stateNext = (State)stateAux.get(nextStateName);
                }
                if (initialState.contains(nextStateName) && !initialState.equals(null)) {
                    this.initialState = stateNext;
                }
                if (!stateActionAux.containsKey(String.valueOf(presentStateName) + actionName)) {
                    Action action;
                    State state = (State)stateAux.get(presentStateName);
                    if (!actionAux.containsKey(actionName)) {
                        action = new Action(actionName);
                        actionAux.put(actionName, action);
                    } else {
                        action = (Action)actionAux.get(actionName);
                    }
                    stateAction = new StateAction(state, action);
                    HashSet<State> nextStates = new HashSet<State>();
                    stateActionAux.put(String.valueOf(presentStateName) + actionName, stateAction);
                    HashSet<Action> actions = this.listAction.get(state);
                    actions.add(action);
                    nextStates.add(stateNext);
                    this.nextStates.put(stateAction, nextStates);
                    continue;
                }
                StateAction sa = (StateAction)stateActionAux.get(String.valueOf(presentStateName) + actionName);
                HashSet<State> nextStates = this.nextStates.get(sa);
                if (!nextStates.contains(stateNext)) {
                    nextStates.add(stateNext);
                }
                this.isDeterministic = false;
            }
            stateAux.clear();
            stateActionAux.clear();
            actionAux.clear();
        }
    }

    protected Set<TransitionFunction> getTransitionFunctionsSet() {
        return Collections.unmodifiableSet(this.transitions);
    }

    public Iterator<TransitionFunction> getTransitionFunctions() {
        return new OnlyReadIterator<TransitionFunction>(this.transitions.iterator());
    }

    public Iterator<State> getFinalStates() {
        return new OnlyReadIterator<State>(this.finalStates.iterator());
    }

    protected Set<State> getFinalStatesSet() {
        return Collections.unmodifiableSet(this.finalStates);
    }

    public Iterator<State> getStates() {
        return new OnlyReadIterator<State>(this.listAction.keySet().iterator());
    }

    public boolean isFinalState(State state) {
        return this.finalStates.contains(state);
    }

    public Iterator<State> getNextStates(State presentState, Action action) {
        return new OnlyReadIterator<State>(this.nextStates.get(new StateAction(presentState, action)).iterator());
    }

    public boolean containsPresentAction(State presentState, Action action) {
        return this.nextStates.containsKey(new StateAction(presentState, action));
    }

    public Iterator<Action> getActions(State state) {
        return new OnlyReadIterator<Action>(this.listAction.get(state).iterator());
    }

    public State getInitialState() {
        return this.initialState;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public String getName() {
        return this.filename;
    }

    protected void setName(String name) {
        this.filename = name;
    }

    public String toString() {
        return this.filename;
    }
}

