/*
 * Decompiled with CFR 0.152.
 */
package abstraction;

import abstraction.AvailableServices;
import abstraction.Service;
import abstraction.State;
import abstraction.TransitionFunction;
import java.util.Iterator;
import java.util.Set;

public class CartesianProduct {
    long estimateTime;

    public static Service executeProduct(AvailableServices comm) {
        AvailableServices community = (AvailableServices)comm.clone();
        String cartesianProductString = new String("");
        Iterator<Service> it = community.getIterator();
        if (community.sizeCommunity() == 0) {
            return null;
        }
        if (community.sizeCommunity() > 2) {
            Service service1 = it.next();
            Service service2 = it.next();
            cartesianProductString = CartesianProduct.productService(service1, service2);
            Service service = new Service(cartesianProductString);
            community.deleteService(community.getPosition(service1));
            community.deleteService(community.getPosition(service2));
            it = community.getIterator();
            while (it.hasNext()) {
                Service service3 = it.next();
                cartesianProductString = CartesianProduct.productService(service, service3);
                service = new Service(cartesianProductString);
                community.deleteService(community.getPosition(service3));
                it = community.getIterator();
            }
        } else if (community.sizeCommunity() == 2) {
            cartesianProductString = CartesianProduct.productService(it.next(), it.next());
        } else {
            Service serv = it.next();
            serv.setName("community");
            return serv;
        }
        return new Service(cartesianProductString);
    }

    private static String productService(Service s1, Service s2) {
        String finalState = CartesianProduct.productFinalStates(s1.getFinalStatesSet(), s2.getFinalStatesSet());
        finalState = "final:" + finalState.substring(0, finalState.lastIndexOf(";")) + ".";
        String transaction = CartesianProduct.productTransition(s1.getTransitionFunctionsSet(), s1.getName(), s2.getTransitionFunctionsSet(), s2.getName());
        transaction = "transaction:" + transaction;
        String initial = "initial:" + s1.getInitialState().getName() + s2.getInitialState().getName() + ";";
        String serviceContent = "community?+" + transaction + initial + finalState;
        return serviceContent;
    }

    private static String productTransition(Set<TransitionFunction> l1, String l1Name, Set<TransitionFunction> l2, String l2Name) {
        String transaction = "";
        for (TransitionFunction state1 : l1) {
            for (TransitionFunction state2 : l2) {
                String firstServiceAction = state1.getAction().getName().contains(",") ? state1.getAction().getName() : String.valueOf(state1.getAction().getName()) + "," + l1Name;
                String secondServiceAction = String.valueOf(state2.getAction().getName()) + "," + l2Name;
                transaction = String.valueOf(transaction) + state1.getPresentState() + state2.getPresentState() + "-" + firstServiceAction + "-" + state1.getNextState() + state2.getPresentState() + ";";
                transaction = String.valueOf(transaction) + state1.getPresentState() + state2.getNextState() + "-" + firstServiceAction + "-" + state1.getNextState() + state2.getNextState() + ";";
                transaction = String.valueOf(transaction) + state1.getPresentState() + state2.getPresentState() + "-" + secondServiceAction + "-" + state1.getPresentState() + state2.getNextState() + ";";
                transaction = String.valueOf(transaction) + state1.getNextState() + state2.getPresentState() + "-" + secondServiceAction + "-" + state1.getNextState() + state2.getNextState() + ";";
            }
        }
        return transaction;
    }

    private static String productFinalStates(Set<State> l1, Set<State> l2) {
        String prod = new String("");
        Iterator<State> it = l1.iterator();
        int i = 0;
        int j = 0;
        while (it.hasNext()) {
            ++i;
            State final1 = it.next();
            Iterator<State> it2 = l2.iterator();
            while (it2.hasNext()) {
                ++j;
                prod = String.valueOf(prod) + final1 + it2.next() + ";";
            }
        }
        return prod;
    }
}

