/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.jbi;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.model.Operation;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.QNameUtil;
import org.w3c.dom.DocumentFragment;

public class JbiInInterceptor
extends AbstractInterceptor {
    public static final String OPERATION_MEP = "MEP";
    private final boolean server;

    public JbiInInterceptor(boolean server) {
        this.server = server;
    }

    public void handleMessage(Message message) {
        try {
            NormalizedMessage nm;
            Operation operation = message.get(Operation.class);
            if (this.server) {
                MessageExchange exchange = this.createExchange(message);
                if (operation != null) {
                    exchange.setOperation(operation.getName());
                }
                nm = exchange.createMessage();
                exchange.setMessage(nm, "in");
                message.setContent(MessageExchange.class, exchange);
            } else {
                MessageExchange exchange = message.getContent(MessageExchange.class);
                if (exchange == null) {
                    throw new IllegalStateException("Content of type " + MessageExchange.class + " not found on message");
                }
                if (message.getContent(Exception.class) == null) {
                    nm = exchange.getMessage("out");
                    if (nm == null) {
                        nm = exchange.createMessage();
                        exchange.setMessage(nm, "out");
                    }
                } else {
                    exchange.setFault(exchange.createFault());
                    nm = exchange.getFault();
                }
            }
            this.toNMSHeaders(nm, message);
            this.toNMSAttachments(nm, message);
            nm.setSecuritySubject(message.get(Subject.class));
            this.getContent(nm, message);
            message.setContent(NormalizedMessage.class, nm);
        }
        catch (JBIException e) {
            throw new Fault(e);
        }
    }

    private MessageExchange createExchange(Message message) throws JBIException {
        Operation operation = message.get(Operation.class);
        URI mep = operation != null ? operation.getMep() : (URI)message.get(OPERATION_MEP);
        if (mep == null) {
            throw new NullPointerException("MEP not found");
        }
        MessageExchangeFactory mef = message.get(MessageExchangeFactory.class);
        if (mef == null) {
            DeliveryChannel dv = message.get(DeliveryChannel.class);
            if (dv == null) {
                ComponentContext cc = message.get(ComponentContext.class);
                if (cc == null) {
                    throw new NullPointerException("MessageExchangeFactory or DeliveryChannel or ComponentContext not found");
                }
                dv = cc.getDeliveryChannel();
            }
            mef = dv.createExchangeFactory();
        }
        return mef.createExchange(mep);
    }

    private void toNMSHeaders(NormalizedMessage normalizedMessage, Message soapMessage) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (Map.Entry<QName, DocumentFragment> entry : soapMessage.getSoapHeaders().entrySet()) {
            headers.put(QNameUtil.toString(entry.getKey()), entry.getValue());
        }
        headers.putAll(soapMessage.getTransportHeaders());
        normalizedMessage.setProperty("javax.jbi.messaging.protocol.headers", headers);
    }

    private void toNMSAttachments(NormalizedMessage normalizedMessage, Message soapMessage) throws MessagingException {
        for (Map.Entry<String, DataHandler> entry : soapMessage.getAttachments().entrySet()) {
            normalizedMessage.addAttachment(entry.getKey(), entry.getValue());
        }
    }

    private void getContent(NormalizedMessage nm, Message message) throws MessagingException {
        Exception e = message.getContent(Exception.class);
        if (e == null) {
            nm.setContent(message.getContent(Source.class));
        } else if (e instanceof SoapFault) {
            SoapFault fault = (SoapFault)e;
            nm.setContent(fault.getDetails());
            nm.setProperty("org.apache.servicemix.soap.fault.code", (Object)fault.getCode());
            nm.setProperty("org.apache.servicemix.soap.fault.node", (Object)fault.getNode());
            nm.setProperty("org.apache.servicemix.soap.fault.reason", (Object)fault.getReason());
            nm.setProperty("org.apache.servicemix.soap.fault.role", (Object)fault.getRole());
            nm.setProperty("org.apache.servicemix.soap.fault.subcode", (Object)fault.getSubcode());
        }
    }
}

