/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecEncrypt;
import org.w3c.dom.Document;

public class EncryptionAction
implements Action {
    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        WSSecEncrypt wsEncrypt = new WSSecEncrypt();
        wsEncrypt.setWsConfig(reqData.getWssConfig());
        if (reqData.getEncKeyId() != 0) {
            wsEncrypt.setKeyIdentifierType(reqData.getEncKeyId());
        }
        if (reqData.getEncKeyId() == 5) {
            String encKeyName = handler.getString("EmbeddedKeyName", reqData.getMsgContext());
            wsEncrypt.setEmbeddedKeyName(encKeyName);
            byte[] embeddedKey = handler.getPassword(reqData.getEncUser(), actionToDo, "EmbeddedKeyCallbackClass", "EmbeddedKeyCallbackRef", reqData).getKey();
            wsEncrypt.setKey(embeddedKey);
            wsEncrypt.setDocument(doc);
        }
        if (reqData.getEncSymmAlgo() != null) {
            wsEncrypt.setSymmetricEncAlgorithm(reqData.getEncSymmAlgo());
        }
        if (reqData.getEncKeyTransport() != null) {
            wsEncrypt.setKeyEnc(reqData.getEncKeyTransport());
        }
        wsEncrypt.setUserInfo(reqData.getEncUser());
        wsEncrypt.setUseThisCert(reqData.getEncCert());
        if (reqData.getEncryptParts().size() > 0) {
            wsEncrypt.setParts(reqData.getEncryptParts());
        }
        try {
            wsEncrypt.build(doc, reqData.getEncCrypto(), reqData.getSecHeader());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Encryption: error during message processing" + e);
        }
    }
}

