/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.util.MessageUtil;

public class StaticRecipientList
extends EIPEndpoint {
    public static final String RECIPIENT_LIST_COUNT = "org.apache.servicemix.eip.recipientList.count";
    public static final String RECIPIENT_LIST_INDEX = "org.apache.servicemix.eip.recipientList.index";
    public static final String RECIPIENT_LIST_CORRID = "org.apache.servicemix.eip.recipientList.corrid";
    private ExchangeTarget[] recipients;
    private boolean reportErrors;

    public ExchangeTarget[] getRecipients() {
        return this.recipients;
    }

    public void setRecipients(ExchangeTarget[] recipients) {
        this.recipients = recipients;
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public void setReportErrors(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.recipients == null || this.recipients.length == 0) {
            throw new IllegalArgumentException("recipients should contain at least one ExchangeTarget");
        }
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
            return;
        }
        NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
        for (int i = 0; i < this.recipients.length; ++i) {
            MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
            this.recipients[i].configureTarget(me, this.getContext());
            in.setProperty(RECIPIENT_LIST_COUNT, (Object)new Integer(this.recipients.length));
            in.setProperty(RECIPIENT_LIST_INDEX, (Object)new Integer(i));
            in.setProperty(RECIPIENT_LIST_CORRID, (Object)exchange.getExchangeId());
            MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)me);
            this.sendSync(me);
            if (me.getStatus() != ExchangeStatus.ERROR || !this.reportErrors) continue;
            this.fail(exchange, me.getError());
            return;
        }
        this.done(exchange);
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        if (this.reportErrors) {
            throw new UnsupportedOperationException("Not implemented");
        }
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
        } else if (exchange.getFault() != null) {
            this.done(exchange);
        } else {
            NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
            for (int i = 0; i < this.recipients.length; ++i) {
                MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
                this.recipients[i].configureTarget(me, this.getContext());
                in.setProperty(RECIPIENT_LIST_COUNT, (Object)new Integer(this.recipients.length));
                in.setProperty(RECIPIENT_LIST_INDEX, (Object)new Integer(i));
                in.setProperty(RECIPIENT_LIST_CORRID, (Object)exchange.getExchangeId());
                MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)me);
                this.send(me);
            }
            this.done(exchange);
        }
    }
}

