/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bean.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.bean.Content;
import org.apache.servicemix.bean.Operation;
import org.apache.servicemix.bean.Property;
import org.apache.servicemix.bean.XPath;
import org.apache.servicemix.bean.support.MethodInfo;
import org.apache.servicemix.bean.support.MethodInvocationStrategy;
import org.apache.servicemix.client.DefaultNamespaceContext;
import org.apache.servicemix.components.util.MessageHelper;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.JAXPStringXPathExpression;
import org.apache.servicemix.expression.PropertyExpression;
import org.apache.servicemix.jbi.messaging.PojoMarshaler;

public class BeanInfo {
    private static final Log LOG = LogFactory.getLog(BeanInfo.class);
    private Class type;
    private MethodInvocationStrategy strategy;
    private Map<String, MethodInfo> operations = new ConcurrentHashMap<String, MethodInfo>();
    private MethodInfo defaultExpression;

    public BeanInfo(Class type, MethodInvocationStrategy strategy) {
        this.type = type;
        this.strategy = strategy;
    }

    public Class getType() {
        return this.type;
    }

    public void introspect() {
        this.introspect(this.getType());
        if (this.operations.size() == 1) {
            Collection<MethodInfo> methodInfos = this.operations.values();
            Iterator<MethodInfo> i$ = methodInfos.iterator();
            while (i$.hasNext()) {
                MethodInfo methodInfo;
                this.defaultExpression = methodInfo = i$.next();
            }
        }
    }

    public MethodInvocation createInvocation(Object pojo, MessageExchange messageExchange) throws MessagingException {
        QName operation = messageExchange.getOperation();
        MethodInfo methodInfo = null;
        methodInfo = operation == null ? this.defaultExpression : this.operations.get(operation.getLocalPart());
        if (methodInfo != null) {
            return methodInfo.createMethodInvocation(pojo, messageExchange);
        }
        return null;
    }

    protected void introspect(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            this.introspect(clazz, method);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.introspect(superclass);
        }
    }

    protected void introspect(Class clazz, Method method) {
        String name;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Expression[] parameterExpressions = new Expression[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Expression expression = this.createParameterUnmarshalExpression(clazz, method, parameterType, parameterAnnotations[i]);
            if (expression == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No expression available for method: " + method.toString() + " parameter: " + i + " so ignoring method"));
                }
                return;
            }
            parameterExpressions[i] = expression;
        }
        String opName = method.getName();
        if (method.getAnnotation(Operation.class) != null && (name = method.getAnnotation(Operation.class).name()) != null && name.length() > 0) {
            opName = name;
        }
        Expression parametersExpression = this.createMethodParametersExpression(parameterExpressions);
        this.operations.put(opName, new MethodInfo(clazz, method, parametersExpression));
    }

    protected Expression createMethodParametersExpression(final Expression[] parameterExpressions) {
        return new Expression(){

            public Object evaluate(MessageExchange messageExchange, NormalizedMessage normalizedMessage) throws MessagingException {
                Object[] answer = new Object[parameterExpressions.length];
                for (int i = 0; i < parameterExpressions.length; ++i) {
                    Expression parameterExpression = parameterExpressions[i];
                    answer[i] = parameterExpression.evaluate(messageExchange, normalizedMessage);
                }
                return answer;
            }
        };
    }

    protected Expression createParameterUnmarshalExpression(Class clazz, Method method, Class parameterType, Annotation[] parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            Expression answer = this.createParameterUnmarshalExpressionForAnnotation(clazz, method, parameterType, annotation);
            if (answer == null) continue;
            return answer;
        }
        return this.strategy.getDefaultParameterTypeExpression(parameterType);
    }

    protected Expression createParameterUnmarshalExpressionForAnnotation(Class clazz, Method method, Class parameterType, Annotation annotation) {
        if (annotation instanceof Property) {
            Property propertyAnnotation = (Property)annotation;
            return new PropertyExpression(propertyAnnotation.name());
        }
        if (annotation instanceof Content) {
            Content content = (Content)annotation;
            PojoMarshaler marshaller = this.newInstance(content);
            return this.createContentExpression(marshaller);
        }
        if (annotation instanceof XPath) {
            XPath xpathAnnotation = (XPath)annotation;
            JAXPStringXPathExpression expr = new JAXPStringXPathExpression(xpathAnnotation.xpath());
            if (!xpathAnnotation.prefix().equals("") && !xpathAnnotation.uri().equals("")) {
                DefaultNamespaceContext ctx = new DefaultNamespaceContext();
                ctx.add(xpathAnnotation.prefix(), xpathAnnotation.uri());
                expr.setNamespaceContext((NamespaceContext)ctx);
            }
            return expr;
        }
        return null;
    }

    protected Expression createContentExpression(final PojoMarshaler marshaller) {
        return new Expression(){

            public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
                return MessageHelper.getBody((NormalizedMessage)message, (PojoMarshaler)marshaller);
            }
        };
    }

    protected PojoMarshaler newInstance(Content content) {
        try {
            return content.marshalType().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

