/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.ConfigurationException;
import org.codehaus.classworlds.Configurator;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

public class Launcher {
    private static final String CLASSWORLDS_CONF = "classworlds.conf";
    private static final String UBERJAR_CONF_DIR = "WORLDS-INF/conf/";
    private String mainClassName;
    private String mainRealmName;
    private ClassWorld world;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$codehaus$classworlds$ClassWorld;

    public void setAppMain(String mainClassName, String mainRealmName) {
        this.mainClassName = mainClassName;
        this.mainRealmName = mainRealmName;
    }

    public String getMainRealmName() {
        return this.mainRealmName;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setWorld(ClassWorld world) {
        this.world = world;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    public void configure(InputStream is) throws IOException, MalformedURLException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        Configurator configurator = new Configurator(this);
        configurator.configure(is);
    }

    public Class getMainClass() throws ClassNotFoundException, NoSuchRealmException {
        return this.getMainRealm().loadClass(this.getMainClassName());
    }

    public ClassRealm getMainRealm() throws NoSuchRealmException {
        return this.getWorld().getRealm(this.getMainRealmName());
    }

    protected Method getEnhancedMainMethod() throws ClassNotFoundException, NoSuchMethodException, NoSuchRealmException {
        Method[] methods = this.getMainClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] paramTypes;
            int modifiers;
            Method method = methods[i];
            if ("main".equals(method.getName()) && Modifier.isStatic(modifiers = method.getModifiers()) && Modifier.isPublic(modifiers) && method.getReturnType() == Void.TYPE && (paramTypes = method.getParameterTypes()).length == 2 && paramTypes[0] == (array$Ljava$lang$String == null ? Launcher.class$("[Ljava.lang.String;") : array$Ljava$lang$String) && paramTypes[1] == (class$org$codehaus$classworlds$ClassWorld == null ? Launcher.class$("org.codehaus.classworlds.ClassWorld") : class$org$codehaus$classworlds$ClassWorld)) {
                return method;
            }
            ++i;
        }
        throw new NoSuchMethodException("public static void main(String[] args, ClassWorld world)");
    }

    protected Method getMainMethod() throws ClassNotFoundException, NoSuchMethodException, NoSuchRealmException {
        Method[] methods = this.getMainClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] paramTypes;
            int modifiers;
            if ("main".equals(methods[i].getName()) && Modifier.isStatic(modifiers = methods[i].getModifiers()) && Modifier.isPublic(modifiers) && methods[i].getReturnType() == Void.TYPE && (paramTypes = methods[i].getParameterTypes()).length == 1 && paramTypes[0] == (array$Ljava$lang$String == null ? Launcher.class$("[Ljava.lang.String;") : array$Ljava$lang$String)) {
                return methods[i];
            }
            ++i;
        }
        throw new NoSuchMethodException("public static void main(String[] args) in " + this.getMainClass());
    }

    public void launch(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        try {
            this.launchEnhanced(args);
            return;
        }
        catch (NoSuchMethodException e) {
            this.launchStandard(args);
            return;
        }
    }

    protected void launchEnhanced(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        ClassRealm mainRealm = this.getMainRealm();
        Class mainClass = this.getMainClass();
        Method mainMethod = this.getEnhancedMainMethod();
        Thread.currentThread().setContextClassLoader(mainRealm.getClassLoader());
        mainMethod.invoke((Object)mainClass, args, this.getWorld());
    }

    protected void launchStandard(String[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchRealmException {
        ClassRealm mainRealm = this.getMainRealm();
        Class mainClass = this.getMainClass();
        Method mainMethod = this.getMainMethod();
        Thread.currentThread().setContextClassLoader(mainRealm.getClassLoader());
        mainMethod.invoke((Object)mainClass, new Object[]{args});
    }

    public static void main(String[] args) throws Exception {
        String classworldsConf = System.getProperty(CLASSWORLDS_CONF);
        InputStream is = null;
        Launcher launcher = new Launcher();
        if (classworldsConf != null) {
            is = new FileInputStream(classworldsConf);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            is = "true".equals(System.getProperty("classworlds.bootstrapped")) ? cl.getResourceAsStream("WORLDS-INF/conf/classworlds.conf") : cl.getResourceAsStream(CLASSWORLDS_CONF);
        }
        if (is == null) {
            throw new Exception("classworlds configuration not specified nor found in the classpath");
        }
        launcher.configure(is);
        try {
            launcher.launch(args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

