/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.xslt;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XsltComponent
extends TransformComponentSupport
implements MessageExchangeListener {
    private TransformerFactory transformerFactory;
    private Source xsltSource;
    private Resource xsltResource;
    private Templates templates;
    private boolean disableOutput;
    private boolean useStringBuffer = true;
    private boolean forceDocIfDom = true;
    private Map xsltParameters;

    public boolean isForceDocIfDom() {
        return this.forceDocIfDom;
    }

    public void setForceDocIfDom(boolean forceDocIfDom) {
        this.forceDocIfDom = forceDocIfDom;
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Source getXsltSource() throws Exception {
        if (this.xsltSource == null) {
            this.xsltSource = this.createXsltSource();
        }
        return this.xsltSource;
    }

    public void setXsltSource(Source xsltSource) {
        this.xsltSource = xsltSource;
    }

    public Resource getXsltResource() {
        return this.xsltResource;
    }

    public void setXsltResource(Resource xsltResource) {
        this.xsltResource = xsltResource;
    }

    public boolean isDisableOutput() {
        return this.disableOutput;
    }

    public void setDisableOutput(boolean disableOutput) {
        this.disableOutput = disableOutput;
    }

    public boolean isUseStringBuffer() {
        return this.useStringBuffer;
    }

    public void setUseStringBuffer(boolean useStringBuffer) {
        this.useStringBuffer = useStringBuffer;
    }

    public Map getXsltParameters() {
        return this.xsltParameters;
    }

    public void setXsltParameters(Map xsltParameters) {
        this.xsltParameters = xsltParameters;
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        try {
            Transformer transformer = this.createTransformer(exchange, in);
            this.configureTransformer(transformer, exchange, in);
            this.copyPropertiesAndAttachments(exchange, in, out);
            this.transformContent(transformer, exchange, in, out);
            return this.shouldOutputResult(transformer);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to transform: " + e, (Throwable)e);
        }
    }

    protected void transformContent(Transformer transformer, MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws TransformerException, MessagingException, ParserConfigurationException {
        StreamResult result;
        Closeable buffer;
        Node n;
        Source src = in.getContent();
        if (this.forceDocIfDom && src instanceof DOMSource && !((n = ((DOMSource)src).getNode()) instanceof Document)) {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            doc.appendChild(doc.importNode(n, true));
            src = new DOMSource(doc);
        }
        if (this.isUseStringBuffer()) {
            buffer = new StringWriter();
            result = new StreamResult((Writer)buffer);
            transformer.transform(src, result);
            out.setContent((Source)new StringSource(((StringWriter)buffer).toString()));
        } else {
            buffer = new ByteArrayOutputStream();
            result = new StreamResult((OutputStream)buffer);
            transformer.transform(src, result);
            out.setContent((Source)new BytesSource(((ByteArrayOutputStream)buffer).toByteArray()));
        }
    }

    protected boolean shouldOutputResult(Transformer transformer) {
        return !this.disableOutput;
    }

    protected Source createXsltSource() throws Exception {
        if (this.xsltResource != null) {
            return new DOMSource(this.parse(this.xsltResource));
        }
        return null;
    }

    protected Document parse(Resource res) throws Exception {
        URL url = null;
        try {
            res.getURL();
        }
        catch (IOException e) {
            // empty catch block
        }
        DocumentBuilder builder = new SourceTransformer().createDocumentBuilder();
        return builder.parse(res.getInputStream(), url != null ? url.toExternalForm() : null);
    }

    public Templates getTemplates() throws Exception {
        if (this.templates == null) {
            this.templates = this.createTemplates();
        }
        return this.templates;
    }

    protected Templates createTemplates() throws Exception {
        Source source = this.getXsltSource();
        return this.getTransformerFactory().newTemplates(source);
    }

    protected Transformer createTransformer(MessageExchange exchange, NormalizedMessage in) throws Exception {
        Source source = this.getXsltSource();
        if (source == null) {
            return this.getTransformerFactory().newTransformer();
        }
        return this.getTemplates().newTransformer();
    }

    protected void configureTransformer(Transformer transformer, MessageExchange exchange, NormalizedMessage in) {
        Object value;
        for (String name : exchange.getPropertyNames()) {
            value = exchange.getProperty(name);
            transformer.setParameter(name, value);
        }
        for (String name : in.getPropertyNames()) {
            value = in.getProperty(name);
            transformer.setParameter(name, value);
        }
        if (this.xsltParameters != null) {
            for (String name : this.xsltParameters.keySet()) {
                value = this.xsltParameters.get(name);
                transformer.setParameter(name, value);
            }
        }
        transformer.setParameter("exchange", exchange);
        transformer.setParameter("in", in);
        transformer.setParameter("component", (Object)this);
    }
}

