/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.mps;

import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.mps.ConfigNotSupportedException;
import org.apache.servicemix.components.mps.ExistingPropertyCopier;
import org.apache.servicemix.components.mps.PropertyValue;
import org.apache.servicemix.components.mps.StaticStringPropertyValue;
import org.apache.servicemix.components.mps.XPathContentMessagePropertyValue;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyValueResolver {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    public static final String XML_ELEMENT_NAME = "property";
    private String name;
    private String staticValue = null;
    private List propertySetTypes = new ArrayList();

    public PropertyValueResolver(String propertyName, Element self) throws ConfigNotSupportedException {
        this.name = propertyName;
        this.addPropertySetTypes(self);
    }

    public void setProperty(NormalizedMessage in, NormalizedMessage out) throws JBIException {
        if (this.staticValue != null) {
            out.setProperty(this.name, (Object)this.staticValue);
        } else {
            String value = this.resolveValue(in);
            if (value != null) {
                out.setProperty(this.name, (Object)value);
            } else {
                this.logger.warn((Object)("Property " + this.name + " was not set as the value was unresolved"));
            }
        }
    }

    private String resolveValue(NormalizedMessage message) throws JBIException {
        String propValue = null;
        this.logger.debug((Object)("propvrsize=" + this.propertySetTypes.size()));
        for (int i = 0; i < this.propertySetTypes.size(); ++i) {
            PropertyValue pv = (PropertyValue)this.propertySetTypes.get(i);
            propValue = pv.getPropertyValue(message);
            this.logger.debug((Object)("value from" + pv.getClass() + " = " + propValue));
            if (propValue != null && !"".equals(propValue)) break;
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(this.name + ": " + pv.getClass() + " was empty"));
        }
        return propValue;
    }

    private void addPropertySetTypes(Element propertyElement) throws ConfigNotSupportedException {
        NodeList propertyValueNodes = propertyElement.getChildNodes();
        for (int i = 0; i < propertyValueNodes.getLength(); ++i) {
            PropertyValue pv;
            if (propertyValueNodes.item(i).getNodeType() != 1) continue;
            Element pvElem = (Element)propertyValueNodes.item(i);
            if (pvElem.getNodeName().equals("static-value")) {
                if (this.propertySetTypes.size() == 0) {
                    this.staticValue = DOMUtil.getElementText((Element)pvElem);
                }
                pv = new StaticStringPropertyValue(DOMUtil.getElementText((Element)pvElem));
            } else if (pvElem.getNodeName().equals("xpath-expression")) {
                String xpath = DOMUtil.getElementText((Element)pvElem);
                pv = new XPathContentMessagePropertyValue(xpath);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created an XPath VR :" + xpath));
                }
            } else if (pvElem.getNodeName().equals("existing-property")) {
                String propertyName = this.name;
                if (pvElem.getAttribute("name") != null && !"".equals(pvElem.getAttribute("name"))) {
                    propertyName = pvElem.getAttribute("name");
                }
                pv = new ExistingPropertyCopier(propertyName);
            } else {
                throw new ConfigNotSupportedException("Property value type " + pvElem.getNodeName() + " is not supported for the MessagePropertySetter");
            }
            this.propertySetTypes.add(pv);
        }
    }
}

