/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jabber;

import java.util.Date;
import java.util.Iterator;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.jbi.jaxp.SourceMarshaler;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class JabberMarshaler {
    private SourceMarshaler sourceMarshaler;

    public JabberMarshaler() {
        this(new SourceMarshaler());
    }

    public JabberMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public void toNMS(NormalizedMessage normalizedMessage, Packet packet) throws MessagingException {
        this.addNmsProperties(normalizedMessage, packet);
        if (packet instanceof Message) {
            Message message = (Message)packet;
            Source source = this.sourceMarshaler.asSource(message.getBody());
            normalizedMessage.setContent(source);
        }
        normalizedMessage.setProperty("org.apache.servicemix.jabber.packet", (Object)packet);
    }

    public void fromNMS(Message message, NormalizedMessage normalizedMessage) throws TransformerException {
        String xml = this.messageAsString(normalizedMessage);
        message.setBody(xml);
        this.addJabberProperties(message, normalizedMessage);
    }

    public SourceMarshaler getSourceMarshaller() {
        return this.sourceMarshaler;
    }

    public void setSourceMarshaller(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    public SourceMarshaler getSourceMarshaler() {
        return this.sourceMarshaler;
    }

    public void setSourceMarshaler(SourceMarshaler sourceMarshaler) {
        this.sourceMarshaler = sourceMarshaler;
    }

    protected String messageAsString(NormalizedMessage normalizedMessage) throws TransformerException {
        return this.sourceMarshaler.asString(normalizedMessage.getContent());
    }

    protected void addJabberProperties(Message message, NormalizedMessage normalizedMessage) {
        for (String name : normalizedMessage.getPropertyNames()) {
            Object value;
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            message.setProperty(name, value);
        }
    }

    protected void addNmsProperties(NormalizedMessage normalizedMessage, Packet message) {
        Iterator iter = message.getPropertyNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = message.getProperty(name);
            normalizedMessage.setProperty(name, value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String || value instanceof Number || value instanceof Date;
    }
}

