/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.http;

import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.http.HttpClientMarshaler;
import org.apache.servicemix.components.http.InvalidStatusResponseException;
import org.apache.servicemix.components.util.TransformComponentSupport;

public class HttpInvoker
extends TransformComponentSupport
implements MessageExchangeListener {
    protected HttpClientMarshaler marshaler = new HttpClientMarshaler();
    protected MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    protected HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    protected HostConfiguration hostConfiguration = new HostConfiguration();
    protected String url;
    protected boolean defaultInOut = true;

    public void stop() throws JBIException {
        super.stop();
        this.connectionManager.shutdown();
    }

    public HttpInvoker() {
        this.setCopyAttachments(false);
        this.setCopyProperties(false);
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        PostMethod method = new PostMethod(this.url);
        try {
            int response;
            this.marshaler.fromNMS(method, exchange, in);
            if (this.url != null) {
                this.hostConfiguration.setHost(new URI(this.url, false));
            }
            if ((response = this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)method)) != 200 && response != 202) {
                throw new InvalidStatusResponseException(response);
            }
            if (this.defaultInOut) {
                this.marshaler.toNMS(out, (HttpMethod)method);
            }
            boolean bl = this.defaultInOut;
            return bl;
        }
        catch (Exception e) {
            throw new MessagingException("Error executing http request", (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isDefaultInOut() {
        return this.defaultInOut;
    }

    public void setDefaultInOut(boolean defaultInOut) {
        this.defaultInOut = defaultInOut;
    }

    public HttpClientMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpClientMarshaler marshaler) {
        this.marshaler = marshaler;
    }
}

