/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.drools;

import java.io.InputStream;
import java.net.URL;
import javax.jbi.JBIException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.drools.JbiHelper;
import org.apache.servicemix.components.util.OutBinding;
import org.drools.FactException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.io.RuleBaseLoader;
import org.springframework.core.io.Resource;

public class DroolsComponent
extends OutBinding {
    private RuleBase ruleBase;
    private Resource ruleBaseResource;
    private URL ruleBaseURL;
    private ThreadLocal routed = new ThreadLocal();

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public Resource getRuleBaseResource() {
        return this.ruleBaseResource;
    }

    public void setRuleBaseResource(Resource ruleBaseResource) {
        this.ruleBaseResource = ruleBaseResource;
    }

    public URL getRuleBaseURL() {
        return this.ruleBaseURL;
    }

    public void setRuleBaseURL(URL ruleBaseURL) {
        this.ruleBaseURL = ruleBaseURL;
    }

    public void forwardToService(MessageExchange exchange, NormalizedMessage in, QName name) throws MessagingException {
        DeliveryChannel channel = this.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactoryForService(name);
        InOnly outExchange = factory.createInOnlyExchange();
        String processCorrelationId = (String)exchange.getProperty("org.apache.servicemix.correlationId");
        if (processCorrelationId != null) {
            outExchange.setProperty("org.apache.servicemix.correlationId", (Object)processCorrelationId);
        }
        this.forwardToExchange(exchange, outExchange, in);
    }

    public void forwardToInterface(QName name, MessageExchange exchange, NormalizedMessage in) throws MessagingException {
        DeliveryChannel channel = this.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactory(name);
        InOnly outExchange = factory.createInOnlyExchange();
        String processCorrelationId = (String)exchange.getProperty("org.apache.servicemix.correlationId");
        if (processCorrelationId != null) {
            outExchange.setProperty("org.apache.servicemix.correlationId", (Object)processCorrelationId);
        }
        this.forwardToExchange(exchange, outExchange, in);
    }

    public void route(MessageExchange exchange, NormalizedMessage in, QName service, QName interfaceName, QName operation) throws MessagingException {
        if (this.routed.get() != null) {
            throw new IllegalStateException("Drools component has already routed this exchange");
        }
        this.routed.set(Boolean.TRUE);
        DeliveryChannel channel = this.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactory();
        MessageExchange me = factory.createExchange(exchange.getPattern());
        me.setInterfaceName(interfaceName);
        me.setService(service);
        me.setOperation(operation);
        NormalizedMessage nm = me.createMessage();
        me.setMessage(nm, "in");
        this.getMessageTransformer().transform(exchange, in, nm);
        channel.sendSync(me);
        if (me.getStatus() == ExchangeStatus.ERROR) {
            this.fail(exchange, me.getError());
        } else if (me.getStatus() == ExchangeStatus.DONE) {
            this.done(exchange);
        } else {
            NormalizedMessage out = me.getMessage("out");
            if (out != null) {
                nm = exchange.createMessage();
                exchange.setMessage(nm, "out");
                this.getMessageTransformer().transform(exchange, out, nm);
            } else {
                Fault f = me.getFault();
                Fault of = exchange.createFault();
                exchange.setFault(of);
                this.getMessageTransformer().transform(exchange, (NormalizedMessage)f, (NormalizedMessage)of);
            }
            channel.send(exchange);
            this.done(me);
        }
    }

    protected void init() throws JBIException {
        block4: {
            super.init();
            try {
                if (this.ruleBase != null) break block4;
                if (this.ruleBaseResource != null) {
                    this.ruleBase = RuleBaseLoader.loadFromInputStream((InputStream)this.ruleBaseResource.getInputStream());
                    break block4;
                }
                if (this.ruleBaseURL != null) {
                    this.ruleBase = RuleBaseLoader.loadFromUrl((URL)this.ruleBaseURL);
                    break block4;
                }
                throw new IllegalArgumentException("You must specify a ruleBase, ruleBaseResource or ruleBaseURL property");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JBIException((Throwable)e);
            }
        }
    }

    protected void process(MessageExchange exchange, NormalizedMessage in) throws Exception {
        WorkingMemory memory = this.ruleBase.newWorkingMemory();
        this.populateWorkingMemory(memory, exchange, in);
        this.routed.set(null);
        memory.fireAllRules();
        if (this.routed.get() == null) {
            if (exchange instanceof InOut) {
                this.fail(exchange, new Exception("Drools component has not routed the exchange"));
            } else {
                this.done(exchange);
            }
        }
    }

    protected void populateWorkingMemory(WorkingMemory memory, MessageExchange exchange, NormalizedMessage in) throws MessagingException, FactException {
        memory.setApplicationData("context", (Object)this.getContext());
        memory.setApplicationData("deliveryChannel", (Object)this.getDeliveryChannel());
        memory.setApplicationData("jbi", (Object)new JbiHelper(this, exchange, in, memory));
        memory.assertObject((Object)in);
        memory.assertObject((Object)exchange);
    }
}

