/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.activesoap;

import java.io.Reader;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.stream.XMLStreamReader;
import org.apache.servicemix.components.activesoap.ASInvocation;
import org.apache.servicemix.components.activesoap.ASMarshaler;
import org.codehaus.activesoap.transport.Invocation;
import org.codehaus.activesoap.transport.TransportClient;
import org.codehaus.activesoap.util.XMLStreamFactory;

public class ASTransport
implements TransportClient {
    private ASMarshaler marshaler = new ASMarshaler();
    private DeliveryChannel channel;
    private XMLStreamFactory streamFactory;

    public ASTransport(DeliveryChannel channel) {
        this(channel, new XMLStreamFactory());
    }

    public ASTransport(DeliveryChannel channel, XMLStreamFactory streamFactory) {
        this.channel = channel;
        this.streamFactory = streamFactory;
    }

    public Invocation createInvocation() {
        return new ASInvocation(this, this.streamFactory);
    }

    public void invokeOneWay(Invocation invocation, Reader request) throws Exception {
        throw new UnsupportedOperationException("Should never be invoked directly");
    }

    public Reader invokeRequest(Invocation invocation, Reader request) throws Exception {
        throw new UnsupportedOperationException("Should never be invoked directly");
    }

    public void close() throws Exception {
        this.channel.close();
    }

    public void invokeOneWay(ASInvocation invocation, String xml) throws Exception {
        MessageExchangeFactory fac = this.channel.createExchangeFactory();
        InOnly exchange = fac.createInOnlyExchange();
        NormalizedMessage inMessage = exchange.createMessage();
        this.marshaler.setContent(inMessage, xml);
        exchange.setInMessage(inMessage);
        this.channel.send((MessageExchange)exchange);
    }

    public XMLStreamReader invokeRequest(ASInvocation invocation, String xml) throws Exception {
        MessageExchangeFactory fac = this.channel.createExchangeFactory();
        InOut exchange = fac.createInOutExchange();
        NormalizedMessage inMessage = exchange.createMessage();
        this.marshaler.setContent(inMessage, xml);
        exchange.setInMessage(inMessage);
        boolean answer = this.channel.sendSync((MessageExchange)exchange);
        if (answer) {
            NormalizedMessage outMessage = exchange.getOutMessage();
            return this.marshaler.createStreamReader(outMessage);
        }
        Fault fault = exchange.getFault();
        return this.marshaler.createStreamReader((NormalizedMessage)fault);
    }
}

