/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.spring.main;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.xbean.server.main.FatalStartupError;
import org.apache.xbean.server.main.Main;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.apache.xbean.spring.context.SpringApplicationContext;

public class SpringBootstrap {
    private static final String XBEAN_BOOTSTRAP_MANIFEST = "XBean-Bootstrap";
    private static final String BOOTSTRAP_FLAG = "--bootstrap";
    private static final String DEFAULT_BOOTSTRAP = "META-INF/xbean-bootstrap.xml";
    private static final List DEFAULT_PROPERTY_EDITOR_PATHS = Collections.singletonList("org.apache.xbean.server.propertyeditor");
    private String configurationFile;
    private String[] mainArguments;
    private List propertyEditorPaths = DEFAULT_PROPERTY_EDITOR_PATHS;
    private String serverBaseDirectory;

    public static void main(String[] args) {
        SpringBootstrap springBootstrap = new SpringBootstrap();
        SpringBootstrap.main(args, springBootstrap);
    }

    public static void main(String[] args, SpringBootstrap springBootstrap) {
        springBootstrap.initialize(args);
        try {
            springBootstrap.boot();
        }
        catch (FatalStartupError e) {
            System.err.println(e.getMessage());
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            System.exit(e.getExitCode());
        }
        catch (Throwable e) {
            System.err.println("Unknown error");
            e.printStackTrace();
            System.exit(9);
        }
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public String[] getMainArguments() {
        return this.mainArguments;
    }

    public void setMainArguments(String[] mainArguments) {
        this.mainArguments = mainArguments;
    }

    public List getPropertyEditorPaths() {
        return this.propertyEditorPaths;
    }

    public void setPropertyEditorPaths(List propertyEditorPaths) {
        this.propertyEditorPaths = propertyEditorPaths;
    }

    public String getServerBaseDirectory() {
        return this.serverBaseDirectory;
    }

    public void setServerBaseDirectory(String serverBaseDirectory) {
        this.serverBaseDirectory = serverBaseDirectory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(String[] args) {
        if (args.length > 1 && BOOTSTRAP_FLAG.equals(args[0])) {
            this.configurationFile = args[1];
            this.mainArguments = new String[args.length - 2];
            System.arraycopy(args, 2, this.mainArguments, 0, args.length);
        } else {
            if (this.configurationFile == null) {
                this.configurationFile = DEFAULT_BOOTSTRAP;
            }
            this.mainArguments = args;
        }
        URL url = SpringBootstrap.class.getClassLoader().getResource("META-INF/startup-jar");
        if (url != null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
                if (this.serverBaseDirectory == null) {
                    URI baseURI = new URI(url.toString()).resolve("..");
                    this.serverBaseDirectory = new File(baseURI).getAbsolutePath();
                }
                Manifest manifest = jarConnection.getManifest();
                Attributes mainAttributes = manifest.getMainAttributes();
                if (this.configurationFile != null) return;
                this.configurationFile = mainAttributes.getValue(XBEAN_BOOTSTRAP_MANIFEST);
                return;
            }
            catch (Exception e) {
                System.err.println("Could not determine xbean installation directory");
                e.printStackTrace();
                System.exit(9);
                return;
            }
        } else {
            if (this.serverBaseDirectory != null) return;
            String dir = System.getProperty("xbean.base.dir", System.getProperty("user.dir"));
            this.serverBaseDirectory = new File(dir).getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Main loadMain() {
        if (this.serverBaseDirectory == null) {
            throw new NullPointerException("serverBaseDirectory is null");
        }
        File baseDirectory = new File(this.serverBaseDirectory);
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("serverBaseDirectory is not a directory: " + this.serverBaseDirectory);
        }
        if (this.configurationFile == null) {
            throw new NullPointerException("configurationFile is null");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SpringBootstrap.class.getClassLoader());
        try {
            SpringApplicationContext factory;
            if (this.propertyEditorPaths != null && !this.propertyEditorPaths.isEmpty()) {
                LinkedList<String> editorSearchPath = new LinkedList<String>(Arrays.asList(PropertyEditorManager.getEditorSearchPath()));
                editorSearchPath.addAll(this.propertyEditorPaths);
                PropertyEditorManager.setEditorSearchPath(editorSearchPath.toArray(new String[editorSearchPath.size()]));
            }
            System.setProperty("xbean.base.dir", baseDirectory.getAbsolutePath());
            File file = new File(this.configurationFile);
            if (!file.isAbsolute()) {
                file = new File(baseDirectory, this.configurationFile);
            }
            if (file.canRead()) {
                try {
                    factory = new FileSystemXmlApplicationContext(file.toURL().toString());
                }
                catch (MalformedURLException e) {
                    throw new FatalStartupError("Error creating url for bootstrap file", e);
                }
            } else {
                factory = new ClassPathXmlApplicationContext(this.configurationFile);
            }
            String[] names = factory.getBeanNamesForType(Main.class);
            Main main = null;
            if (names.length == 0) {
                throw new FatalStartupError("No bean of type: " + Main.class.getName() + " found in the bootstrap file: " + this.configurationFile, 10);
            }
            Main main2 = main = (Main)factory.getBean(names[0]);
            return main2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public void boot() {
        Main main = this.loadMain();
        main.main(this.mainArguments);
    }
}

