/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.spring.loader;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.StringServiceName;
import org.apache.xbean.server.loader.Loader;
import org.apache.xbean.server.spring.configuration.SpringConfigurationServiceFactory;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.support.AbstractXmlApplicationContext;

public class SpringLoader
implements Loader {
    private Kernel kernel;
    private File baseDir = new File(".").getAbsoluteFile();
    private List beanFactoryPostProcessors = Collections.EMPTY_LIST;
    private List xmlPreprocessors = Collections.EMPTY_LIST;
    private AbstractXmlApplicationContext applicationContext;

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public List getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    public void setBeanFactoryPostProcessors(List beanFactoryPostProcessors) {
        this.beanFactoryPostProcessors = beanFactoryPostProcessors;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public List getXmlPreprocessors() {
        return this.xmlPreprocessors;
    }

    public void setXmlPreprocessors(List xmlPreprocessors) {
        this.xmlPreprocessors = xmlPreprocessors;
    }

    public ServiceName load(String location) throws Exception {
        String resolvedLocation = this.baseDir.toURI().resolve(location).getPath();
        String configLocation = "/" + resolvedLocation + ".xml";
        this.applicationContext = this.createXmlApplicationContext(configLocation);
        for (BeanFactoryPostProcessor processor : this.beanFactoryPostProcessors) {
            this.applicationContext.addBeanFactoryPostProcessor(processor);
        }
        this.applicationContext.setDisplayName(location);
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = SpringLoader.class.getClassLoader();
        }
        StringServiceName serviceName = new StringServiceName("configuration:" + location);
        SpringConfigurationServiceFactory springConfigurationServiceFactory = new SpringConfigurationServiceFactory(this.applicationContext);
        this.kernel.registerService(serviceName, springConfigurationServiceFactory);
        return serviceName;
    }

    public AbstractXmlApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected AbstractXmlApplicationContext createXmlApplicationContext(String configLocation) {
        return new FileSystemXmlApplicationContext(new String[]{configLocation}, false, this.xmlPreprocessors);
    }
}

