/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.loader;

import java.util.Iterator;
import java.util.List;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.server.loader.Loader;
import org.apache.xbean.server.main.FatalStartupError;
import org.apache.xbean.server.main.Main;

public class LoadAllMain
implements Main {
    private Kernel kernel;
    private Main next;

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Main getNext() {
        return this.next;
    }

    public void setNext(Main next) {
        this.next = next;
    }

    public void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String location = args[i];
            this.load(location);
        }
        if (this.next != null) {
            this.next.main(new String[0]);
        }
    }

    private void load(String location) {
        List loaders = this.kernel.getServices(Loader.class);
        for (Loader loader : loaders) {
            try {
                ServiceName configurationName = loader.load(location);
                if (configurationName == null) continue;
                this.kernel.startServiceRecursive(configurationName);
                return;
            }
            catch (Exception e) {
                throw new FatalStartupError("Error loading '" + location + "' with " + loader, e);
            }
        }
        String message = "No loaders were able to load '" + location + "' : Available loaders ";
        Iterator iterator = loaders.iterator();
        while (iterator.hasNext()) {
            message = message + iterator.next();
            if (!iterator.hasNext()) continue;
            message = message + ", ";
        }
        throw new FatalStartupError(message);
    }
}

