/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.classloader.NamedClassLoader;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceAlreadyExistsException;
import org.apache.xbean.kernel.ServiceRegistrationException;
import org.apache.xbean.kernel.StringServiceName;
import org.apache.xbean.server.spring.configuration.SpringConfigurationServiceFactory;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileDeployer
implements Runnable,
InitializingBean,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(FileDeployer.class);
    private File baseDir;
    private Kernel kernel;
    private ClassLoader classLoader;
    private boolean verbose;
    private String[] jarDirectoryNames = new String[]{"lib", "classes"};
    private List beanFactoryPostProcessors = Collections.EMPTY_LIST;
    private List xmlPreprocessors = Collections.EMPTY_LIST;
    private ApplicationContext applicationContext;
    private boolean showIgnoredFiles;

    public void afterPropertiesSet() throws Exception {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        if (this.baseDir == null) {
            log.warn((Object)"No directory specified so using current directory");
            this.baseDir = new File(".");
        }
        this.baseDir = this.baseDir.getAbsoluteFile();
        log.info((Object)("Starting to load components from: " + this.baseDir));
        this.processDirectory("", this.classLoader, this.applicationContext, this.baseDir);
        log.info((Object)"Loading completed");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run() {
        try {
            String name = "";
            if (this.applicationContext != null) {
                name = this.applicationContext.getDisplayName();
            }
            this.processDirectory(name, this.classLoader, this.applicationContext, this.baseDir);
        }
        catch (Exception e) {
            log.error((Object)("Failed to deploy services: " + e), (Throwable)e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public List getXmlPreprocessors() {
        return this.xmlPreprocessors;
    }

    public void setXmlPreprocessors(List xmlPreprocessors) {
        this.xmlPreprocessors = xmlPreprocessors;
    }

    public List getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    public void setBeanFactoryPostProcessors(List beanFactoryPostProcessors) {
        this.beanFactoryPostProcessors = beanFactoryPostProcessors;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isShowIgnoredFiles() {
        return this.showIgnoredFiles;
    }

    public void setShowIgnoredFiles(boolean showIgnoredFiles) {
        this.showIgnoredFiles = showIgnoredFiles;
    }

    public String[] getJarDirectoryNames() {
        return this.jarDirectoryNames;
    }

    public void setJarDirectoryNames(String[] jarDirectoryNames) {
        this.jarDirectoryNames = jarDirectoryNames;
    }

    protected void processDirectory(String parentName, ClassLoader classLoader, ApplicationContext parentContext, File directory) throws ServiceAlreadyExistsException, ServiceRegistrationException, BeansException, IOException {
        String name;
        String name2;
        File file;
        String orderName;
        log.debug((Object)("Processing directory: " + directory));
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        Properties properties = new Properties();
        LinkedHashMap<String, File> fileMap = new LinkedHashMap<String, File>();
        LinkedHashMap<String, File> directoryMap = new LinkedHashMap<String, File>();
        for (int i = 0; i < files.length; ++i) {
            File file2 = files[i];
            if (this.isClassLoaderDirectory(file2)) {
                classLoader = this.createChildClassLoader(parentName, file2, classLoader);
                log.debug((Object)("Created class loader: " + classLoader));
                continue;
            }
            if (this.isXBeansPropertyFile(file2)) {
                properties.load(new FileInputStream(file2));
                continue;
            }
            if (file2.isDirectory()) {
                directoryMap.put(file2.getName(), file2);
                continue;
            }
            fileMap.put(file2.getName(), file2);
        }
        String[] names = this.getFileNameOrder(properties);
        for (int i = 0; i < names.length; ++i) {
            orderName = names[i];
            file = (File)fileMap.remove(orderName);
            if (file == null) continue;
            name2 = this.getChildName(parentName, file);
            this.createServiceForFile(name2, file, classLoader, parentContext);
        }
        for (File file3 : fileMap.values()) {
            name = this.getChildName(parentName, file3);
            this.createServiceForFile(name, file3, classLoader, parentContext);
        }
        for (int i = 0; i < names.length; ++i) {
            orderName = names[i];
            file = (File)directoryMap.remove(orderName);
            if (file == null) continue;
            name2 = this.getChildName(parentName, file);
            this.processDirectory(name2, classLoader, parentContext, file);
        }
        for (File file3 : directoryMap.values()) {
            name = this.getChildName(parentName, file3);
            this.processDirectory(name, classLoader, parentContext, file3);
        }
    }

    protected ClassLoader createChildClassLoader(String name, File dir, ClassLoader parentClassLoader) throws MalformedURLException {
        File[] files;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.verbose) {
            try {
                log.info((Object)("Adding to classpath: " + dir.getCanonicalPath()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((files = dir.listFiles()) != null) {
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].getName().endsWith(".zip") && !files[j].getName().endsWith(".jar")) continue;
                if (this.verbose) {
                    try {
                        log.info((Object)("Adding to classpath: " + name + " jar: " + files[j].getCanonicalPath()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                urls.add(files[j].toURL());
            }
        }
        URL[] u = new URL[urls.size()];
        urls.toArray(u);
        return new NamedClassLoader(name + ".ClassLoader", u, parentClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createServiceForFile(String name, File file, ClassLoader classLoader, ApplicationContext parentContext) throws ServiceAlreadyExistsException, ServiceRegistrationException, BeansException, IOException {
        if (this.isSpringConfigFile(file)) {
            System.setProperty("xbean.current.file", file.getAbsolutePath());
            System.setProperty("xbean.current.dir", file.getParent());
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            log.debug((Object)("Loading file: " + file + " using classLoader: " + classLoader));
            try {
                ResourceXmlApplicationContext applicationContext = new ResourceXmlApplicationContext((Resource)new FileSystemResource(file), this.xmlPreprocessors, parentContext, this.beanFactoryPostProcessors, false);
                applicationContext.setDisplayName(name);
                applicationContext.setClassLoader(classLoader);
                SpringConfigurationServiceFactory serviceFactory = new SpringConfigurationServiceFactory(applicationContext);
                log.info((Object)("Registering spring services service: " + name + " from: " + file.getAbsolutePath() + " into the Kernel"));
                this.kernel.registerService(new StringServiceName(name), serviceFactory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        } else if (this.showIgnoredFiles) {
            log.info((Object)("Ignoring file: " + file.getName() + " in directory: " + file.getParent()));
        }
    }

    protected boolean isClassLoaderDirectory(File file) {
        if (this.jarDirectoryNames != null) {
            for (int i = 0; i < this.jarDirectoryNames.length; ++i) {
                String name = this.jarDirectoryNames[i];
                if (!file.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSpringConfigFile(File file) {
        String fileName = file.getName();
        return fileName.endsWith("spring.xml") || fileName.endsWith("xbean.xml");
    }

    private boolean isXBeansPropertyFile(File file) {
        String fileName = file.getName();
        return fileName.equalsIgnoreCase("xbean.properties");
    }

    protected String[] getFileNameOrder(Properties properties) {
        String order = properties.getProperty("order", "");
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer iter = new StringTokenizer(order, ",");
        while (iter.hasMoreTokens()) {
            list.add(iter.nextToken());
        }
        String[] answer = new String[list.size()];
        list.toArray(answer);
        return answer;
    }

    protected String getChildName(String parentName, File file) {
        StringBuffer buffer = new StringBuffer(parentName);
        if (parentName.length() > 0) {
            buffer.append("/");
        }
        buffer.append(file.getName());
        return buffer.toString();
    }
}

