/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import java.io.Serializable;

public final class ServiceState
implements Serializable {
    private static final long serialVersionUID = -2629672602273580572L;
    public static final ServiceState STARTING = new ServiceState(0, "STARTING");
    public static final ServiceState RUNNING = new ServiceState(1, "RUNNING");
    public static final ServiceState STOPPING = new ServiceState(2, "STOPPING");
    public static final ServiceState STOPPED = new ServiceState(3, "STOPPED");
    private static final ServiceState[] serviceStateIndex = new ServiceState[]{STARTING, RUNNING, STOPPING, STOPPED};
    private final byte index;
    private final transient String name;

    public static ServiceState getServiceState(int state) throws IllegalArgumentException {
        if (state < 0 || state >= serviceStateIndex.length) {
            throw new IllegalArgumentException("Unknown state " + state);
        }
        return serviceStateIndex[state];
    }

    public static ServiceState parseServiceState(String state) {
        if (state == null) {
            throw new NullPointerException("state is null");
        }
        if (STARTING.toString().equalsIgnoreCase(state)) {
            return STARTING;
        }
        if (RUNNING.toString().equalsIgnoreCase(state)) {
            return RUNNING;
        }
        if (STOPPING.toString().equalsIgnoreCase(state)) {
            return STOPPING;
        }
        if (STOPPED.toString().equalsIgnoreCase(state)) {
            return STOPPED;
        }
        throw new IllegalArgumentException("Unknown state " + state);
    }

    private ServiceState(byte index, String name) {
        this.index = index;
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        return serviceStateIndex[this.index];
    }

    static {
        for (int i = 0; i < serviceStateIndex.length; ++i) {
            ServiceState serviceState = serviceStateIndex[i];
            if (serviceState.getIndex() != i) {
                throw new AssertionError((Object)(serviceState + " state index is " + serviceState.getIndex() + ", but is located at index " + i + " in the serviceStateIndex"));
            }
        }
    }
}

