/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import org.apache.xbean.kernel.NullServiceMonitor;
import org.apache.xbean.kernel.ServiceCondition;
import org.apache.xbean.kernel.ServiceConditionContext;
import org.apache.xbean.kernel.ServiceEvent;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;
import org.apache.xbean.kernel.ServiceState;
import org.apache.xbean.kernel.StoppedServiceCondition;

public class RunningServiceCondition
implements ServiceCondition {
    private final ServiceName dependency;
    private final boolean ownedRelationship;
    private final boolean stopOnServiceShutdown;
    private final DependencyServiceMonitor serviceMonitor = new DependencyServiceMonitor();
    private ServiceConditionContext context;
    private boolean satisfied = true;
    private StoppedServiceCondition stoppedServiceCondition;

    public RunningServiceCondition(ServiceName dependency, boolean ownedRelationship, boolean stopOnServiceShutdown) {
        if (dependency == null) {
            throw new NullPointerException("dependency is null");
        }
        this.dependency = dependency;
        this.ownedRelationship = ownedRelationship;
        this.stopOnServiceShutdown = stopOnServiceShutdown;
    }

    public synchronized void initialize(ServiceConditionContext context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.context != null) {
            this.destroy();
        }
        this.context = context;
        this.satisfied = false;
        context.getKernel().addServiceMonitor(this.serviceMonitor, this.dependency);
        if (this.ownedRelationship) {
            // empty if block
        }
        if (this.stopOnServiceShutdown) {
            this.stoppedServiceCondition = new StoppedServiceCondition(context.getServiceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isSatisfied() {
        if (this.context == null) {
            return true;
        }
        if (!this.satisfied) {
            try {
                ServiceFactory serviceFactory;
                ServiceFactory serviceFactory2 = serviceFactory = this.context.getKernel().getServiceFactory(this.dependency);
                synchronized (serviceFactory2) {
                    if (this.context.getKernel().getService(this.dependency) == ServiceState.RUNNING) {
                        if (this.stopOnServiceShutdown) {
                            serviceFactory.addStopCondition(this.stoppedServiceCondition);
                        }
                        this.satisfied = true;
                        this.context.getKernel().removeServiceMonitor(this.serviceMonitor);
                    }
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return this.satisfied;
    }

    public synchronized void destroy() {
        if (this.context == null) {
            return;
        }
        this.context.getKernel().removeServiceMonitor(this.serviceMonitor);
        this.context = null;
        this.satisfied = true;
        if (this.ownedRelationship) {
            // empty if block
        }
        if (this.stopOnServiceShutdown) {
            this.stoppedServiceCondition.destroy();
            this.stoppedServiceCondition = null;
        }
    }

    private class DependencyServiceMonitor
    extends NullServiceMonitor {
        private DependencyServiceMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRunning(ServiceEvent serviceEvent) {
            RunningServiceCondition runningServiceCondition = RunningServiceCondition.this;
            synchronized (runningServiceCondition) {
                if (RunningServiceCondition.this.context != null) {
                    return;
                }
                if (!RunningServiceCondition.this.satisfied) {
                    return;
                }
                if (RunningServiceCondition.this.isSatisfied()) {
                    RunningServiceCondition.this.context.setSatisfied();
                }
            }
        }
    }
}

