/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow.support;

import java.lang.reflect.Method;
import org.apache.servicemix.beanflow.Workflow;
import org.apache.servicemix.beanflow.WorkflowStep;
import org.apache.servicemix.beanflow.support.EnumHelper;
import org.apache.servicemix.beanflow.support.Interpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionInterpreter<T>
implements Interpreter<T> {
    protected static final Class[] NO_TYPE_ARGUMENTS = new Class[0];
    protected static final Object[] NO_PARAMETER_ARGUMENTS = new Object[0];

    @Override
    public void executeStep(T step, Workflow<T> workflow) {
        if (step instanceof WorkflowStep) {
            WorkflowStep workflowStep = (WorkflowStep)step;
            T nextStep = workflowStep.execute(workflow);
            if (nextStep != null) {
                workflow.addStep(nextStep);
            } else {
                workflow.suspend();
            }
        } else if (step instanceof Runnable) {
            Runnable runnable = (Runnable)step;
            runnable.run();
            this.goToNextSequence(step, workflow);
        } else if (step != null) {
            String name = step.toString();
            this.executeNamedStep(name, workflow);
        }
    }

    protected void goToNextSequence(T nextStep, Workflow<T> workflow) {
        block5: {
            if (nextStep instanceof Enum) {
                Enum step = (Enum)nextStep;
                try {
                    Object[] enumValues = EnumHelper.getEnumValues(step.getClass());
                    int index = step.ordinal();
                    if (++index < enumValues.length) {
                        workflow.addStep(enumValues[index]);
                        break block5;
                    }
                    workflow.stop();
                }
                catch (Exception e) {
                    workflow.fail("Could not extract the values of the enum: " + nextStep + " due to: " + e, e);
                }
            } else {
                workflow.suspend();
            }
        }
    }

    public void executeNamedStep(String step, Workflow<T> workflow) {
        Class<?> type = workflow.getClass();
        try {
            Method method = type.getMethod(step, NO_TYPE_ARGUMENTS);
            Object answer = method.invoke(workflow, NO_PARAMETER_ARGUMENTS);
            this.handleStepResult(step, workflow, answer);
        }
        catch (Exception e) {
            workflow.onStepException(step, e);
        }
    }

    @Override
    public void validateStepsExist(Object[] stepValues, Workflow<T> workflow) {
        Class<?> type = workflow.getClass();
        for (int i = 0; i < stepValues.length; ++i) {
            Object value = stepValues[i];
            if (this.isValidStep(value)) continue;
            String step = value.toString();
            try {
                type.getMethod(step, NO_TYPE_ARGUMENTS);
                continue;
            }
            catch (Exception e) {
                workflow.fail("No " + step + "() method is available in class: " + type.getName() + " so unable to bind the code to the enumeration of steps", e);
            }
        }
    }

    protected boolean isValidStep(Object value) {
        return value instanceof WorkflowStep || value instanceof Runnable;
    }

    protected void handleStepResult(String step, Workflow workflow, Object result) {
        if (result != null) {
            workflow.addStep(result);
        } else {
            workflow.suspend();
        }
    }
}

