/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.servicemix.beanflow.annotations.Parallel;
import org.apache.servicemix.beanflow.support.CallablesFactory;
import org.apache.servicemix.beanflow.support.MethodReflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindCallableMethods<T>
implements CallablesFactory<T> {
    private final Object source;
    private List<Class> annotations;

    public FindCallableMethods(Object source) {
        this(source, Parallel.class);
    }

    public FindCallableMethods(Object source, Class annotation) {
        this(source, Collections.singletonList(annotation));
    }

    public FindCallableMethods(Object source, List<Class> annotations) {
        this.annotations = annotations;
        this.source = source;
    }

    @Override
    public List<Callable<T>> createCallables() {
        ArrayList<Callable<T>> answer = new ArrayList<Callable<T>>();
        if (this.source != null) {
            for (Class<?> type = this.source.getClass(); type != Object.class && type != null; type = type.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = type.getDeclaredMethods()) {
                    if (!this.isValidMethod(this.source, method)) continue;
                    MethodReflector reflector = new MethodReflector(this.source, method);
                    answer.add(reflector);
                }
            }
        }
        return answer;
    }

    public List<Class> getAnnotations() {
        return this.annotations;
    }

    protected boolean isValidMethod(Object source, Method method) {
        if (method.getParameterTypes().length == 0) {
            for (Class annotationType : this.annotations) {
                Object annotation = method.getAnnotation(annotationType);
                if (annotation == null) continue;
                return true;
            }
        }
        return false;
    }
}

