/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.servicemix.beanflow.Activity;
import org.apache.servicemix.beanflow.TimeoutActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinSupport
extends TimeoutActivity {
    private List<Activity> children = new ArrayList<Activity>();
    private Set<Activity> toBeStarted = new HashSet<Activity>();

    public JoinSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinSupport(List<Activity> activities) {
        List<Activity> list = this.children;
        synchronized (list) {
            for (Activity activity : activities) {
                activity.getState().addRunnable(this);
                this.children.add(activity);
                this.toBeStarted.add(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinSupport(Activity ... activities) {
        List<Activity> list = this.children;
        synchronized (list) {
            for (Activity activity : activities) {
                activity.getState().addRunnable(this);
                this.children.add(activity);
                this.toBeStarted.add(activity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fork(Activity child) {
        List<Activity> list = this.children;
        synchronized (list) {
            child.getState().addRunnable(this);
            this.children.add(child);
            child.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelFork(Activity child) {
        List<Activity> list = this.children;
        synchronized (list) {
            child.getState().removeRunnable(this);
            this.children.remove(child);
            child.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onValidStateChange() {
        int childCount = 0;
        int stoppedCount = 0;
        int failedCount = 0;
        List<Activity> list = this.children;
        synchronized (list) {
            childCount = this.children.size();
            for (Activity child : this.children) {
                if (!child.isStopped()) continue;
                ++stoppedCount;
                if (!child.isFailed()) continue;
                ++failedCount;
            }
        }
        this.onChildStateChange(childCount, stoppedCount, failedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        super.doStart();
        List<Activity> list = this.children;
        synchronized (list) {
            for (Activity child : this.toBeStarted) {
                child.start();
            }
            this.toBeStarted.clear();
        }
    }

    protected abstract void onChildStateChange(int var1, int var2, int var3);
}

