/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow;

import org.apache.servicemix.beanflow.State;
import org.apache.servicemix.beanflow.support.Notifier;
import org.apache.servicemix.beanflow.support.SynchronousNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultState<T>
implements State<T> {
    private T value;
    private Object lock = new Object();
    private Notifier notifier;

    public DefaultState() {
        this.notifier = new SynchronousNotifier();
    }

    public DefaultState(T value) {
        this();
        this.value = value;
    }

    public DefaultState(Notifier notifier) {
        this.notifier = notifier;
    }

    public DefaultState(T value, Notifier notifier) {
        this.value = value;
        this.notifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.lock;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getAndSet(T value) {
        T answer = null;
        Object object = this.lock;
        synchronized (object) {
            answer = this.value;
            this.value = value;
        }
        this.notifier.run();
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T value) {
        Object object = this.lock;
        synchronized (object) {
            this.value = value;
        }
        this.notifier.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSet(T expected, T newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (DefaultState.equals(this.value, expected)) {
                this.value = newValue;
                this.notifier.run();
                return true;
            }
        }
        return false;
    }

    @Override
    public void addRunnable(Runnable listener) {
        this.notifier.addRunnable(listener);
    }

    @Override
    public void removeRunnable(Runnable listener) {
        this.notifier.removeRunnable(listener);
    }

    public String toString() {
        T currentValue = this.get();
        if (currentValue == null) {
            return "null";
        }
        return currentValue.toString();
    }

    @Override
    public boolean is(T that) {
        T currentValue = this.get();
        return DefaultState.equals(that, currentValue);
    }

    @Override
    public boolean isAny(T ... values) {
        T currentValue = this.get();
        for (T value : values) {
            if (!DefaultState.equals(currentValue, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }
}

