/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.Serializable;
import javax.resource.spi.ConnectionRequestInfo;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.RedeliveryPolicy;

public class ActiveMQConnectionRequestInfo
implements ConnectionRequestInfo,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5754338187296859149L;
    private String userName;
    private String password;
    private String serverUrl;
    private String clientid;
    private Boolean useInboundSession;
    private RedeliveryPolicy redeliveryPolicy;
    private ActiveMQPrefetchPolicy prefetchPolicy;

    public ActiveMQConnectionRequestInfo copy() {
        try {
            ActiveMQConnectionRequestInfo answer = (ActiveMQConnectionRequestInfo)this.clone();
            if (this.redeliveryPolicy != null) {
                answer.redeliveryPolicy = this.redeliveryPolicy.copy();
            }
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public boolean isConnectionFactoryConfigured() {
        return this.serverUrl != null || this.clientid != null || this.redeliveryPolicy != null || this.prefetchPolicy != null;
    }

    public void configure(ActiveMQConnectionFactory factory) {
        if (this.serverUrl != null) {
            factory.setBrokerURL(this.serverUrl);
        }
        if (this.clientid != null) {
            factory.setClientID(this.clientid);
        }
        if (this.redeliveryPolicy != null) {
            factory.setRedeliveryPolicy(this.redeliveryPolicy);
        }
        if (this.prefetchPolicy != null) {
            factory.setPrefetchPolicy(this.prefetchPolicy);
        }
    }

    public int hashCode() {
        int rc = 0;
        if (this.useInboundSession != null) {
            rc ^= this.useInboundSession.hashCode();
        }
        if (this.serverUrl != null) {
            rc ^= this.serverUrl.hashCode();
        }
        return rc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ActiveMQConnectionRequestInfo i = (ActiveMQConnectionRequestInfo)o;
        if (this.notEqual(this.serverUrl, i.serverUrl)) {
            return false;
        }
        return !this.notEqual(this.useInboundSession, i.useInboundSession);
    }

    private boolean notEqual(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 != null && !o1.equals(o2);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userid) {
        this.userName = userid;
    }

    public String getClientid() {
        return this.clientid;
    }

    public void setClientid(String clientid) {
        this.clientid = clientid;
    }

    public String toString() {
        return "ActiveMQConnectionRequestInfo{ userName = '" + this.userName + "' " + ", serverUrl = '" + this.serverUrl + "' " + ", clientid = '" + this.clientid + "' " + ", userName = '" + this.userName + "' " + ", useInboundSession = '" + this.useInboundSession + "' " + " }";
    }

    public Boolean getUseInboundSession() {
        return this.useInboundSession;
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        this.useInboundSession = useInboundSession;
    }

    public boolean isUseInboundSessionEnabled() {
        return this.useInboundSession != null && this.useInboundSession != false;
    }

    public Short getRedeliveryBackOffMultiplier() {
        return new Short(this.redeliveryPolicy().getBackOffMultiplier());
    }

    public Long getInitialRedeliveryDelay() {
        return new Long(this.redeliveryPolicy().getInitialRedeliveryDelay());
    }

    public Integer getMaximumRedeliveries() {
        return new Integer(this.redeliveryPolicy().getMaximumRedeliveries());
    }

    public Boolean getRedeliveryUseExponentialBackOff() {
        return new Boolean(this.redeliveryPolicy().isUseExponentialBackOff());
    }

    public void setRedeliveryBackOffMultiplier(Short value) {
        if (value != null) {
            this.redeliveryPolicy().setBackOffMultiplier(value.shortValue());
        }
    }

    public void setInitialRedeliveryDelay(Long value) {
        if (value != null) {
            this.redeliveryPolicy().setInitialRedeliveryDelay(value.longValue());
        }
    }

    public void setMaximumRedeliveries(Integer value) {
        if (value != null) {
            this.redeliveryPolicy().setMaximumRedeliveries(value.intValue());
        }
    }

    public void setRedeliveryUseExponentialBackOff(Boolean value) {
        if (value != null) {
            this.redeliveryPolicy().setUseExponentialBackOff(value.booleanValue());
        }
    }

    public Integer getDurableTopicPrefetch() {
        return new Integer(this.prefetchPolicy().getDurableTopicPrefetch());
    }

    public Integer getInputStreamPrefetch() {
        return new Integer(this.prefetchPolicy().getInputStreamPrefetch());
    }

    public Integer getQueueBrowserPrefetch() {
        return new Integer(this.prefetchPolicy().getQueueBrowserPrefetch());
    }

    public Integer getQueuePrefetch() {
        return new Integer(this.prefetchPolicy().getQueuePrefetch());
    }

    public Integer getTopicPrefetch() {
        return new Integer(this.prefetchPolicy().getTopicPrefetch());
    }

    public void setAllPrefetchValues(Integer i) {
        if (i != null) {
            this.prefetchPolicy().setAll(i.intValue());
        }
    }

    public void setDurableTopicPrefetch(Integer durableTopicPrefetch) {
        if (durableTopicPrefetch != null) {
            this.prefetchPolicy().setDurableTopicPrefetch(durableTopicPrefetch.intValue());
        }
    }

    public void setInputStreamPrefetch(Integer inputStreamPrefetch) {
        if (inputStreamPrefetch != null) {
            this.prefetchPolicy().setInputStreamPrefetch(inputStreamPrefetch.intValue());
        }
    }

    public void setQueueBrowserPrefetch(Integer queueBrowserPrefetch) {
        if (queueBrowserPrefetch != null) {
            this.prefetchPolicy().setQueueBrowserPrefetch(queueBrowserPrefetch.intValue());
        }
    }

    public void setQueuePrefetch(Integer queuePrefetch) {
        if (queuePrefetch != null) {
            this.prefetchPolicy().setQueuePrefetch(queuePrefetch.intValue());
        }
    }

    public void setTopicPrefetch(Integer topicPrefetch) {
        if (topicPrefetch != null) {
            this.prefetchPolicy().setTopicPrefetch(topicPrefetch.intValue());
        }
    }

    public RedeliveryPolicy redeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new RedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public ActiveMQPrefetchPolicy prefetchPolicy() {
        if (this.prefetchPolicy == null) {
            this.prefetchPolicy = new ActiveMQPrefetchPolicy();
        }
        return this.prefetchPolicy;
    }
}

