/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.PojoSupport;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.tck.ReceiverPojo;
import org.apache.servicemix.tck.Sender;

public class SenderPojo
extends PojoSupport
implements ComponentLifeCycle,
Sender {
    public static final QName SERVICE = new QName("http://servicemix.org/example/", "sender");
    public static final String ENDPOINT = "sender";
    private static final Log LOG = LogFactory.getLog(SenderPojo.class);
    protected QName interfaceName;
    protected int numMessages = 10;
    protected ComponentContext context;
    protected List messages = new ArrayList();
    protected boolean done;

    public SenderPojo() {
        this(ReceiverPojo.SERVICE);
    }

    public SenderPojo(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void init(ComponentContext ctx) throws JBIException {
        this.context = ctx;
        ctx.activateEndpoint(SERVICE, ENDPOINT);
    }

    public int messagesReceived() {
        return this.messages.size();
    }

    public void sendMesssages() throws MessagingException {
        this.sendMessages(this.numMessages);
    }

    public void sendMessages(int messageCount) throws MessagingException {
        this.sendMessages(messageCount, true);
    }

    public void sendMessages(int messageCount, boolean sync) throws MessagingException {
        LOG.info((Object)("Looking for services for interface: " + this.interfaceName));
        ServiceEndpoint[] endpoints = this.context.getEndpointsForService(this.interfaceName);
        if (endpoints.length > 0) {
            ServiceEndpoint endpoint = endpoints[0];
            LOG.info((Object)("Sending to endpoint: " + endpoint));
            for (int i = 0; i < messageCount; ++i) {
                InOnly exchange = this.context.getDeliveryChannel().createExchangeFactory().createInOnlyExchange();
                NormalizedMessage message = exchange.createMessage();
                exchange.setEndpoint(endpoint);
                exchange.setInMessage(message);
                String xml = "<s12:Envelope xmlns:s12='http://www.w3.org/2003/05/soap-envelope'>  <s12:Body><foo>Hello!</foo> </s12:Body></s12:Envelope>";
                message.setContent((Source)new StringSource(xml));
                LOG.info((Object)("sending message: " + i));
                DeliveryChannel deliveryChannel = this.context.getDeliveryChannel();
                LOG.info((Object)("sync send on deliverychannel: " + deliveryChannel));
                if (sync) {
                    deliveryChannel.sendSync((MessageExchange)exchange);
                    continue;
                }
                deliveryChannel.send((MessageExchange)exchange);
            }
        } else {
            LOG.warn((Object)("No endpoints available for interface: " + this.interfaceName));
        }
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public int getNumMessages() {
        return this.numMessages;
    }

    public void setNumMessages(int numMessages) {
        this.numMessages = numMessages;
    }
}

