/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.resolver;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.resolver.EndpointChooser;

public class ServiceRoundRobinPolicy
implements EndpointChooser {
    private Map<QName, Integer> lastIndexMap = new HashMap<QName, Integer>();
    private int lastIndex;

    public ServiceEndpoint chooseEndpoint(ServiceEndpoint[] endpoints, ComponentContext context, MessageExchange exchange) {
        if (endpoints.length == 0) {
            return null;
        }
        if (exchange.getService() == null) {
            return endpoints[0];
        }
        this.lastIndex = this.lastIndexMap.containsKey(exchange.getService()) ? this.lastIndexMap.get(exchange.getService()) : 0;
        if (this.lastIndex >= endpoints.length || this.lastIndex < 0) {
            this.lastIndex = 0;
        }
        ServiceEndpoint result = endpoints[this.lastIndex++];
        this.lastIndexMap.put(exchange.getService(), this.lastIndex);
        return result;
    }
}

