/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.seda;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.management.LifeCycleMBean;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.servicemix.jbi.event.ComponentAdapter;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.flow.AbstractFlow;
import org.apache.servicemix.jbi.nmr.flow.seda.SedaQueue;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;

public class SedaFlow
extends AbstractFlow {
    protected Map<ComponentNameSpace, SedaQueue> queueMap = new ConcurrentHashMap<ComponentNameSpace, SedaQueue>();
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected ComponentListener listener;

    public String getDescription() {
        return "seda";
    }

    public void init(Broker broker) throws JBIException {
        super.init(broker);
        this.listener = new ComponentAdapter(){

            public void componentShutDown(ComponentEvent event) {
                SedaFlow.this.onComponentShutdown(event.getComponent().getComponentNameSpace());
            }
        };
        broker.getContainer().addListener(this.listener);
    }

    public boolean canHandle(MessageExchange me) {
        if (this.isPersistent(me)) {
            return false;
        }
        if (this.isClustered(me)) {
            return false;
        }
        return !this.isTransacted(me) || this.isSynchronous(me) || me.getStatus() != ExchangeStatus.ACTIVE;
    }

    public void start() throws JBIException {
        if (this.started.compareAndSet(false, true)) {
            for (SedaQueue queue : this.queueMap.values()) {
                queue.start();
            }
        }
        super.start();
    }

    public void stop() throws JBIException {
        if (this.started.compareAndSet(true, false)) {
            for (SedaQueue queue : this.queueMap.values()) {
                queue.stop();
            }
        }
        super.stop();
    }

    public void shutDown() throws JBIException {
        this.broker.getContainer().removeListener(this.listener);
        for (SedaQueue queue : this.queueMap.values()) {
            queue.shutDown();
            this.unregisterQueue(queue);
        }
        super.shutDown();
    }

    protected void doSend(MessageExchangeImpl me) throws JBIException {
        if (me.getDestinationId() == null) {
            me.setDestinationId(((AbstractServiceEndpoint)me.getEndpoint()).getComponentNameSpace());
        }
        if (this.isTransacted(me)) {
            me.setTxState(2);
        }
        this.suspendTx(me);
        this.enqueuePacket(me);
    }

    protected void doRouting(MessageExchangeImpl me) throws MessagingException {
        this.resumeTx(me);
        super.doRouting(me);
    }

    protected void enqueuePacket(MessageExchangeImpl me) throws JBIException {
        ComponentNameSpace cns = me.getDestinationId();
        SedaQueue queue = this.queueMap.get(cns);
        if (queue == null) {
            queue = this.createQueue(cns);
        }
        try {
            queue.enqueue(me);
        }
        catch (InterruptedException e) {
            throw new MessagingException(queue + " Failed to enqueue exchange: " + me, (Throwable)e);
        }
    }

    protected synchronized SedaQueue createQueue(ComponentNameSpace cns) throws JBIException {
        SedaQueue queue = this.queueMap.get(cns);
        if (queue == null) {
            queue = new SedaQueue(cns);
            queue.init(this);
            this.registerQueue(cns, queue);
            if (this.started.get()) {
                queue.start();
            }
            this.queueMap.put(cns, queue);
        }
        return queue;
    }

    public synchronized void onComponentShutdown(ComponentNameSpace cns) {
        block3: {
            SedaQueue queue = this.queueMap.remove(cns);
            if (queue != null) {
                try {
                    queue.shutDown();
                    this.unregisterQueue(queue);
                }
                catch (JBIException e) {
                    this.log.error((Object)("Failed to stop SedaQueue: " + queue + ": " + (Object)((Object)e)));
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)("Failed to stop SedaQueue: " + queue), (Throwable)e);
                }
            }
        }
    }

    public synchronized void release(SedaQueue queue) {
        if (queue != null) {
            this.queueMap.remove(queue.getComponentNameSpace());
            this.unregisterQueue(queue);
        }
    }

    public int getQueueNumber() {
        return this.queueMap.size();
    }

    protected void registerQueue(ComponentNameSpace cns, SedaQueue queue) {
        block3: {
            try {
                ObjectName objectName = this.broker.getContainer().getManagementContext().createObjectName(queue);
                if (this.getSubType() != null) {
                    objectName = new ObjectName(objectName + ",subtype=" + this.getSubType());
                }
                queue.setObjectName(objectName);
                this.broker.getContainer().getManagementContext().registerMBean(objectName, queue, LifeCycleMBean.class);
            }
            catch (JMException e) {
                this.log.error((Object)("Failed to register SedaQueue: " + queue + " with the ManagementContext: " + e));
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Failed to register SedaQueue: " + queue + " with the ManagementContext"), (Throwable)e);
            }
        }
    }

    protected void unregisterQueue(SedaQueue queue) {
        block2: {
            try {
                this.broker.getContainer().getManagementContext().unregisterMBean(queue.getObjectName());
            }
            catch (JBIException e) {
                this.log.error((Object)("Failed to unregister SedaQueue: " + queue + " from the ManagementContext"));
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Failed to unregister SedaQueue: " + queue + " with the ManagementContext"), (Throwable)e);
            }
        }
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "queueNumber", "number of running SedaQueues");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    protected void suspendTx(MessageExchangeImpl me) throws MessagingException {
        try {
            TransactionManager tm;
            Transaction oldTx = me.getTransactionContext();
            if (oldTx != null && (tm = (TransactionManager)this.getBroker().getContainer().getTransactionManager()) != null) {
                Transaction tx;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Suspending transaction for " + me.getExchangeId() + " in " + this));
                }
                if ((tx = tm.suspend()) != oldTx) {
                    throw new IllegalStateException("the transaction context set in the messageExchange is not bound to the current thread");
                }
            }
        }
        catch (Exception e) {
            throw new MessagingException((Throwable)e);
        }
    }

    protected void resumeTx(MessageExchangeImpl me) throws MessagingException {
        try {
            TransactionManager tm;
            Transaction oldTx = me.getTransactionContext();
            if (oldTx != null && (tm = (TransactionManager)this.getBroker().getContainer().getTransactionManager()) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Resuming transaction for " + me.getExchangeId() + " in " + this));
                }
                tm.resume(oldTx);
            }
        }
        catch (Exception e) {
            throw new MessagingException((Throwable)e);
        }
    }
}

