/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.jbi.event.ComponentAdapter;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.EndpointAdapter;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.flow.AbstractFlow;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

public abstract class AbstractJMSFlow
extends AbstractFlow
implements MessageListener {
    private static final String INBOUND_PREFIX = "org.apache.servicemix.jms.";
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected MessageConsumer monitorMessageConsumer;
    protected Set<String> subscriberSet = new CopyOnWriteArraySet<String>();
    private String userName;
    private String password;
    private String broadcastDestinationName = "org.apache.servicemix.JMSFlow";
    private MessageConsumer broadcastConsumer;
    private Map<String, MessageConsumer> consumerMap = new ConcurrentHashMap<String, MessageConsumer>();
    private EndpointListener endpointListener;
    private ComponentListener componentListener;
    private Executor executor;
    private String jmsURL = "peer://org.apache.servicemix?persistent=false";

    public String getDescription() {
        return "jms";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getBroadcastDestinationName() {
        return this.broadcastDestinationName;
    }

    public void setBroadcastDestinationName(String broadcastDestinationName) {
        this.broadcastDestinationName = broadcastDestinationName;
    }

    public boolean canHandle(MessageExchange me) {
        return !this.isTransacted(me);
    }

    public void init(Broker broker) throws JBIException {
        this.log.debug((Object)(broker.getContainer().getName() + ": Initializing jms flow"));
        super.init(broker);
        this.executor = broker.getContainer().getExecutorFactory().createExecutor("flow.jms");
        this.endpointListener = new EndpointAdapter(){

            public void internalEndpointRegistered(EndpointEvent event) {
                AbstractJMSFlow.this.onInternalEndpointRegistered(event, true);
            }

            public void internalEndpointUnregistered(EndpointEvent event) {
                AbstractJMSFlow.this.onInternalEndpointUnregistered(event, true);
            }
        };
        broker.getContainer().addListener(this.endpointListener);
        this.componentListener = new ComponentAdapter(){

            public void componentStarted(ComponentEvent event) {
                AbstractJMSFlow.this.onComponentStarted(event);
            }

            public void componentStopped(ComponentEvent event) {
                AbstractJMSFlow.this.onComponentStopped(event);
            }
        };
        broker.getContainer().addListener(this.componentListener);
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = this.createConnectionFactoryFromUrl(this.jmsURL);
            }
            this.connection = this.userName != null ? this.connectionFactory.createConnection(this.userName, this.password) : this.connectionFactory.createConnection();
            this.connection.setClientID(broker.getContainer().getName());
            this.connection.start();
            Session inboundSession = this.connection.createSession(false, 1);
            Queue queue = inboundSession.createQueue(INBOUND_PREFIX + broker.getContainer().getName());
            MessageConsumer inboundQueue = inboundSession.createConsumer((Destination)queue);
            inboundQueue.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            this.log.error((Object)"Failed to initialize JMSFlow", (Throwable)e);
            throw new JBIException((Throwable)e);
        }
    }

    protected abstract ConnectionFactory createConnectionFactoryFromUrl(String var1);

    protected abstract void onConsumerMonitorMessage(Message var1);

    public abstract void startConsumerMonitor() throws JMSException;

    public void stopConsumerMonitor() throws JMSException {
        this.monitorMessageConsumer.close();
    }

    public void start() throws JBIException {
        if (this.started.compareAndSet(false, true)) {
            this.log.debug((Object)(this.broker.getContainer().getName() + ": Starting jms flow"));
            super.start();
            try {
                Session broadcastSession = this.connection.createSession(false, 1);
                Topic broadcastTopic = broadcastSession.createTopic(this.broadcastDestinationName);
                this.broadcastConsumer = broadcastSession.createConsumer((Destination)broadcastTopic, null, true);
                this.broadcastConsumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message message) {
                        try {
                            Serializable obj = ((ObjectMessage)message).getObject();
                            if (obj instanceof EndpointEvent) {
                                EndpointEvent event = (EndpointEvent)obj;
                                String container = ((InternalEndpoint)event.getEndpoint()).getComponentNameSpace().getContainerName();
                                if (!AbstractJMSFlow.this.getBroker().getContainer().getName().equals(container)) {
                                    if (event.getEventType() == 0) {
                                        AbstractJMSFlow.this.onRemoteEndpointRegistered(event);
                                    } else if (event.getEventType() == 1) {
                                        AbstractJMSFlow.this.onRemoteEndpointUnregistered(event);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            AbstractJMSFlow.this.log.error((Object)"Error processing incoming broadcast message", (Throwable)e);
                        }
                    }
                });
                for (ComponentMBeanImpl cmp : this.broker.getContainer().getRegistry().getComponents()) {
                    if (!cmp.isStarted()) continue;
                    this.onComponentStarted(new ComponentEvent(cmp, 2));
                }
                ServiceEndpoint[] endpoints = this.broker.getContainer().getRegistry().getEndpointsForInterface(null);
                for (int i = 0; i < endpoints.length; ++i) {
                    if (!(endpoints[i] instanceof InternalEndpoint) || !((InternalEndpoint)endpoints[i]).isLocal()) continue;
                    this.onInternalEndpointRegistered(new EndpointEvent(endpoints[i], 0), false);
                }
                this.startConsumerMonitor();
            }
            catch (JMSException e) {
                JBIException jbiEx = new JBIException("JMSException caught in start: " + e.getMessage());
                throw jbiEx;
            }
        }
    }

    public void stop() throws JBIException {
        if (this.started.compareAndSet(true, false)) {
            this.log.debug((Object)(this.broker.getContainer().getName() + ": Stopping jms flow"));
            super.stop();
            for (String id : this.subscriberSet) {
                this.removeAllPackets(id);
            }
            this.subscriberSet.clear();
            try {
                this.stopConsumerMonitor();
                this.broadcastConsumer.close();
            }
            catch (JMSException e) {
                this.log.debug((Object)"JMSException caught in stop", (Throwable)e);
            }
        }
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        this.stop();
        this.broker.getContainer().removeListener(this.endpointListener);
        this.broker.getContainer().removeListener(this.componentListener);
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                this.log.warn((Object)"Error closing JMS Connection", (Throwable)e);
            }
        }
    }

    public int numberInNetwork() {
        return this.subscriberSet.size();
    }

    public void onInternalEndpointRegistered(EndpointEvent event, boolean broadcast) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            if (!this.consumerMap.containsKey(key)) {
                Session inboundSession = this.connection.createSession(false, 1);
                Queue queue = inboundSession.createQueue(INBOUND_PREFIX + key);
                MessageConsumer consumer = inboundSession.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)this);
                this.consumerMap.put(key, consumer);
            }
            if (broadcast) {
                this.broadcast(event);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for " + event.getEndpoint()), (Throwable)e);
        }
    }

    public void onInternalEndpointUnregistered(EndpointEvent event, boolean broadcast) {
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            MessageConsumer consumer = this.consumerMap.remove(key);
            if (consumer != null) {
                consumer.close();
            }
            if (broadcast) {
                this.broadcast(event);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for " + event), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcast(EndpointEvent event) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.broker.getContainer().getName() + ": broadcasting info for " + event));
        }
        Session broadcastSession = this.connection.createSession(false, 1);
        try {
            ObjectMessage msg = broadcastSession.createObjectMessage((Serializable)event);
            Topic broadcastTopic = broadcastSession.createTopic(this.broadcastDestinationName);
            MessageProducer topicProducer = broadcastSession.createProducer((Destination)broadcastTopic);
            topicProducer.setDeliveryMode(1);
            topicProducer.send((Message)msg);
        }
        finally {
            broadcastSession.close();
        }
    }

    public void onComponentStarted(ComponentEvent event) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = event.getComponent().getName();
            if (!this.consumerMap.containsKey(key)) {
                Session inboundSession = this.connection.createSession(false, 1);
                Queue queue = inboundSession.createQueue(INBOUND_PREFIX + key);
                MessageConsumer consumer = inboundSession.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)this);
                this.consumerMap.put(key, consumer);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onComponentStopped(ComponentEvent event) {
        try {
            String key = event.getComponent().getName();
            MessageConsumer consumer = this.consumerMap.remove(key);
            if (consumer != null) {
                consumer.close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onRemoteEndpointRegistered(EndpointEvent event) {
        this.log.debug((Object)(this.broker.getContainer().getName() + ": adding remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().registerRemoteEndpoint(event.getEndpoint());
    }

    public void onRemoteEndpointUnregistered(EndpointEvent event) {
        this.log.debug((Object)(this.broker.getContainer().getName() + ": removing remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().unregisterRemoteEndpoint(event.getEndpoint());
    }

    protected void doSend(MessageExchangeImpl me) throws MessagingException {
        this.doRouting(me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRouting(MessageExchangeImpl me) throws MessagingException {
        try {
            String destination;
            if (me.getRole() == MessageExchange.Role.PROVIDER) {
                destination = me.getDestinationId() == null ? INBOUND_PREFIX + EndpointSupport.getKey(me.getEndpoint()) : (Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.provider.stateless")) && !this.isSynchronous(me) ? INBOUND_PREFIX + me.getDestinationId().getName() : INBOUND_PREFIX + me.getDestinationId().getContainerName());
            } else {
                if (me.getSourceId() == null) {
                    throw new IllegalStateException("No sourceId set on the exchange");
                }
                destination = Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.consumer.stateless")) && !this.isSynchronous(me) ? (me.getProperty("org.apache.servicemix.senderEndpoint") != null ? INBOUND_PREFIX + me.getProperty("org.apache.servicemix.senderEndpoint") : INBOUND_PREFIX + me.getSourceId().getName()) : INBOUND_PREFIX + me.getSourceId().getContainerName();
            }
            Session inboundSession = this.connection.createSession(false, 1);
            try {
                Queue queue = inboundSession.createQueue(destination);
                ObjectMessage msg = inboundSession.createObjectMessage((Serializable)me);
                MessageProducer queueProducer = inboundSession.createProducer((Destination)queue);
                queueProducer.send((Message)msg);
            }
            finally {
                inboundSession.close();
            }
        }
        catch (JMSException e) {
            this.log.error((Object)("Failed to send exchange: " + me + " internal JMS Network"), (Throwable)e);
            throw new MessagingException((Throwable)e);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message != null && this.started.get()) {
                ObjectMessage objMsg = (ObjectMessage)message;
                final MessageExchangeImpl me = (MessageExchangeImpl)objMsg.getObject();
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            if (me.getDestinationId() == null) {
                                ServiceEndpoint se = me.getEndpoint();
                                se = AbstractJMSFlow.this.broker.getContainer().getRegistry().getInternalEndpoint(se.getServiceName(), se.getEndpointName());
                                me.setEndpoint(se);
                                me.setDestinationId(((InternalEndpoint)se).getComponentNameSpace());
                            }
                            AbstractJMSFlow.super.doRouting(me);
                        }
                        catch (Throwable e) {
                            AbstractJMSFlow.this.log.error((Object)"Caught an exception routing ExchangePacket: ", e);
                        }
                    }
                });
            }
        }
        catch (JMSException jmsEx) {
            this.log.error((Object)"Caught an exception unpacking JMS Message: ", (Throwable)jmsEx);
        }
    }

    protected void addClusterNode(String connectionId) {
        this.subscriberSet.add(connectionId);
        ServiceEndpoint[] endpoints = this.broker.getContainer().getRegistry().getEndpointsForInterface(null);
        for (int i = 0; i < endpoints.length; ++i) {
            if (!(endpoints[i] instanceof InternalEndpoint) || !((InternalEndpoint)endpoints[i]).isLocal()) continue;
            this.onInternalEndpointRegistered(new EndpointEvent(endpoints[i], 0), true);
        }
    }

    protected void removeClusterNode(String connectionId) {
        this.subscriberSet.remove(connectionId);
        this.removeAllPackets(connectionId);
    }

    protected void removeAllPackets(String containerName) {
    }

    public String getJmsURL() {
        return this.jmsURL;
    }

    public void setJmsURL(String jmsURL) {
        this.jmsURL = jmsURL;
    }
}

