/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.jca;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.ra.ActiveMQActivationSpec;
import org.apache.activemq.ra.ActiveMQManagedConnectionFactory;
import org.apache.activemq.ra.ActiveMQResourceAdapter;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.WorkManagerWrapper;
import org.apache.servicemix.jbi.event.ComponentAdapter;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.EndpointAdapter;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.flow.AbstractFlow;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.jencks.SingletonEndpointFactory;
import org.jencks.factory.ConnectionManagerFactoryBean;

public class JCAFlow
extends AbstractFlow
implements MessageListener {
    private static final String INBOUND_PREFIX = "org.apache.servicemix.jca.";
    private String jmsURL = "tcp://localhost:61616";
    private ActiveMQConnectionFactory connectionFactory;
    private ConnectionFactory managedConnectionFactory;
    private String broadcastDestinationName = "org.apache.servicemix.JCAFlow";
    private ActiveMQTopic broadcastTopic;
    private Map<String, Connector> connectorMap = new ConcurrentHashMap<String, Connector>();
    private AtomicBoolean started = new AtomicBoolean(false);
    private Set<String> subscriberSet = new CopyOnWriteArraySet<String>();
    private ConnectionManager connectionManager;
    private Connector containerConnector;
    private Connector broadcastConnector;
    private Connector advisoryConnector;
    private ActiveMQTopic advisoryTopic;
    private EndpointListener endpointListener;
    private ComponentListener componentListener;

    public JCAFlow() {
    }

    public JCAFlow(String jmsURL) {
        this.jmsURL = jmsURL;
    }

    public String getDescription() {
        return "jca";
    }

    public String getJmsURL() {
        return this.jmsURL;
    }

    public void setJmsURL(String jmsURL) {
        this.jmsURL = jmsURL;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getBroadcastDestinationName() {
        return this.broadcastDestinationName;
    }

    public void setBroadcastDestinationName(String broadcastDestinationName) {
        this.broadcastDestinationName = broadcastDestinationName;
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.broker.getContainer().getTransactionManager();
    }

    public void init(Broker broker) throws JBIException {
        this.log.debug((Object)(broker.getContainer().getName() + ": Initializing jca flow"));
        super.init(broker);
        this.endpointListener = new EndpointAdapter(){

            public void internalEndpointRegistered(EndpointEvent event) {
                JCAFlow.this.onInternalEndpointRegistered(event, true);
            }

            public void internalEndpointUnregistered(EndpointEvent event) {
                JCAFlow.this.onInternalEndpointUnregistered(event, true);
            }
        };
        broker.getContainer().addListener(this.endpointListener);
        this.componentListener = new ComponentAdapter(){

            public void componentStarted(ComponentEvent event) {
                JCAFlow.this.onComponentStarted(event);
            }

            public void componentStopped(ComponentEvent event) {
                JCAFlow.this.onComponentStopped(event);
            }
        };
        broker.getContainer().addListener(this.componentListener);
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = new ActiveMQConnectionFactory(this.jmsURL);
            }
            ActiveMQQueue dest = new ActiveMQQueue(INBOUND_PREFIX + broker.getContainer().getName());
            this.containerConnector = new Connector((ActiveMQDestination)dest, this, true);
            this.containerConnector.start();
            ActiveMQResourceAdapter outboundRa = new ActiveMQResourceAdapter();
            outboundRa.setConnectionFactory(this.connectionFactory);
            if (outboundRa.getInfo().getServerUrl() == null) {
                this.log.info((Object)("ActiveMQResourceAdapter server url was null.  Setting it to: " + this.jmsURL));
                outboundRa.getInfo().setServerUrl(this.jmsURL);
            }
            ActiveMQManagedConnectionFactory mcf = new ActiveMQManagedConnectionFactory();
            mcf.setResourceAdapter((ResourceAdapter)outboundRa);
            this.managedConnectionFactory = (ConnectionFactory)mcf.createConnectionFactory(this.getConnectionManager());
            this.broadcastTopic = new ActiveMQTopic(this.broadcastDestinationName);
            this.advisoryTopic = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)this.broadcastTopic);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to initialize JCAFlow", (Throwable)e);
            throw new JBIException((Throwable)e);
        }
    }

    public void start() throws JBIException {
        if (this.started.compareAndSet(false, true)) {
            super.start();
            try {
                Object listener = new MessageListener(){

                    public void onMessage(Message message) {
                        try {
                            Serializable obj = ((ObjectMessage)message).getObject();
                            if (obj instanceof EndpointEvent) {
                                EndpointEvent event = (EndpointEvent)obj;
                                String container = ((InternalEndpoint)event.getEndpoint()).getComponentNameSpace().getContainerName();
                                if (!JCAFlow.this.getBroker().getContainer().getName().equals(container)) {
                                    if (event.getEventType() == 0) {
                                        JCAFlow.this.onRemoteEndpointRegistered(event);
                                    } else if (event.getEventType() == 1) {
                                        JCAFlow.this.onRemoteEndpointUnregistered(event);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            JCAFlow.this.log.error((Object)"Error processing incoming broadcast message", (Throwable)e);
                        }
                    }
                };
                this.broadcastConnector = new Connector((ActiveMQDestination)this.broadcastTopic, (MessageListener)listener, false);
                this.broadcastConnector.start();
                listener = new MessageListener(){

                    public void onMessage(Message message) {
                        if (JCAFlow.this.started.get()) {
                            JCAFlow.this.onAdvisoryMessage(((ActiveMQMessage)message).getDataStructure());
                        }
                    }
                };
                this.advisoryConnector = new Connector((ActiveMQDestination)this.advisoryTopic, (MessageListener)listener, false);
                this.advisoryConnector.start();
            }
            catch (Exception e) {
                throw new JBIException("JMSException caught in start: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() throws JBIException {
        if (this.started.compareAndSet(true, false)) {
            super.stop();
            try {
                this.broadcastConnector.stop();
            }
            catch (Exception e) {
                this.log.debug((Object)"Error closing jca connector", (Throwable)e);
            }
            try {
                this.advisoryConnector.stop();
            }
            catch (Exception e) {
                this.log.debug((Object)"Error closing jca connector", (Throwable)e);
            }
        }
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        this.stop();
        this.broker.getContainer().removeListener(this.endpointListener);
        this.broker.getContainer().removeListener(this.componentListener);
        while (!this.connectorMap.isEmpty()) {
            Connector connector = this.connectorMap.remove(this.connectorMap.keySet().iterator().next());
            try {
                connector.stop();
            }
            catch (Exception e) {
                this.log.debug((Object)"Error closing jca connector", (Throwable)e);
            }
        }
        try {
            this.containerConnector.stop();
        }
        catch (Exception e) {
            this.log.debug((Object)"Error closing jca connector", (Throwable)e);
        }
    }

    public int numberInNetwork() {
        return this.subscriberSet.size();
    }

    public boolean canHandle(MessageExchange me) {
        return !this.isSynchronous(me);
    }

    public void onInternalEndpointRegistered(EndpointEvent event, boolean broadcast) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            if (!this.connectorMap.containsKey(key)) {
                ActiveMQQueue dest = new ActiveMQQueue(INBOUND_PREFIX + key);
                Connector connector = new Connector((ActiveMQDestination)dest, this, true);
                connector.start();
                this.connectorMap.put(key, connector);
            }
            if (broadcast) {
                this.log.debug((Object)(this.broker.getContainer().getName() + ": broadcasting info for " + event));
                this.sendJmsMessage((Destination)this.broadcastTopic, event, false, false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for " + event.getEndpoint()), (Throwable)e);
        }
    }

    public void onInternalEndpointUnregistered(EndpointEvent event, boolean broadcast) {
        try {
            String key = EndpointSupport.getKey(event.getEndpoint());
            Connector connector = this.connectorMap.remove(key);
            if (connector != null) {
                connector.stop();
            }
            if (broadcast) {
                this.log.debug((Object)(this.broker.getContainer().getName() + ": broadcasting info for " + event));
                this.sendJmsMessage((Destination)this.broadcastTopic, event, false, false);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for " + event), (Throwable)e);
        }
    }

    public void onComponentStarted(ComponentEvent event) {
        if (!this.started.get()) {
            return;
        }
        try {
            String key = event.getComponent().getName();
            if (!this.connectorMap.containsKey(key)) {
                ActiveMQQueue dest = new ActiveMQQueue(INBOUND_PREFIX + key);
                Connector connector = new Connector((ActiveMQDestination)dest, this, true);
                connector.start();
                this.connectorMap.put(key, connector);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot create consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onComponentStopped(ComponentEvent event) {
        try {
            String key = event.getComponent().getName();
            Connector connector = this.connectorMap.remove(key);
            if (connector != null) {
                connector.stop();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot destroy consumer for component " + event.getComponent().getName()), (Throwable)e);
        }
    }

    public void onRemoteEndpointRegistered(EndpointEvent event) {
        this.log.debug((Object)(this.broker.getContainer().getName() + ": adding remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().registerRemoteEndpoint(event.getEndpoint());
    }

    public void onRemoteEndpointUnregistered(EndpointEvent event) {
        this.log.debug((Object)(this.broker.getContainer().getName() + ": removing remote endpoint: " + event.getEndpoint()));
        this.broker.getContainer().getRegistry().unregisterRemoteEndpoint(event.getEndpoint());
    }

    protected void doSend(MessageExchangeImpl me) throws MessagingException {
        this.doRouting(me);
    }

    public void doRouting(MessageExchangeImpl me) throws MessagingException {
        try {
            String destination;
            if (me.getRole() == MessageExchange.Role.PROVIDER) {
                destination = me.getDestinationId() == null ? INBOUND_PREFIX + EndpointSupport.getKey(me.getEndpoint()) : (Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.provider.stateless")) && !this.isSynchronous(me) ? INBOUND_PREFIX + me.getDestinationId().getName() : INBOUND_PREFIX + me.getDestinationId().getContainerName());
            } else {
                if (me.getSourceId() == null) {
                    throw new IllegalStateException("No sourceId set on the exchange");
                }
                destination = Boolean.TRUE.equals(me.getProperty("org.apache.servicemix.consumer.stateless")) && !this.isSynchronous(me) ? (me.getProperty("org.apache.servicemix.senderEndpoint") != null ? INBOUND_PREFIX + me.getProperty("org.apache.servicemix.senderEndpoint") : INBOUND_PREFIX + me.getSourceId().getName()) : INBOUND_PREFIX + me.getSourceId().getContainerName();
            }
            if (me.isTransacted()) {
                me.setTxState(1);
            }
            this.sendJmsMessage((Destination)new ActiveMQQueue(destination), me, this.isPersistent(me), me.isTransacted());
        }
        catch (JMSException e) {
            this.log.error((Object)("Failed to send exchange: " + me + " internal JMS Network"), (Throwable)e);
            throw new MessagingException((Throwable)e);
        }
        catch (SystemException e) {
            this.log.error((Object)("Failed to send exchange: " + me + " transaction problem"), (Throwable)e);
            throw new MessagingException((Throwable)e);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message != null && this.started.get()) {
                ObjectMessage objMsg = (ObjectMessage)message;
                MessageExchangeImpl me = (MessageExchangeImpl)objMsg.getObject();
                TransactionManager tm = this.getTransactionManager();
                if (tm != null) {
                    me.setTransactionContext(tm.getTransaction());
                }
                if (me.getDestinationId() == null) {
                    ServiceEndpoint se = me.getEndpoint();
                    se = this.broker.getContainer().getRegistry().getInternalEndpoint(se.getServiceName(), se.getEndpointName());
                    me.setEndpoint(se);
                    me.setDestinationId(((InternalEndpoint)se).getComponentNameSpace());
                }
                super.doRouting(me);
            }
        }
        catch (JMSException jmsEx) {
            this.log.error((Object)"Caught an exception unpacking JMS Message: ", (Throwable)jmsEx);
        }
        catch (MessagingException e) {
            this.log.error((Object)"Caught an exception routing ExchangePacket: ", (Throwable)e);
        }
        catch (SystemException e) {
            this.log.error((Object)"Caught an exception acessing transaction context: ", (Throwable)e);
        }
    }

    protected void onAdvisoryMessage(Object obj) {
        if (obj instanceof ConsumerInfo) {
            ConsumerInfo info = (ConsumerInfo)obj;
            this.subscriberSet.add(info.getConsumerId().getConnectionId());
            ServiceEndpoint[] endpoints = this.broker.getContainer().getRegistry().getEndpointsForInterface(null);
            for (int i = 0; i < endpoints.length; ++i) {
                if (!(endpoints[i] instanceof InternalEndpoint) || !((InternalEndpoint)endpoints[i]).isLocal()) continue;
                this.onInternalEndpointRegistered(new EndpointEvent(endpoints[i], 0), true);
            }
        } else if (obj instanceof RemoveInfo) {
            ConsumerId id = (ConsumerId)((RemoveInfo)obj).getObjectId();
            this.subscriberSet.remove(id.getConnectionId());
            this.removeAllPackets(id.getConnectionId());
        }
    }

    private void removeAllPackets(String containerName) {
    }

    public ConnectionManager getConnectionManager() throws Exception {
        if (this.connectionManager == null) {
            ConnectionManagerFactoryBean cmfb = new ConnectionManagerFactoryBean();
            Object txmgr = (TransactionManager)this.broker.getContainer().getTransactionManager();
            if (!(txmgr instanceof RecoverableTransactionManager)) {
                txmgr = new RecoverableTransactionManagerWrapper((TransactionManager)txmgr);
            }
            cmfb.setTransactionManager((RecoverableTransactionManager)txmgr);
            cmfb.setTransaction("xa");
            cmfb.afterPropertiesSet();
            this.connectionManager = (ConnectionManager)cmfb.getObject();
        }
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public String toString() {
        return this.broker.getContainer().getName() + " JCAFlow";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJmsMessage(Destination dest, Serializable object, boolean persistent, boolean transacted) throws JMSException, SystemException {
        TransactionManager tm;
        if (transacted && (tm = (TransactionManager)this.getBroker().getContainer().getTransactionManager()).getStatus() == 1) {
            return;
        }
        Connection connection = this.managedConnectionFactory.createConnection();
        try {
            Session session = connection.createSession(transacted, transacted ? 0 : 1);
            ObjectMessage msg = session.createObjectMessage(object);
            MessageProducer producer = session.createProducer(dest);
            producer.setDeliveryMode(persistent ? 2 : 1);
            producer.send((Message)msg);
        }
        finally {
            connection.close();
        }
    }

    public static class RecoverableTransactionManagerWrapper
    implements RecoverableTransactionManager {
        private final TransactionManager txMgr;

        public RecoverableTransactionManagerWrapper(TransactionManager txMgr) {
            this.txMgr = txMgr;
        }

        public void begin() throws NotSupportedException, SystemException {
            this.txMgr.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.txMgr.commit();
        }

        public int getStatus() throws SystemException {
            return this.txMgr.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            return this.txMgr.getTransaction();
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.txMgr.resume(transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.txMgr.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.txMgr.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            this.txMgr.setTransactionTimeout(i);
        }

        public Transaction suspend() throws SystemException {
            return this.txMgr.suspend();
        }

        public void recoveryError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void recoverResourceManager(NamedXAResource namedXAResource) {
            throw new UnsupportedOperationException();
        }
    }

    class SimpleBootstrapContext
    implements BootstrapContext {
        private final WorkManager workManager;

        public SimpleBootstrapContext(WorkManager workManager) {
            this.workManager = workManager;
        }

        public Timer createTimer() throws UnavailableException {
            throw new UnsupportedOperationException();
        }

        public WorkManager getWorkManager() {
            return this.workManager;
        }

        public XATerminator getXATerminator() {
            throw new UnsupportedOperationException();
        }
    }

    class Connector {
        private ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        private MessageEndpointFactory endpointFactory;
        private ActiveMQActivationSpec spec;
        private Executor executor;

        public Connector(ActiveMQDestination destination, MessageListener listener, boolean transacted) {
            this.ra.setConnectionFactory(JCAFlow.this.connectionFactory);
            SingletonEndpointFactory ef = new SingletonEndpointFactory(listener, transacted ? JCAFlow.this.getTransactionManager() : null);
            ef.setName(JCAFlow.INBOUND_PREFIX + JCAFlow.this.broker.getContainer().getName());
            this.endpointFactory = ef;
            this.spec = new ActiveMQActivationSpec();
            this.spec.setActiveMQDestination(destination);
        }

        public void start() throws ResourceException {
            ExecutorFactory factory = JCAFlow.this.broker.getContainer().getExecutorFactory();
            this.executor = factory.createExecutor("flow.jca." + this.spec.getDestination());
            SimpleBootstrapContext context = new SimpleBootstrapContext((WorkManager)new WorkManagerWrapper(this.executor));
            this.ra.start((BootstrapContext)context);
            this.spec.setResourceAdapter((ResourceAdapter)this.ra);
            this.ra.endpointActivation(this.endpointFactory, (ActivationSpec)this.spec);
        }

        public void stop() {
            this.ra.endpointDeactivation(this.endpointFactory, (ActivationSpec)this.spec);
            this.ra.stop();
            this.executor.shutdown();
        }
    }
}

