/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.jbi.JBIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.finder.FactoryFinder;
import org.apache.servicemix.jbi.nmr.flow.Flow;
import org.apache.servicemix.jbi.util.IntrospectionSupport;
import org.apache.servicemix.jbi.util.URISupport;

public final class FlowProvider {
    private static final Log LOG = LogFactory.getLog(FlowProvider.class);
    private static final FactoryFinder FINDER = new FactoryFinder("META-INF/services/org/apache/servicemix/jbi/nmr/flow/");

    private FlowProvider() {
    }

    public static Flow getFlow(String flow) throws JBIException {
        String flowName = FlowProvider.getFlowName(flow);
        try {
            Object value = FINDER.newInstance(flowName);
            if (value instanceof Flow) {
                Map map;
                String query = FlowProvider.getQuery(flow);
                if (query != null && (map = URISupport.parseQuery(query)) != null && !map.isEmpty()) {
                    IntrospectionSupport.setProperties(value, map);
                }
                return (Flow)value;
            }
            throw new JBIException("No implementation found for: " + flow);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("getFlow(" + flow + " failed: " + e), (Throwable)e);
            throw new JBIException((Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)("getFlow(" + flow + " failed: " + e), (Throwable)e);
            throw new JBIException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("getFlow(" + flow + " failed: " + e), (Throwable)e);
            throw new JBIException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("getFlow(" + flow + " failed: " + e), (Throwable)e);
            throw new JBIException((Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("getFlow(" + flow + " failed: " + e), (Throwable)e);
            throw new JBIException((Throwable)e);
        }
    }

    public static String getFlowName(String str) {
        String result = str;
        int index = str.indexOf(63);
        if (index >= 0) {
            result = str.substring(0, index);
        }
        return result;
    }

    protected static String getQuery(String str) {
        String result = null;
        int index = str.indexOf(63);
        if (index >= 0 && index + 1 < str.length()) {
            result = str.substring(index + 1);
        }
        return result;
    }
}

