/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.monitoring;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.monitoring.ComponentStatsMBean;
import org.apache.servicemix.jbi.monitoring.MessagingStats;

public class ComponentStats
extends BaseLifeCycle
implements ComponentStatsMBean {
    public static final String STATS_FILE = "stats.csv";
    private static final Log LOG = LogFactory.getLog(ComponentStats.class);
    private ComponentMBeanImpl component;
    private MessagingStats stats;
    private File statsFile;
    private PrintWriter statsWriter;

    public ComponentStats(ComponentMBeanImpl component) {
        File componentRoot;
        this.component = component;
        this.stats = new MessagingStats(component.getName());
        if (component.getContext() != null && component.getContext().getEnvironment() != null && (componentRoot = component.getContext().getEnvironment().getComponentRoot()) != null && componentRoot.exists()) {
            this.statsFile = new File(componentRoot, STATS_FILE);
        }
    }

    MessagingStats getMessagingStats() {
        return this.stats;
    }

    void dumpStats() {
        if (this.statsFile != null) {
            try {
                if (this.statsWriter == null) {
                    FileOutputStream fileOut = new FileOutputStream(this.statsFile);
                    this.statsWriter = new PrintWriter(fileOut, true);
                    this.statsWriter.println(this.component.getComponentNameSpace().getName() + ":");
                    this.statsWriter.println("inboundExchanges,inboundExchangeRate,outboundExchanges,outboundExchangeRate");
                }
                long inbound = this.stats.getInboundExchanges().getCount();
                double inboundRate = this.stats.getInboundExchangeRate().getAveragePerSecond();
                long outbound = this.stats.getOutboundExchanges().getCount();
                double outboundRate = this.stats.getOutboundExchangeRate().getAveragePerSecond();
                this.statsWriter.println(inbound + "," + inboundRate + "," + outbound + "," + outboundRate);
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to dump stats", (Throwable)e);
            }
        }
    }

    void close() {
        if (this.statsWriter != null) {
            this.statsWriter.close();
            this.statsWriter = null;
        }
    }

    void incrementInbound() {
        this.stats.getInboundExchanges().increment();
        this.stats.getInboundExchangeRate().addTime();
    }

    void incrementOutbound() {
        this.stats.getOutboundExchanges().increment();
        this.stats.getOutboundExchangeRate().addTime();
    }

    public String getType() {
        return "Statistics";
    }

    public String getSubType() {
        return "Component";
    }

    public String getName() {
        return this.component.getName();
    }

    public String getDescription() {
        return "Statistics for component " + this.component.getDescription();
    }

    public long getInboundExchangeCount() {
        return this.stats.getInboundExchanges().getCount();
    }

    public double getInboundExchangeRate() {
        return this.stats.getInboundExchangeRate().getAveragePerSecond();
    }

    public long getOutboundExchangeCount() {
        return this.stats.getOutboundExchanges().getCount();
    }

    public double getOutboundExchangeRate() {
        return this.stats.getOutboundExchangeRate().getAveragePerSecond();
    }

    public int getInboundQueueSize() {
        if (this.component.getDeliveryChannel() != null) {
            return this.component.getDeliveryChannel().getQueueSize();
        }
        return 0;
    }

    public void reset() {
        this.stats.reset();
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "inboundQueueSize", "size of the inbound queue");
        helper.addAttribute(this.getObjectToManage(), "inboundExchangeCount", "count of inbound exchanges");
        helper.addAttribute(this.getObjectToManage(), "outboundExchangeCount", "count of outbound exchanges");
        helper.addAttribute(this.getObjectToManage(), "inboundExchangeRate", "rate of inbound exchanges/sec");
        helper.addAttribute(this.getObjectToManage(), "outboundExchangeRate", "rate of outbound exchanges/sec");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "reset", "reset statistic counters");
        return helper.getOperationInfos();
    }
}

